/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserProficienciesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListUserProficienciesResponse.Builder, ListUserProficienciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListUserProficienciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<UserProficiency>> USER_PROFICIENCY_LIST_FIELD = SdkField
            .<List<UserProficiency>> builder(MarshallingType.LIST)
            .memberName("UserProficiencyList")
            .getter(getter(ListUserProficienciesResponse::userProficiencyList))
            .setter(setter(Builder::userProficiencyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProficiencyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserProficiency> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserProficiency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ListUserProficienciesResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(ListUserProficienciesResponse::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            USER_PROFICIENCY_LIST_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<UserProficiency> userProficiencyList;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private ListUserProficienciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.userProficiencyList = builder.userProficiencyList;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserProficiencyList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserProficiencyList() {
        return userProficiencyList != null && !(userProficiencyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the user proficiencies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserProficiencyList} method.
     * </p>
     * 
     * @return Information about the user proficiencies.
     */
    public final List<UserProficiency> userProficiencyList() {
        return userProficiencyList;
    }

    /**
     * <p>
     * The last time that the user's proficiencies are were modified.
     * </p>
     * 
     * @return The last time that the user's proficiencies are were modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The region in which a user's proficiencies were last modified.
     * </p>
     * 
     * @return The region in which a user's proficiencies were last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserProficiencyList() ? userProficiencyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserProficienciesResponse)) {
            return false;
        }
        ListUserProficienciesResponse other = (ListUserProficienciesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasUserProficiencyList() == other.hasUserProficiencyList()
                && Objects.equals(userProficiencyList(), other.userProficiencyList())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUserProficienciesResponse").add("NextToken", nextToken())
                .add("UserProficiencyList", hasUserProficiencyList() ? userProficiencyList() : null)
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "UserProficiencyList":
            return Optional.ofNullable(clazz.cast(userProficiencyList()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("UserProficiencyList", USER_PROFICIENCY_LIST_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUserProficienciesResponse, T> g) {
        return obj -> g.apply((ListUserProficienciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUserProficienciesResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the user proficiencies.
         * </p>
         * 
         * @param userProficiencyList
         *        Information about the user proficiencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProficiencyList(Collection<UserProficiency> userProficiencyList);

        /**
         * <p>
         * Information about the user proficiencies.
         * </p>
         * 
         * @param userProficiencyList
         *        Information about the user proficiencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProficiencyList(UserProficiency... userProficiencyList);

        /**
         * <p>
         * Information about the user proficiencies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.UserProficiency.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.UserProficiency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.UserProficiency.Builder#build()} is called immediately
         * and its result is passed to {@link #userProficiencyList(List<UserProficiency>)}.
         * 
         * @param userProficiencyList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.UserProficiency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProficiencyList(java.util.Collection<UserProficiency>)
         */
        Builder userProficiencyList(Consumer<UserProficiency.Builder>... userProficiencyList);

        /**
         * <p>
         * The last time that the user's proficiencies are were modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time that the user's proficiencies are were modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The region in which a user's proficiencies were last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The region in which a user's proficiencies were last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<UserProficiency> userProficiencyList = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserProficienciesResponse model) {
            super(model);
            nextToken(model.nextToken);
            userProficiencyList(model.userProficiencyList);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UserProficiency.Builder> getUserProficiencyList() {
            List<UserProficiency.Builder> result = UserProficiencyListCopier.copyToBuilder(this.userProficiencyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProficiencyList(Collection<UserProficiency.BuilderImpl> userProficiencyList) {
            this.userProficiencyList = UserProficiencyListCopier.copyFromBuilder(userProficiencyList);
        }

        @Override
        public final Builder userProficiencyList(Collection<UserProficiency> userProficiencyList) {
            this.userProficiencyList = UserProficiencyListCopier.copy(userProficiencyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProficiencyList(UserProficiency... userProficiencyList) {
            userProficiencyList(Arrays.asList(userProficiencyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProficiencyList(Consumer<UserProficiency.Builder>... userProficiencyList) {
            userProficiencyList(Stream.of(userProficiencyList).map(c -> UserProficiency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public ListUserProficienciesResponse build() {
            return new ListUserProficienciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
