/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about which channels are supported, and how many contacts an agent can have on a channel
 * simultaneously.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaConcurrency implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaConcurrency.Builder, MediaConcurrency> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(MediaConcurrency::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<Integer> CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Concurrency").getter(getter(MediaConcurrency::concurrency)).setter(setter(Builder::concurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Concurrency").build()).build();

    private static final SdkField<CrossChannelBehavior> CROSS_CHANNEL_BEHAVIOR_FIELD = SdkField
            .<CrossChannelBehavior> builder(MarshallingType.SDK_POJO).memberName("CrossChannelBehavior")
            .getter(getter(MediaConcurrency::crossChannelBehavior)).setter(setter(Builder::crossChannelBehavior))
            .constructor(CrossChannelBehavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossChannelBehavior").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD,
            CONCURRENCY_FIELD, CROSS_CHANNEL_BEHAVIOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channel;

    private final Integer concurrency;

    private final CrossChannelBehavior crossChannelBehavior;

    private MediaConcurrency(BuilderImpl builder) {
        this.channel = builder.channel;
        this.concurrency = builder.concurrency;
        this.crossChannelBehavior = builder.crossChannelBehavior;
    }

    /**
     * <p>
     * The channels that agents can handle in the Contact Control Panel (CCP).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channels that agents can handle in the Contact Control Panel (CCP).
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * The channels that agents can handle in the Contact Control Panel (CCP).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channels that agents can handle in the Contact Control Panel (CCP).
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * <p>
     * The number of contacts an agent can have on a channel simultaneously.
     * </p>
     * <p>
     * Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.
     * </p>
     * <p>
     * Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.
     * </p>
     * <p>
     * Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.
     * </p>
     * 
     * @return The number of contacts an agent can have on a channel simultaneously.</p>
     *         <p>
     *         Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.
     *         </p>
     *         <p>
     *         Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.
     *         </p>
     *         <p>
     *         Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.
     */
    public final Integer concurrency() {
        return concurrency;
    }

    /**
     * <p>
     * Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For
     * example, this allows you to offer an agent a different contact from another channel when they are currently
     * working with a contact from a Voice channel.
     * </p>
     * 
     * @return Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For
     *         example, this allows you to offer an agent a different contact from another channel when they are
     *         currently working with a contact from a Voice channel.
     */
    public final CrossChannelBehavior crossChannelBehavior() {
        return crossChannelBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(concurrency());
        hashCode = 31 * hashCode + Objects.hashCode(crossChannelBehavior());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConcurrency)) {
            return false;
        }
        MediaConcurrency other = (MediaConcurrency) obj;
        return Objects.equals(channelAsString(), other.channelAsString()) && Objects.equals(concurrency(), other.concurrency())
                && Objects.equals(crossChannelBehavior(), other.crossChannelBehavior());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaConcurrency").add("Channel", channelAsString()).add("Concurrency", concurrency())
                .add("CrossChannelBehavior", crossChannelBehavior()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "Concurrency":
            return Optional.ofNullable(clazz.cast(concurrency()));
        case "CrossChannelBehavior":
            return Optional.ofNullable(clazz.cast(crossChannelBehavior()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Channel", CHANNEL_FIELD);
        map.put("Concurrency", CONCURRENCY_FIELD);
        map.put("CrossChannelBehavior", CROSS_CHANNEL_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaConcurrency, T> g) {
        return obj -> g.apply((MediaConcurrency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaConcurrency> {
        /**
         * <p>
         * The channels that agents can handle in the Contact Control Panel (CCP).
         * </p>
         * 
         * @param channel
         *        The channels that agents can handle in the Contact Control Panel (CCP).
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channels that agents can handle in the Contact Control Panel (CCP).
         * </p>
         * 
         * @param channel
         *        The channels that agents can handle in the Contact Control Panel (CCP).
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);

        /**
         * <p>
         * The number of contacts an agent can have on a channel simultaneously.
         * </p>
         * <p>
         * Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.
         * </p>
         * <p>
         * Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.
         * </p>
         * <p>
         * Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.
         * </p>
         * 
         * @param concurrency
         *        The number of contacts an agent can have on a channel simultaneously.</p>
         *        <p>
         *        Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.
         *        </p>
         *        <p>
         *        Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.
         *        </p>
         *        <p>
         *        Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrency(Integer concurrency);

        /**
         * <p>
         * Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For
         * example, this allows you to offer an agent a different contact from another channel when they are currently
         * working with a contact from a Voice channel.
         * </p>
         * 
         * @param crossChannelBehavior
         *        Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile.
         *        For example, this allows you to offer an agent a different contact from another channel when they are
         *        currently working with a contact from a Voice channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossChannelBehavior(CrossChannelBehavior crossChannelBehavior);

        /**
         * <p>
         * Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For
         * example, this allows you to offer an agent a different contact from another channel when they are currently
         * working with a contact from a Voice channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link CrossChannelBehavior.Builder} avoiding
         * the need to create one manually via {@link CrossChannelBehavior#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CrossChannelBehavior.Builder#build()} is called immediately and
         * its result is passed to {@link #crossChannelBehavior(CrossChannelBehavior)}.
         * 
         * @param crossChannelBehavior
         *        a consumer that will call methods on {@link CrossChannelBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossChannelBehavior(CrossChannelBehavior)
         */
        default Builder crossChannelBehavior(Consumer<CrossChannelBehavior.Builder> crossChannelBehavior) {
            return crossChannelBehavior(CrossChannelBehavior.builder().applyMutation(crossChannelBehavior).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String channel;

        private Integer concurrency;

        private CrossChannelBehavior crossChannelBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConcurrency model) {
            channel(model.channel);
            concurrency(model.concurrency);
            crossChannelBehavior(model.crossChannelBehavior);
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final Integer getConcurrency() {
            return concurrency;
        }

        public final void setConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
        }

        @Override
        public final Builder concurrency(Integer concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public final CrossChannelBehavior.Builder getCrossChannelBehavior() {
            return crossChannelBehavior != null ? crossChannelBehavior.toBuilder() : null;
        }

        public final void setCrossChannelBehavior(CrossChannelBehavior.BuilderImpl crossChannelBehavior) {
            this.crossChannelBehavior = crossChannelBehavior != null ? crossChannelBehavior.build() : null;
        }

        @Override
        public final Builder crossChannelBehavior(CrossChannelBehavior crossChannelBehavior) {
            this.crossChannelBehavior = crossChannelBehavior;
            return this;
        }

        @Override
        public MediaConcurrency build() {
            return new MediaConcurrency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
