/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricV2 implements SdkPojo, Serializable, ToCopyableBuilder<MetricV2.Builder, MetricV2> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MetricV2::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ThresholdV2>> THRESHOLD_FIELD = SdkField
            .<List<ThresholdV2>> builder(MarshallingType.LIST)
            .memberName("Threshold")
            .getter(getter(MetricV2::threshold))
            .setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThresholdV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThresholdV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MetricFilterV2>> METRIC_FILTERS_FIELD = SdkField
            .<List<MetricFilterV2>> builder(MarshallingType.LIST)
            .memberName("MetricFilters")
            .getter(getter(MetricV2::metricFilters))
            .setter(setter(Builder::metricFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricFilterV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricFilterV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, THRESHOLD_FIELD,
            METRIC_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<ThresholdV2> threshold;

    private final List<MetricFilterV2> metricFilters;

    private MetricV2(BuilderImpl builder) {
        this.name = builder.name;
        this.threshold = builder.threshold;
        this.metricFilters = builder.metricFilters;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * <important>
     * <p>
     * This parameter is required. The following Required = No is incorrect.
     * </p>
     * </important>
     * 
     * @return The name of the metric.</p> <important>
     *         <p>
     *         This parameter is required. The following Required = No is incorrect.
     *         </p>
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Threshold property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThreshold() {
        return threshold != null && !(threshold instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the threshold for service level metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreshold} method.
     * </p>
     * 
     * @return Contains information about the threshold for service level metrics.
     */
    public final List<ThresholdV2> threshold() {
        return threshold;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricFilters() {
        return metricFilters != null && !(metricFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the filters to be used when returning data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricFilters} method.
     * </p>
     * 
     * @return Contains the filters to be used when returning data.
     */
    public final List<MetricFilterV2> metricFilters() {
        return metricFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasThreshold() ? threshold() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricFilters() ? metricFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricV2)) {
            return false;
        }
        MetricV2 other = (MetricV2) obj;
        return Objects.equals(name(), other.name()) && hasThreshold() == other.hasThreshold()
                && Objects.equals(threshold(), other.threshold()) && hasMetricFilters() == other.hasMetricFilters()
                && Objects.equals(metricFilters(), other.metricFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricV2").add("Name", name()).add("Threshold", hasThreshold() ? threshold() : null)
                .add("MetricFilters", hasMetricFilters() ? metricFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "MetricFilters":
            return Optional.ofNullable(clazz.cast(metricFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("MetricFilters", METRIC_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricV2, T> g) {
        return obj -> g.apply((MetricV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricV2> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * <important>
         * <p>
         * This parameter is required. The following Required = No is incorrect.
         * </p>
         * </important>
         * 
         * @param name
         *        The name of the metric.</p> <important>
         *        <p>
         *        This parameter is required. The following Required = No is incorrect.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains information about the threshold for service level metrics.
         * </p>
         * 
         * @param threshold
         *        Contains information about the threshold for service level metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Collection<ThresholdV2> threshold);

        /**
         * <p>
         * Contains information about the threshold for service level metrics.
         * </p>
         * 
         * @param threshold
         *        Contains information about the threshold for service level metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(ThresholdV2... threshold);

        /**
         * <p>
         * Contains information about the threshold for service level metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ThresholdV2.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.ThresholdV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ThresholdV2.Builder#build()} is called immediately and
         * its result is passed to {@link #threshold(List<ThresholdV2>)}.
         * 
         * @param threshold
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ThresholdV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threshold(java.util.Collection<ThresholdV2>)
         */
        Builder threshold(Consumer<ThresholdV2.Builder>... threshold);

        /**
         * <p>
         * Contains the filters to be used when returning data.
         * </p>
         * 
         * @param metricFilters
         *        Contains the filters to be used when returning data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricFilters(Collection<MetricFilterV2> metricFilters);

        /**
         * <p>
         * Contains the filters to be used when returning data.
         * </p>
         * 
         * @param metricFilters
         *        Contains the filters to be used when returning data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricFilters(MetricFilterV2... metricFilters);

        /**
         * <p>
         * Contains the filters to be used when returning data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.MetricFilterV2.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.MetricFilterV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.MetricFilterV2.Builder#build()} is called immediately
         * and its result is passed to {@link #metricFilters(List<MetricFilterV2>)}.
         * 
         * @param metricFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.MetricFilterV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricFilters(java.util.Collection<MetricFilterV2>)
         */
        Builder metricFilters(Consumer<MetricFilterV2.Builder>... metricFilters);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<ThresholdV2> threshold = DefaultSdkAutoConstructList.getInstance();

        private List<MetricFilterV2> metricFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricV2 model) {
            name(model.name);
            threshold(model.threshold);
            metricFilters(model.metricFilters);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ThresholdV2.Builder> getThreshold() {
            List<ThresholdV2.Builder> result = ThresholdCollectionsCopier.copyToBuilder(this.threshold);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreshold(Collection<ThresholdV2.BuilderImpl> threshold) {
            this.threshold = ThresholdCollectionsCopier.copyFromBuilder(threshold);
        }

        @Override
        public final Builder threshold(Collection<ThresholdV2> threshold) {
            this.threshold = ThresholdCollectionsCopier.copy(threshold);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threshold(ThresholdV2... threshold) {
            threshold(Arrays.asList(threshold));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threshold(Consumer<ThresholdV2.Builder>... threshold) {
            threshold(Stream.of(threshold).map(c -> ThresholdV2.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricFilterV2.Builder> getMetricFilters() {
            List<MetricFilterV2.Builder> result = MetricFiltersV2ListCopier.copyToBuilder(this.metricFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricFilters(Collection<MetricFilterV2.BuilderImpl> metricFilters) {
            this.metricFilters = MetricFiltersV2ListCopier.copyFromBuilder(metricFilters);
        }

        @Override
        public final Builder metricFilters(Collection<MetricFilterV2> metricFilters) {
            this.metricFilters = MetricFiltersV2ListCopier.copy(metricFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(MetricFilterV2... metricFilters) {
            metricFilters(Arrays.asList(metricFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricFilters(Consumer<MetricFilterV2.Builder>... metricFilters) {
            metricFilters(Stream.of(metricFilters).map(c -> MetricFilterV2.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MetricV2 build() {
            return new MetricV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
