/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search criteria to be used to search tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceTagsSearchCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceTagsSearchCriteria.Builder, ResourceTagsSearchCriteria> {
    private static final SdkField<TagSearchCondition> TAG_SEARCH_CONDITION_FIELD = SdkField
            .<TagSearchCondition> builder(MarshallingType.SDK_POJO).memberName("TagSearchCondition")
            .getter(getter(ResourceTagsSearchCriteria::tagSearchCondition)).setter(setter(Builder::tagSearchCondition))
            .constructor(TagSearchCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSearchCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_SEARCH_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TagSearchCondition tagSearchCondition;

    private ResourceTagsSearchCriteria(BuilderImpl builder) {
        this.tagSearchCondition = builder.tagSearchCondition;
    }

    /**
     * <p>
     * The search criteria to be used to return tags.
     * </p>
     * 
     * @return The search criteria to be used to return tags.
     */
    public final TagSearchCondition tagSearchCondition() {
        return tagSearchCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagSearchCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTagsSearchCriteria)) {
            return false;
        }
        ResourceTagsSearchCriteria other = (ResourceTagsSearchCriteria) obj;
        return Objects.equals(tagSearchCondition(), other.tagSearchCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceTagsSearchCriteria").add("TagSearchCondition", tagSearchCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagSearchCondition":
            return Optional.ofNullable(clazz.cast(tagSearchCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TagSearchCondition", TAG_SEARCH_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceTagsSearchCriteria, T> g) {
        return obj -> g.apply((ResourceTagsSearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceTagsSearchCriteria> {
        /**
         * <p>
         * The search criteria to be used to return tags.
         * </p>
         * 
         * @param tagSearchCondition
         *        The search criteria to be used to return tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSearchCondition(TagSearchCondition tagSearchCondition);

        /**
         * <p>
         * The search criteria to be used to return tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagSearchCondition.Builder} avoiding the
         * need to create one manually via {@link TagSearchCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagSearchCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #tagSearchCondition(TagSearchCondition)}.
         * 
         * @param tagSearchCondition
         *        a consumer that will call methods on {@link TagSearchCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSearchCondition(TagSearchCondition)
         */
        default Builder tagSearchCondition(Consumer<TagSearchCondition.Builder> tagSearchCondition) {
            return tagSearchCondition(TagSearchCondition.builder().applyMutation(tagSearchCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TagSearchCondition tagSearchCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTagsSearchCriteria model) {
            tagSearchCondition(model.tagSearchCondition);
        }

        public final TagSearchCondition.Builder getTagSearchCondition() {
            return tagSearchCondition != null ? tagSearchCondition.toBuilder() : null;
        }

        public final void setTagSearchCondition(TagSearchCondition.BuilderImpl tagSearchCondition) {
            this.tagSearchCondition = tagSearchCondition != null ? tagSearchCondition.build() : null;
        }

        @Override
        public final Builder tagSearchCondition(TagSearchCondition tagSearchCondition) {
            this.tagSearchCondition = tagSearchCondition;
            return this;
        }

        @Override
        public ResourceTagsSearchCriteria build() {
            return new ResourceTagsSearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
