/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a routing profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingProfile implements SdkPojo, Serializable, ToCopyableBuilder<RoutingProfile.Builder, RoutingProfile> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(RoutingProfile::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RoutingProfile::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileArn").getter(getter(RoutingProfile::routingProfileArn))
            .setter(setter(Builder::routingProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileArn").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileId").getter(getter(RoutingProfile::routingProfileId))
            .setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RoutingProfile::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<MediaConcurrency>> MEDIA_CONCURRENCIES_FIELD = SdkField
            .<List<MediaConcurrency>> builder(MarshallingType.LIST)
            .memberName("MediaConcurrencies")
            .getter(getter(RoutingProfile::mediaConcurrencies))
            .setter(setter(Builder::mediaConcurrencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcurrencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaConcurrency> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaConcurrency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_OUTBOUND_QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultOutboundQueueId").getter(getter(RoutingProfile::defaultOutboundQueueId))
            .setter(setter(Builder::defaultOutboundQueueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOutboundQueueId").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(RoutingProfile::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_QUEUES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfAssociatedQueues").getter(getter(RoutingProfile::numberOfAssociatedQueues))
            .setter(setter(Builder::numberOfAssociatedQueues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociatedQueues").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_USERS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfAssociatedUsers").getter(getter(RoutingProfile::numberOfAssociatedUsers))
            .setter(setter(Builder::numberOfAssociatedUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociatedUsers").build())
            .build();

    private static final SdkField<String> AGENT_AVAILABILITY_TIMER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentAvailabilityTimer").getter(getter(RoutingProfile::agentAvailabilityTimerAsString))
            .setter(setter(Builder::agentAvailabilityTimer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentAvailabilityTimer").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(RoutingProfile::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(RoutingProfile::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(RoutingProfile::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_QUEUE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedQueueIds")
            .getter(getter(RoutingProfile::associatedQueueIds))
            .setter(setter(Builder::associatedQueueIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedQueueIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            ROUTING_PROFILE_ARN_FIELD, ROUTING_PROFILE_ID_FIELD, DESCRIPTION_FIELD, MEDIA_CONCURRENCIES_FIELD,
            DEFAULT_OUTBOUND_QUEUE_ID_FIELD, TAGS_FIELD, NUMBER_OF_ASSOCIATED_QUEUES_FIELD, NUMBER_OF_ASSOCIATED_USERS_FIELD,
            AGENT_AVAILABILITY_TIMER_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD, IS_DEFAULT_FIELD,
            ASSOCIATED_QUEUE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String name;

    private final String routingProfileArn;

    private final String routingProfileId;

    private final String description;

    private final List<MediaConcurrency> mediaConcurrencies;

    private final String defaultOutboundQueueId;

    private final Map<String, String> tags;

    private final Long numberOfAssociatedQueues;

    private final Long numberOfAssociatedUsers;

    private final String agentAvailabilityTimer;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private final Boolean isDefault;

    private final List<String> associatedQueueIds;

    private RoutingProfile(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.routingProfileArn = builder.routingProfileArn;
        this.routingProfileId = builder.routingProfileId;
        this.description = builder.description;
        this.mediaConcurrencies = builder.mediaConcurrencies;
        this.defaultOutboundQueueId = builder.defaultOutboundQueueId;
        this.tags = builder.tags;
        this.numberOfAssociatedQueues = builder.numberOfAssociatedQueues;
        this.numberOfAssociatedUsers = builder.numberOfAssociatedUsers;
        this.agentAvailabilityTimer = builder.agentAvailabilityTimer;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.isDefault = builder.isDefault;
        this.associatedQueueIds = builder.associatedQueueIds;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the routing profile.
     * </p>
     * 
     * @return The name of the routing profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the routing profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the routing profile.
     */
    public final String routingProfileArn() {
        return routingProfileArn;
    }

    /**
     * <p>
     * The identifier of the routing profile.
     * </p>
     * 
     * @return The identifier of the routing profile.
     */
    public final String routingProfileId() {
        return routingProfileId;
    }

    /**
     * <p>
     * The description of the routing profile.
     * </p>
     * 
     * @return The description of the routing profile.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaConcurrencies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaConcurrencies() {
        return mediaConcurrencies != null && !(mediaConcurrencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaConcurrencies} method.
     * </p>
     * 
     * @return The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    public final List<MediaConcurrency> mediaConcurrencies() {
        return mediaConcurrencies;
    }

    /**
     * <p>
     * The identifier of the default outbound queue for this routing profile.
     * </p>
     * 
     * @return The identifier of the default outbound queue for this routing profile.
     */
    public final String defaultOutboundQueueId() {
        return defaultOutboundQueueId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The number of associated queues in routing profile.
     * </p>
     * 
     * @return The number of associated queues in routing profile.
     */
    public final Long numberOfAssociatedQueues() {
        return numberOfAssociatedQueues;
    }

    /**
     * <p>
     * The number of associated users in routing profile.
     * </p>
     * 
     * @return The number of associated users in routing profile.
     */
    public final Long numberOfAssociatedUsers() {
        return numberOfAssociatedUsers;
    }

    /**
     * <p>
     * Whether agents with this routing profile will have their routing order calculated based on <i>time since their
     * last inbound contact</i> or <i>longest idle time</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentAvailabilityTimer} will return {@link AgentAvailabilityTimer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #agentAvailabilityTimerAsString}.
     * </p>
     * 
     * @return Whether agents with this routing profile will have their routing order calculated based on <i>time since
     *         their last inbound contact</i> or <i>longest idle time</i>.
     * @see AgentAvailabilityTimer
     */
    public final AgentAvailabilityTimer agentAvailabilityTimer() {
        return AgentAvailabilityTimer.fromValue(agentAvailabilityTimer);
    }

    /**
     * <p>
     * Whether agents with this routing profile will have their routing order calculated based on <i>time since their
     * last inbound contact</i> or <i>longest idle time</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentAvailabilityTimer} will return {@link AgentAvailabilityTimer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #agentAvailabilityTimerAsString}.
     * </p>
     * 
     * @return Whether agents with this routing profile will have their routing order calculated based on <i>time since
     *         their last inbound contact</i> or <i>longest idle time</i>.
     * @see AgentAvailabilityTimer
     */
    public final String agentAvailabilityTimerAsString() {
        return agentAvailabilityTimer;
    }

    /**
     * <p>
     * The timestamp when this resource was last modified.
     * </p>
     * 
     * @return The timestamp when this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Web Services Region where this resource was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where this resource was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    /**
     * <p>
     * Whether this a default routing profile.
     * </p>
     * 
     * @return Whether this a default routing profile.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedQueueIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedQueueIds() {
        return associatedQueueIds != null && !(associatedQueueIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the associated queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedQueueIds} method.
     * </p>
     * 
     * @return The IDs of the associated queue.
     */
    public final List<String> associatedQueueIds() {
        return associatedQueueIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaConcurrencies() ? mediaConcurrencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultOutboundQueueId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedQueues());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedUsers());
        hashCode = 31 * hashCode + Objects.hashCode(agentAvailabilityTimerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedQueueIds() ? associatedQueueIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfile)) {
            return false;
        }
        RoutingProfile other = (RoutingProfile) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(routingProfileArn(), other.routingProfileArn())
                && Objects.equals(routingProfileId(), other.routingProfileId())
                && Objects.equals(description(), other.description()) && hasMediaConcurrencies() == other.hasMediaConcurrencies()
                && Objects.equals(mediaConcurrencies(), other.mediaConcurrencies())
                && Objects.equals(defaultOutboundQueueId(), other.defaultOutboundQueueId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(numberOfAssociatedQueues(), other.numberOfAssociatedQueues())
                && Objects.equals(numberOfAssociatedUsers(), other.numberOfAssociatedUsers())
                && Objects.equals(agentAvailabilityTimerAsString(), other.agentAvailabilityTimerAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion())
                && Objects.equals(isDefault(), other.isDefault()) && hasAssociatedQueueIds() == other.hasAssociatedQueueIds()
                && Objects.equals(associatedQueueIds(), other.associatedQueueIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingProfile").add("InstanceId", instanceId()).add("Name", name())
                .add("RoutingProfileArn", routingProfileArn()).add("RoutingProfileId", routingProfileId())
                .add("Description", description())
                .add("MediaConcurrencies", hasMediaConcurrencies() ? mediaConcurrencies() : null)
                .add("DefaultOutboundQueueId", defaultOutboundQueueId()).add("Tags", hasTags() ? tags() : null)
                .add("NumberOfAssociatedQueues", numberOfAssociatedQueues())
                .add("NumberOfAssociatedUsers", numberOfAssociatedUsers())
                .add("AgentAvailabilityTimer", agentAvailabilityTimerAsString()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedRegion", lastModifiedRegion()).add("IsDefault", isDefault())
                .add("AssociatedQueueIds", hasAssociatedQueueIds() ? associatedQueueIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoutingProfileArn":
            return Optional.ofNullable(clazz.cast(routingProfileArn()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MediaConcurrencies":
            return Optional.ofNullable(clazz.cast(mediaConcurrencies()));
        case "DefaultOutboundQueueId":
            return Optional.ofNullable(clazz.cast(defaultOutboundQueueId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NumberOfAssociatedQueues":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedQueues()));
        case "NumberOfAssociatedUsers":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedUsers()));
        case "AgentAvailabilityTimer":
            return Optional.ofNullable(clazz.cast(agentAvailabilityTimerAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "AssociatedQueueIds":
            return Optional.ofNullable(clazz.cast(associatedQueueIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RoutingProfileArn", ROUTING_PROFILE_ARN_FIELD);
        map.put("RoutingProfileId", ROUTING_PROFILE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MediaConcurrencies", MEDIA_CONCURRENCIES_FIELD);
        map.put("DefaultOutboundQueueId", DEFAULT_OUTBOUND_QUEUE_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NumberOfAssociatedQueues", NUMBER_OF_ASSOCIATED_QUEUES_FIELD);
        map.put("NumberOfAssociatedUsers", NUMBER_OF_ASSOCIATED_USERS_FIELD);
        map.put("AgentAvailabilityTimer", AGENT_AVAILABILITY_TIMER_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("AssociatedQueueIds", ASSOCIATED_QUEUE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfile, T> g) {
        return obj -> g.apply((RoutingProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingProfile> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the routing profile.
         * </p>
         * 
         * @param name
         *        The name of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the routing profile.
         * </p>
         * 
         * @param routingProfileArn
         *        The Amazon Resource Name (ARN) of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileArn(String routingProfileArn);

        /**
         * <p>
         * The identifier of the routing profile.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * The description of the routing profile.
         * </p>
         * 
         * @param description
         *        The description of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * 
         * @param mediaConcurrencies
         *        The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies);

        /**
         * <p>
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * 
         * @param mediaConcurrencies
         *        The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConcurrencies(MediaConcurrency... mediaConcurrencies);

        /**
         * <p>
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.MediaConcurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaConcurrencies(List<MediaConcurrency>)}.
         * 
         * @param mediaConcurrencies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConcurrencies(java.util.Collection<MediaConcurrency>)
         */
        Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder>... mediaConcurrencies);

        /**
         * <p>
         * The identifier of the default outbound queue for this routing profile.
         * </p>
         * 
         * @param defaultOutboundQueueId
         *        The identifier of the default outbound queue for this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOutboundQueueId(String defaultOutboundQueueId);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The number of associated queues in routing profile.
         * </p>
         * 
         * @param numberOfAssociatedQueues
         *        The number of associated queues in routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedQueues(Long numberOfAssociatedQueues);

        /**
         * <p>
         * The number of associated users in routing profile.
         * </p>
         * 
         * @param numberOfAssociatedUsers
         *        The number of associated users in routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedUsers(Long numberOfAssociatedUsers);

        /**
         * <p>
         * Whether agents with this routing profile will have their routing order calculated based on <i>time since
         * their last inbound contact</i> or <i>longest idle time</i>.
         * </p>
         * 
         * @param agentAvailabilityTimer
         *        Whether agents with this routing profile will have their routing order calculated based on <i>time
         *        since their last inbound contact</i> or <i>longest idle time</i>.
         * @see AgentAvailabilityTimer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentAvailabilityTimer
         */
        Builder agentAvailabilityTimer(String agentAvailabilityTimer);

        /**
         * <p>
         * Whether agents with this routing profile will have their routing order calculated based on <i>time since
         * their last inbound contact</i> or <i>longest idle time</i>.
         * </p>
         * 
         * @param agentAvailabilityTimer
         *        Whether agents with this routing profile will have their routing order calculated based on <i>time
         *        since their last inbound contact</i> or <i>longest idle time</i>.
         * @see AgentAvailabilityTimer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentAvailabilityTimer
         */
        Builder agentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer);

        /**
         * <p>
         * The timestamp when this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Web Services Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The Amazon Web Services Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);

        /**
         * <p>
         * Whether this a default routing profile.
         * </p>
         * 
         * @param isDefault
         *        Whether this a default routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The IDs of the associated queue.
         * </p>
         * 
         * @param associatedQueueIds
         *        The IDs of the associated queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedQueueIds(Collection<String> associatedQueueIds);

        /**
         * <p>
         * The IDs of the associated queue.
         * </p>
         * 
         * @param associatedQueueIds
         *        The IDs of the associated queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedQueueIds(String... associatedQueueIds);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private String routingProfileArn;

        private String routingProfileId;

        private String description;

        private List<MediaConcurrency> mediaConcurrencies = DefaultSdkAutoConstructList.getInstance();

        private String defaultOutboundQueueId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Long numberOfAssociatedQueues;

        private Long numberOfAssociatedUsers;

        private String agentAvailabilityTimer;

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private Boolean isDefault;

        private List<String> associatedQueueIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfile model) {
            instanceId(model.instanceId);
            name(model.name);
            routingProfileArn(model.routingProfileArn);
            routingProfileId(model.routingProfileId);
            description(model.description);
            mediaConcurrencies(model.mediaConcurrencies);
            defaultOutboundQueueId(model.defaultOutboundQueueId);
            tags(model.tags);
            numberOfAssociatedQueues(model.numberOfAssociatedQueues);
            numberOfAssociatedUsers(model.numberOfAssociatedUsers);
            agentAvailabilityTimer(model.agentAvailabilityTimer);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
            isDefault(model.isDefault);
            associatedQueueIds(model.associatedQueueIds);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoutingProfileArn() {
            return routingProfileArn;
        }

        public final void setRoutingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
        }

        @Override
        public final Builder routingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
            return this;
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<MediaConcurrency.Builder> getMediaConcurrencies() {
            List<MediaConcurrency.Builder> result = MediaConcurrenciesCopier.copyToBuilder(this.mediaConcurrencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConcurrencies(Collection<MediaConcurrency.BuilderImpl> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copyFromBuilder(mediaConcurrencies);
        }

        @Override
        public final Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copy(mediaConcurrencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(MediaConcurrency... mediaConcurrencies) {
            mediaConcurrencies(Arrays.asList(mediaConcurrencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder>... mediaConcurrencies) {
            mediaConcurrencies(Stream.of(mediaConcurrencies).map(c -> MediaConcurrency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultOutboundQueueId() {
            return defaultOutboundQueueId;
        }

        public final void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
        }

        @Override
        public final Builder defaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Long getNumberOfAssociatedQueues() {
            return numberOfAssociatedQueues;
        }

        public final void setNumberOfAssociatedQueues(Long numberOfAssociatedQueues) {
            this.numberOfAssociatedQueues = numberOfAssociatedQueues;
        }

        @Override
        public final Builder numberOfAssociatedQueues(Long numberOfAssociatedQueues) {
            this.numberOfAssociatedQueues = numberOfAssociatedQueues;
            return this;
        }

        public final Long getNumberOfAssociatedUsers() {
            return numberOfAssociatedUsers;
        }

        public final void setNumberOfAssociatedUsers(Long numberOfAssociatedUsers) {
            this.numberOfAssociatedUsers = numberOfAssociatedUsers;
        }

        @Override
        public final Builder numberOfAssociatedUsers(Long numberOfAssociatedUsers) {
            this.numberOfAssociatedUsers = numberOfAssociatedUsers;
            return this;
        }

        public final String getAgentAvailabilityTimer() {
            return agentAvailabilityTimer;
        }

        public final void setAgentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
        }

        @Override
        public final Builder agentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
            return this;
        }

        @Override
        public final Builder agentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer) {
            this.agentAvailabilityTimer(agentAvailabilityTimer == null ? null : agentAvailabilityTimer.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final Collection<String> getAssociatedQueueIds() {
            if (associatedQueueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedQueueIds;
        }

        public final void setAssociatedQueueIds(Collection<String> associatedQueueIds) {
            this.associatedQueueIds = AssociatedQueueIdListCopier.copy(associatedQueueIds);
        }

        @Override
        public final Builder associatedQueueIds(Collection<String> associatedQueueIds) {
            this.associatedQueueIds = AssociatedQueueIdListCopier.copy(associatedQueueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedQueueIds(String... associatedQueueIds) {
            associatedQueueIds(Arrays.asList(associatedQueueIds));
            return this;
        }

        @Override
        public RoutingProfile build() {
            return new RoutingProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
