/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Rule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(Rule::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(Rule::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<RuleTriggerEventSource> TRIGGER_EVENT_SOURCE_FIELD = SdkField
            .<RuleTriggerEventSource> builder(MarshallingType.SDK_POJO).memberName("TriggerEventSource")
            .getter(getter(Rule::triggerEventSource)).setter(setter(Builder::triggerEventSource))
            .constructor(RuleTriggerEventSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerEventSource").build())
            .build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Function").getter(getter(Rule::function)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()).build();

    private static final SdkField<List<RuleAction>> ACTIONS_FIELD = SdkField
            .<List<RuleAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(Rule::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PUBLISH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishStatus").getter(getter(Rule::publishStatusAsString)).setter(setter(Builder::publishStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Rule::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Rule::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedBy").getter(getter(Rule::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Rule::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RULE_ID_FIELD,
            RULE_ARN_FIELD, TRIGGER_EVENT_SOURCE_FIELD, FUNCTION_FIELD, ACTIONS_FIELD, PUBLISH_STATUS_FIELD, CREATED_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String ruleId;

    private final String ruleArn;

    private final RuleTriggerEventSource triggerEventSource;

    private final String function;

    private final List<RuleAction> actions;

    private final String publishStatus;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String lastUpdatedBy;

    private final Map<String, String> tags;

    private Rule(BuilderImpl builder) {
        this.name = builder.name;
        this.ruleId = builder.ruleId;
        this.ruleArn = builder.ruleArn;
        this.triggerEventSource = builder.triggerEventSource;
        this.function = builder.function;
        this.actions = builder.actions;
        this.publishStatus = builder.publishStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the rule.
     * </p>
     * 
     * @return A unique identifier for the rule.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The event source to trigger the rule.
     * </p>
     * 
     * @return The event source to trigger the rule.
     */
    public final RuleTriggerEventSource triggerEventSource() {
        return triggerEventSource;
    }

    /**
     * <p>
     * The conditions of the rule.
     * </p>
     * 
     * @return The conditions of the rule.
     */
    public final String function() {
        return function;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of actions to be run when the rule is triggered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of actions to be run when the rule is triggered.
     */
    public final List<RuleAction> actions() {
        return actions;
    }

    /**
     * <p>
     * The publish status of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publishStatus}
     * will return {@link RulePublishStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publishStatusAsString}.
     * </p>
     * 
     * @return The publish status of the rule.
     * @see RulePublishStatus
     */
    public final RulePublishStatus publishStatus() {
        return RulePublishStatus.fromValue(publishStatus);
    }

    /**
     * <p>
     * The publish status of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publishStatus}
     * will return {@link RulePublishStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publishStatusAsString}.
     * </p>
     * 
     * @return The publish status of the rule.
     * @see RulePublishStatus
     */
    public final String publishStatusAsString() {
        return publishStatus;
    }

    /**
     * <p>
     * The timestamp for when the rule was created.
     * </p>
     * 
     * @return The timestamp for when the rule was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The timestamp for the when the rule was last updated.
     * </p>
     * 
     * @return The timestamp for the when the rule was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last updated the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last updated the rule.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(triggerEventSource());
        hashCode = 31 * hashCode + Objects.hashCode(function());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(triggerEventSource(), other.triggerEventSource())
                && Objects.equals(function(), other.function()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions())
                && Objects.equals(publishStatusAsString(), other.publishStatusAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("Name", name()).add("RuleId", ruleId()).add("RuleArn", ruleArn())
                .add("TriggerEventSource", triggerEventSource()).add("Function", function())
                .add("Actions", hasActions() ? actions() : null).add("PublishStatus", publishStatusAsString())
                .add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("LastUpdatedBy", lastUpdatedBy()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "TriggerEventSource":
            return Optional.ofNullable(clazz.cast(triggerEventSource()));
        case "Function":
            return Optional.ofNullable(clazz.cast(function()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "PublishStatus":
            return Optional.ofNullable(clazz.cast(publishStatusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "LastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("TriggerEventSource", TRIGGER_EVENT_SOURCE_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("PublishStatus", PUBLISH_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the rule.
         * </p>
         * 
         * @param ruleId
         *        A unique identifier for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The event source to trigger the rule.
         * </p>
         * 
         * @param triggerEventSource
         *        The event source to trigger the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerEventSource(RuleTriggerEventSource triggerEventSource);

        /**
         * <p>
         * The event source to trigger the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleTriggerEventSource.Builder} avoiding
         * the need to create one manually via {@link RuleTriggerEventSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleTriggerEventSource.Builder#build()} is called immediately and
         * its result is passed to {@link #triggerEventSource(RuleTriggerEventSource)}.
         * 
         * @param triggerEventSource
         *        a consumer that will call methods on {@link RuleTriggerEventSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerEventSource(RuleTriggerEventSource)
         */
        default Builder triggerEventSource(Consumer<RuleTriggerEventSource.Builder> triggerEventSource) {
            return triggerEventSource(RuleTriggerEventSource.builder().applyMutation(triggerEventSource).build());
        }

        /**
         * <p>
         * The conditions of the rule.
         * </p>
         * 
         * @param function
         *        The conditions of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder function(String function);

        /**
         * <p>
         * A list of actions to be run when the rule is triggered.
         * </p>
         * 
         * @param actions
         *        A list of actions to be run when the rule is triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<RuleAction> actions);

        /**
         * <p>
         * A list of actions to be run when the rule is triggered.
         * </p>
         * 
         * @param actions
         *        A list of actions to be run when the rule is triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(RuleAction... actions);

        /**
         * <p>
         * A list of actions to be run when the rule is triggered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RuleAction.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.RuleAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RuleAction.Builder#build()} is called immediately and
         * its result is passed to {@link #actions(List<RuleAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<RuleAction>)
         */
        Builder actions(Consumer<RuleAction.Builder>... actions);

        /**
         * <p>
         * The publish status of the rule.
         * </p>
         * 
         * @param publishStatus
         *        The publish status of the rule.
         * @see RulePublishStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RulePublishStatus
         */
        Builder publishStatus(String publishStatus);

        /**
         * <p>
         * The publish status of the rule.
         * </p>
         * 
         * @param publishStatus
         *        The publish status of the rule.
         * @see RulePublishStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RulePublishStatus
         */
        Builder publishStatus(RulePublishStatus publishStatus);

        /**
         * <p>
         * The timestamp for when the rule was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp for when the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The timestamp for the when the rule was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp for the when the rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last updated the rule.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The Amazon Resource Name (ARN) of the user who last updated the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String ruleId;

        private String ruleArn;

        private RuleTriggerEventSource triggerEventSource;

        private String function;

        private List<RuleAction> actions = DefaultSdkAutoConstructList.getInstance();

        private String publishStatus;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String lastUpdatedBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            name(model.name);
            ruleId(model.ruleId);
            ruleArn(model.ruleArn);
            triggerEventSource(model.triggerEventSource);
            function(model.function);
            actions(model.actions);
            publishStatus(model.publishStatus);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            lastUpdatedBy(model.lastUpdatedBy);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final RuleTriggerEventSource.Builder getTriggerEventSource() {
            return triggerEventSource != null ? triggerEventSource.toBuilder() : null;
        }

        public final void setTriggerEventSource(RuleTriggerEventSource.BuilderImpl triggerEventSource) {
            this.triggerEventSource = triggerEventSource != null ? triggerEventSource.build() : null;
        }

        @Override
        public final Builder triggerEventSource(RuleTriggerEventSource triggerEventSource) {
            this.triggerEventSource = triggerEventSource;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final List<RuleAction.Builder> getActions() {
            List<RuleAction.Builder> result = RuleActionsCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<RuleAction.BuilderImpl> actions) {
            this.actions = RuleActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<RuleAction> actions) {
            this.actions = RuleActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(RuleAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<RuleAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> RuleAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublishStatus() {
            return publishStatus;
        }

        public final void setPublishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
        }

        @Override
        public final Builder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Override
        public final Builder publishStatus(RulePublishStatus publishStatus) {
            this.publishStatus(publishStatus == null ? null : publishStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
