/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reason for the exception.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceQuotaExceededExceptionReason implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceQuotaExceededExceptionReason.Builder, ServiceQuotaExceededExceptionReason> {
    private static final SdkField<String> ATTACHED_FILE_SERVICE_QUOTA_EXCEEDED_EXCEPTION_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AttachedFileServiceQuotaExceededExceptionReason")
            .getter(getter(ServiceQuotaExceededExceptionReason::attachedFileServiceQuotaExceededExceptionReasonAsString))
            .setter(setter(Builder::attachedFileServiceQuotaExceededExceptionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AttachedFileServiceQuotaExceededExceptionReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ATTACHED_FILE_SERVICE_QUOTA_EXCEEDED_EXCEPTION_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attachedFileServiceQuotaExceededExceptionReason;

    private final Type type;

    private ServiceQuotaExceededExceptionReason(BuilderImpl builder) {
        this.attachedFileServiceQuotaExceededExceptionReason = builder.attachedFileServiceQuotaExceededExceptionReason;
        this.type = builder.type;
    }

    /**
     * <p>
     * Total file size of all files or total number of files exceeds the service quota
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attachedFileServiceQuotaExceededExceptionReason} will return
     * {@link AttachedFileServiceQuotaExceededExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #attachedFileServiceQuotaExceededExceptionReasonAsString}.
     * </p>
     * 
     * @return Total file size of all files or total number of files exceeds the service quota
     * @see AttachedFileServiceQuotaExceededExceptionReason
     */
    public final AttachedFileServiceQuotaExceededExceptionReason attachedFileServiceQuotaExceededExceptionReason() {
        return AttachedFileServiceQuotaExceededExceptionReason.fromValue(attachedFileServiceQuotaExceededExceptionReason);
    }

    /**
     * <p>
     * Total file size of all files or total number of files exceeds the service quota
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attachedFileServiceQuotaExceededExceptionReason} will return
     * {@link AttachedFileServiceQuotaExceededExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #attachedFileServiceQuotaExceededExceptionReasonAsString}.
     * </p>
     * 
     * @return Total file size of all files or total number of files exceeds the service quota
     * @see AttachedFileServiceQuotaExceededExceptionReason
     */
    public final String attachedFileServiceQuotaExceededExceptionReasonAsString() {
        return attachedFileServiceQuotaExceededExceptionReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachedFileServiceQuotaExceededExceptionReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceQuotaExceededExceptionReason)) {
            return false;
        }
        ServiceQuotaExceededExceptionReason other = (ServiceQuotaExceededExceptionReason) obj;
        return Objects.equals(attachedFileServiceQuotaExceededExceptionReasonAsString(),
                other.attachedFileServiceQuotaExceededExceptionReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ServiceQuotaExceededExceptionReason")
                .add("AttachedFileServiceQuotaExceededExceptionReason", attachedFileServiceQuotaExceededExceptionReasonAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachedFileServiceQuotaExceededExceptionReason":
            return Optional.ofNullable(clazz.cast(attachedFileServiceQuotaExceededExceptionReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #attachedFileServiceQuotaExceededExceptionReasonAsString()}
     * initialized to the given value.
     *
     * <p>
     * Total file size of all files or total number of files exceeds the service quota
     * </p>
     * 
     * @param attachedFileServiceQuotaExceededExceptionReason
     *        Total file size of all files or total number of files exceeds the service quota
     * @see AttachedFileServiceQuotaExceededExceptionReason
     */
    public static ServiceQuotaExceededExceptionReason fromAttachedFileServiceQuotaExceededExceptionReason(
            String attachedFileServiceQuotaExceededExceptionReason) {
        return builder().attachedFileServiceQuotaExceededExceptionReason(attachedFileServiceQuotaExceededExceptionReason).build();
    }

    /**
     * Create an instance of this class with {@link #attachedFileServiceQuotaExceededExceptionReasonAsString()}
     * initialized to the given value.
     *
     * <p>
     * Total file size of all files or total number of files exceeds the service quota
     * </p>
     * 
     * @param attachedFileServiceQuotaExceededExceptionReason
     *        Total file size of all files or total number of files exceeds the service quota
     * @see AttachedFileServiceQuotaExceededExceptionReason
     */
    public static ServiceQuotaExceededExceptionReason fromAttachedFileServiceQuotaExceededExceptionReason(
            AttachedFileServiceQuotaExceededExceptionReason attachedFileServiceQuotaExceededExceptionReason) {
        return builder().attachedFileServiceQuotaExceededExceptionReason(attachedFileServiceQuotaExceededExceptionReason).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachedFileServiceQuotaExceededExceptionReason", ATTACHED_FILE_SERVICE_QUOTA_EXCEEDED_EXCEPTION_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceQuotaExceededExceptionReason, T> g) {
        return obj -> g.apply((ServiceQuotaExceededExceptionReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceQuotaExceededExceptionReason> {
        /**
         * <p>
         * Total file size of all files or total number of files exceeds the service quota
         * </p>
         * 
         * @param attachedFileServiceQuotaExceededExceptionReason
         *        Total file size of all files or total number of files exceeds the service quota
         * @see AttachedFileServiceQuotaExceededExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachedFileServiceQuotaExceededExceptionReason
         */
        Builder attachedFileServiceQuotaExceededExceptionReason(String attachedFileServiceQuotaExceededExceptionReason);

        /**
         * <p>
         * Total file size of all files or total number of files exceeds the service quota
         * </p>
         * 
         * @param attachedFileServiceQuotaExceededExceptionReason
         *        Total file size of all files or total number of files exceeds the service quota
         * @see AttachedFileServiceQuotaExceededExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachedFileServiceQuotaExceededExceptionReason
         */
        Builder attachedFileServiceQuotaExceededExceptionReason(
                AttachedFileServiceQuotaExceededExceptionReason attachedFileServiceQuotaExceededExceptionReason);
    }

    static final class BuilderImpl implements Builder {
        private String attachedFileServiceQuotaExceededExceptionReason;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceQuotaExceededExceptionReason model) {
            attachedFileServiceQuotaExceededExceptionReason(model.attachedFileServiceQuotaExceededExceptionReason);
        }

        public final String getAttachedFileServiceQuotaExceededExceptionReason() {
            return attachedFileServiceQuotaExceededExceptionReason;
        }

        public final void setAttachedFileServiceQuotaExceededExceptionReason(
                String attachedFileServiceQuotaExceededExceptionReason) {
            Object oldValue = this.attachedFileServiceQuotaExceededExceptionReason;
            this.attachedFileServiceQuotaExceededExceptionReason = attachedFileServiceQuotaExceededExceptionReason;
            handleUnionValueChange(Type.ATTACHED_FILE_SERVICE_QUOTA_EXCEEDED_EXCEPTION_REASON, oldValue,
                    this.attachedFileServiceQuotaExceededExceptionReason);
        }

        @Override
        public final Builder attachedFileServiceQuotaExceededExceptionReason(
                String attachedFileServiceQuotaExceededExceptionReason) {
            Object oldValue = this.attachedFileServiceQuotaExceededExceptionReason;
            this.attachedFileServiceQuotaExceededExceptionReason = attachedFileServiceQuotaExceededExceptionReason;
            handleUnionValueChange(Type.ATTACHED_FILE_SERVICE_QUOTA_EXCEEDED_EXCEPTION_REASON, oldValue,
                    this.attachedFileServiceQuotaExceededExceptionReason);
            return this;
        }

        @Override
        public final Builder attachedFileServiceQuotaExceededExceptionReason(
                AttachedFileServiceQuotaExceededExceptionReason attachedFileServiceQuotaExceededExceptionReason) {
            this.attachedFileServiceQuotaExceededExceptionReason(attachedFileServiceQuotaExceededExceptionReason == null ? null
                    : attachedFileServiceQuotaExceededExceptionReason.toString());
            return this;
        }

        @Override
        public ServiceQuotaExceededExceptionReason build() {
            return new ServiceQuotaExceededExceptionReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ServiceQuotaExceededExceptionReason#type()
     */
    public enum Type {
        ATTACHED_FILE_SERVICE_QUOTA_EXCEEDED_EXCEPTION_REASON,

        UNKNOWN_TO_SDK_VERSION
    }
}
