/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceCampaign implements SdkPojo, Serializable, ToCopyableBuilder<SourceCampaign.Builder, SourceCampaign> {
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CampaignId").getter(getter(SourceCampaign::campaignId)).setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()).build();

    private static final SdkField<String> OUTBOUND_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutboundRequestId").getter(getter(SourceCampaign::outboundRequestId))
            .setter(setter(Builder::outboundRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ID_FIELD,
            OUTBOUND_REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String campaignId;

    private final String outboundRequestId;

    private SourceCampaign(BuilderImpl builder) {
        this.campaignId = builder.campaignId;
        this.outboundRequestId = builder.outboundRequestId;
    }

    /**
     * <p>
     * A unique identifier for a campaign.
     * </p>
     * 
     * @return A unique identifier for a campaign.
     */
    public final String campaignId() {
        return campaignId;
    }

    /**
     * <p>
     * A unique identifier for a each request part of same campaign.
     * </p>
     * 
     * @return A unique identifier for a each request part of same campaign.
     */
    public final String outboundRequestId() {
        return outboundRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(outboundRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCampaign)) {
            return false;
        }
        SourceCampaign other = (SourceCampaign) obj;
        return Objects.equals(campaignId(), other.campaignId()) && Objects.equals(outboundRequestId(), other.outboundRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceCampaign").add("CampaignId", campaignId()).add("OutboundRequestId", outboundRequestId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        case "OutboundRequestId":
            return Optional.ofNullable(clazz.cast(outboundRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CampaignId", CAMPAIGN_ID_FIELD);
        map.put("OutboundRequestId", OUTBOUND_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceCampaign, T> g) {
        return obj -> g.apply((SourceCampaign) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceCampaign> {
        /**
         * <p>
         * A unique identifier for a campaign.
         * </p>
         * 
         * @param campaignId
         *        A unique identifier for a campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        /**
         * <p>
         * A unique identifier for a each request part of same campaign.
         * </p>
         * 
         * @param outboundRequestId
         *        A unique identifier for a each request part of same campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundRequestId(String outboundRequestId);
    }

    static final class BuilderImpl implements Builder {
        private String campaignId;

        private String outboundRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCampaign model) {
            campaignId(model.campaignId);
            outboundRequestId(model.outboundRequestId);
        }

        public final String getCampaignId() {
            return campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final String getOutboundRequestId() {
            return outboundRequestId;
        }

        public final void setOutboundRequestId(String outboundRequestId) {
            this.outboundRequestId = outboundRequestId;
        }

        @Override
        public final Builder outboundRequestId(String outboundRequestId) {
            this.outboundRequestId = outboundRequestId;
            return this;
        }

        @Override
        public SourceCampaign build() {
            return new SourceCampaign(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
