/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Step signifies the criteria to be used for routing to an agent
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Step implements SdkPojo, Serializable, ToCopyableBuilder<Step.Builder, Step> {
    private static final SdkField<Expiry> EXPIRY_FIELD = SdkField.<Expiry> builder(MarshallingType.SDK_POJO).memberName("Expiry")
            .getter(getter(Step::expiry)).setter(setter(Builder::expiry)).constructor(Expiry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()).build();

    private static final SdkField<Expression> EXPRESSION_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Expression").getter(getter(Step::expression)).setter(setter(Builder::expression))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Step::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRY_FIELD,
            EXPRESSION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Expiry expiry;

    private final Expression expression;

    private final String status;

    private Step(BuilderImpl builder) {
        this.expiry = builder.expiry;
        this.expression = builder.expression;
        this.status = builder.status;
    }

    /**
     * <p>
     * An object to specify the expiration of a routing step.
     * </p>
     * 
     * @return An object to specify the expiration of a routing step.
     */
    public final Expiry expiry() {
        return expiry;
    }

    /**
     * <p>
     * A tagged union to specify expression for a routing step.
     * </p>
     * 
     * @return A tagged union to specify expression for a routing step.
     */
    public final Expression expression() {
        return expression;
    }

    /**
     * <p>
     * Represents status of the Routing step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RoutingCriteriaStepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Represents status of the Routing step.
     * @see RoutingCriteriaStepStatus
     */
    public final RoutingCriteriaStepStatus status() {
        return RoutingCriteriaStepStatus.fromValue(status);
    }

    /**
     * <p>
     * Represents status of the Routing step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RoutingCriteriaStepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Represents status of the Routing step.
     * @see RoutingCriteriaStepStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expiry());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step) obj;
        return Objects.equals(expiry(), other.expiry()) && Objects.equals(expression(), other.expression())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Step").add("Expiry", expiry()).add("Expression", expression()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expiry":
            return Optional.ofNullable(clazz.cast(expiry()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expiry", EXPIRY_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Step> {
        /**
         * <p>
         * An object to specify the expiration of a routing step.
         * </p>
         * 
         * @param expiry
         *        An object to specify the expiration of a routing step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiry(Expiry expiry);

        /**
         * <p>
         * An object to specify the expiration of a routing step.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expiry.Builder} avoiding the need to
         * create one manually via {@link Expiry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expiry.Builder#build()} is called immediately and its result is
         * passed to {@link #expiry(Expiry)}.
         * 
         * @param expiry
         *        a consumer that will call methods on {@link Expiry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expiry(Expiry)
         */
        default Builder expiry(Consumer<Expiry.Builder> expiry) {
            return expiry(Expiry.builder().applyMutation(expiry).build());
        }

        /**
         * <p>
         * A tagged union to specify expression for a routing step.
         * </p>
         * 
         * @param expression
         *        A tagged union to specify expression for a routing step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(Expression expression);

        /**
         * <p>
         * A tagged union to specify expression for a routing step.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #expression(Expression)}.
         * 
         * @param expression
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expression(Expression)
         */
        default Builder expression(Consumer<Expression.Builder> expression) {
            return expression(Expression.builder().applyMutation(expression).build());
        }

        /**
         * <p>
         * Represents status of the Routing step.
         * </p>
         * 
         * @param status
         *        Represents status of the Routing step.
         * @see RoutingCriteriaStepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingCriteriaStepStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Represents status of the Routing step.
         * </p>
         * 
         * @param status
         *        Represents status of the Routing step.
         * @see RoutingCriteriaStepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingCriteriaStepStatus
         */
        Builder status(RoutingCriteriaStepStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Expiry expiry;

        private Expression expression;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            expiry(model.expiry);
            expression(model.expression);
            status(model.status);
        }

        public final Expiry.Builder getExpiry() {
            return expiry != null ? expiry.toBuilder() : null;
        }

        public final void setExpiry(Expiry.BuilderImpl expiry) {
            this.expiry = expiry != null ? expiry.build() : null;
        }

        @Override
        public final Builder expiry(Expiry expiry) {
            this.expiry = expiry;
            return this;
        }

        public final Expression.Builder getExpression() {
            return expression != null ? expression.toBuilder() : null;
        }

        public final void setExpression(Expression.BuilderImpl expression) {
            this.expression = expression != null ? expression.build() : null;
        }

        @Override
        public final Builder expression(Expression expression) {
            this.expression = expression;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RoutingCriteriaStepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Step build() {
            return new Step(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
