/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.PhoneNumberCountryCode;
import software.amazon.awssdk.services.connect.model.PhoneNumberCountryCodesCopier;
import software.amazon.awssdk.services.connect.model.PhoneNumberType;
import software.amazon.awssdk.services.connect.model.PhoneNumberTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPhoneNumbersV2Request
extends ConnectRequest
implements ToCopyableBuilder<Builder, ListPhoneNumbersV2Request> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(ListPhoneNumbersV2Request.getter(ListPhoneNumbersV2Request::targetArn)).setter(ListPhoneNumbersV2Request.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListPhoneNumbersV2Request.getter(ListPhoneNumbersV2Request::instanceId)).setter(ListPhoneNumbersV2Request.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListPhoneNumbersV2Request.getter(ListPhoneNumbersV2Request::maxResults)).setter(ListPhoneNumbersV2Request.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPhoneNumbersV2Request.getter(ListPhoneNumbersV2Request::nextToken)).setter(ListPhoneNumbersV2Request.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> PHONE_NUMBER_COUNTRY_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberCountryCodes").getter(ListPhoneNumbersV2Request.getter(ListPhoneNumbersV2Request::phoneNumberCountryCodesAsStrings)).setter(ListPhoneNumbersV2Request.setter(Builder::phoneNumberCountryCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountryCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PHONE_NUMBER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberTypes").getter(ListPhoneNumbersV2Request.getter(ListPhoneNumbersV2Request::phoneNumberTypesAsStrings)).setter(ListPhoneNumbersV2Request.setter(Builder::phoneNumberTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PHONE_NUMBER_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberPrefix").getter(ListPhoneNumbersV2Request.getter(ListPhoneNumbersV2Request::phoneNumberPrefix)).setter(ListPhoneNumbersV2Request.setter(Builder::phoneNumberPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, INSTANCE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PHONE_NUMBER_COUNTRY_CODES_FIELD, PHONE_NUMBER_TYPES_FIELD, PHONE_NUMBER_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPhoneNumbersV2Request.memberNameToFieldInitializer();
    private final String targetArn;
    private final String instanceId;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> phoneNumberCountryCodes;
    private final List<String> phoneNumberTypes;
    private final String phoneNumberPrefix;

    private ListPhoneNumbersV2Request(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.instanceId = builder.instanceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.phoneNumberCountryCodes = builder.phoneNumberCountryCodes;
        this.phoneNumberTypes = builder.phoneNumberTypes;
        this.phoneNumberPrefix = builder.phoneNumberPrefix;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<PhoneNumberCountryCode> phoneNumberCountryCodes() {
        return PhoneNumberCountryCodesCopier.copyStringToEnum(this.phoneNumberCountryCodes);
    }

    public final boolean hasPhoneNumberCountryCodes() {
        return this.phoneNumberCountryCodes != null && !(this.phoneNumberCountryCodes instanceof SdkAutoConstructList);
    }

    public final List<String> phoneNumberCountryCodesAsStrings() {
        return this.phoneNumberCountryCodes;
    }

    public final List<PhoneNumberType> phoneNumberTypes() {
        return PhoneNumberTypesCopier.copyStringToEnum(this.phoneNumberTypes);
    }

    public final boolean hasPhoneNumberTypes() {
        return this.phoneNumberTypes != null && !(this.phoneNumberTypes instanceof SdkAutoConstructList);
    }

    public final List<String> phoneNumberTypesAsStrings() {
        return this.phoneNumberTypes;
    }

    public final String phoneNumberPrefix() {
        return this.phoneNumberPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberCountryCodes() ? this.phoneNumberCountryCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberTypes() ? this.phoneNumberTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersV2Request)) {
            return false;
        }
        ListPhoneNumbersV2Request other = (ListPhoneNumbersV2Request)((Object)obj);
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasPhoneNumberCountryCodes() == other.hasPhoneNumberCountryCodes() && Objects.equals(this.phoneNumberCountryCodesAsStrings(), other.phoneNumberCountryCodesAsStrings()) && this.hasPhoneNumberTypes() == other.hasPhoneNumberTypes() && Objects.equals(this.phoneNumberTypesAsStrings(), other.phoneNumberTypesAsStrings()) && Objects.equals(this.phoneNumberPrefix(), other.phoneNumberPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"ListPhoneNumbersV2Request").add("TargetArn", (Object)this.targetArn()).add("InstanceId", (Object)this.instanceId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("PhoneNumberCountryCodes", this.hasPhoneNumberCountryCodes() ? this.phoneNumberCountryCodesAsStrings() : null).add("PhoneNumberTypes", this.hasPhoneNumberTypes() ? this.phoneNumberTypesAsStrings() : null).add("PhoneNumberPrefix", (Object)this.phoneNumberPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PhoneNumberCountryCodes": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberCountryCodesAsStrings()));
            }
            case "PhoneNumberTypes": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberTypesAsStrings()));
            }
            case "PhoneNumberPrefix": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetArn", TARGET_ARN_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("PhoneNumberCountryCodes", PHONE_NUMBER_COUNTRY_CODES_FIELD);
        map.put("PhoneNumberTypes", PHONE_NUMBER_TYPES_FIELD);
        map.put("PhoneNumberPrefix", PHONE_NUMBER_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersV2Request, T> g) {
        return obj -> g.apply((ListPhoneNumbersV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String targetArn;
        private String instanceId;
        private Integer maxResults;
        private String nextToken;
        private List<String> phoneNumberCountryCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> phoneNumberTypes = DefaultSdkAutoConstructList.getInstance();
        private String phoneNumberPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersV2Request model) {
            super(model);
            this.targetArn(model.targetArn);
            this.instanceId(model.instanceId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.phoneNumberCountryCodesWithStrings(model.phoneNumberCountryCodes);
            this.phoneNumberTypesWithStrings(model.phoneNumberTypes);
            this.phoneNumberPrefix(model.phoneNumberPrefix);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getPhoneNumberCountryCodes() {
            if (this.phoneNumberCountryCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumberCountryCodes;
        }

        public final void setPhoneNumberCountryCodes(Collection<String> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copy(phoneNumberCountryCodes);
        }

        @Override
        public final Builder phoneNumberCountryCodesWithStrings(Collection<String> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copy(phoneNumberCountryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountryCodesWithStrings(String ... phoneNumberCountryCodes) {
            this.phoneNumberCountryCodesWithStrings(Arrays.asList(phoneNumberCountryCodes));
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCodes(Collection<PhoneNumberCountryCode> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copyEnumToString(phoneNumberCountryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountryCodes(PhoneNumberCountryCode ... phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes(Arrays.asList(phoneNumberCountryCodes));
            return this;
        }

        public final Collection<String> getPhoneNumberTypes() {
            if (this.phoneNumberTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumberTypes;
        }

        public final void setPhoneNumberTypes(Collection<String> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copy(phoneNumberTypes);
        }

        @Override
        public final Builder phoneNumberTypesWithStrings(Collection<String> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copy(phoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberTypesWithStrings(String ... phoneNumberTypes) {
            this.phoneNumberTypesWithStrings(Arrays.asList(phoneNumberTypes));
            return this;
        }

        @Override
        public final Builder phoneNumberTypes(Collection<PhoneNumberType> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copyEnumToString(phoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberTypes(PhoneNumberType ... phoneNumberTypes) {
            this.phoneNumberTypes(Arrays.asList(phoneNumberTypes));
            return this;
        }

        public final String getPhoneNumberPrefix() {
            return this.phoneNumberPrefix;
        }

        public final void setPhoneNumberPrefix(String phoneNumberPrefix) {
            this.phoneNumberPrefix = phoneNumberPrefix;
        }

        @Override
        public final Builder phoneNumberPrefix(String phoneNumberPrefix) {
            this.phoneNumberPrefix = phoneNumberPrefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPhoneNumbersV2Request build() {
            return new ListPhoneNumbersV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPhoneNumbersV2Request> {
        public Builder targetArn(String var1);

        public Builder instanceId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder phoneNumberCountryCodesWithStrings(Collection<String> var1);

        public Builder phoneNumberCountryCodesWithStrings(String ... var1);

        public Builder phoneNumberCountryCodes(Collection<PhoneNumberCountryCode> var1);

        public Builder phoneNumberCountryCodes(PhoneNumberCountryCode ... var1);

        public Builder phoneNumberTypesWithStrings(Collection<String> var1);

        public Builder phoneNumberTypesWithStrings(String ... var1);

        public Builder phoneNumberTypes(Collection<PhoneNumberType> var1);

        public Builder phoneNumberTypes(PhoneNumberType ... var1);

        public Builder phoneNumberPrefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

