/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.CrossChannelBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaConcurrency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaConcurrency> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(MediaConcurrency.getter(MediaConcurrency::channelAsString)).setter(MediaConcurrency.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<Integer> CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Concurrency").getter(MediaConcurrency.getter(MediaConcurrency::concurrency)).setter(MediaConcurrency.setter(Builder::concurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Concurrency").build()}).build();
    private static final SdkField<CrossChannelBehavior> CROSS_CHANNEL_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CrossChannelBehavior").getter(MediaConcurrency.getter(MediaConcurrency::crossChannelBehavior)).setter(MediaConcurrency.setter(Builder::crossChannelBehavior)).constructor(CrossChannelBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossChannelBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, CONCURRENCY_FIELD, CROSS_CHANNEL_BEHAVIOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaConcurrency.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channel;
    private final Integer concurrency;
    private final CrossChannelBehavior crossChannelBehavior;

    private MediaConcurrency(BuilderImpl builder) {
        this.channel = builder.channel;
        this.concurrency = builder.concurrency;
        this.crossChannelBehavior = builder.crossChannelBehavior;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final Integer concurrency() {
        return this.concurrency;
    }

    public final CrossChannelBehavior crossChannelBehavior() {
        return this.crossChannelBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossChannelBehavior());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaConcurrency)) {
            return false;
        }
        MediaConcurrency other = (MediaConcurrency)obj;
        return Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.concurrency(), other.concurrency()) && Objects.equals(this.crossChannelBehavior(), other.crossChannelBehavior());
    }

    public final String toString() {
        return ToString.builder((String)"MediaConcurrency").add("Channel", (Object)this.channelAsString()).add("Concurrency", (Object)this.concurrency()).add("CrossChannelBehavior", (Object)this.crossChannelBehavior()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "Concurrency": {
                return Optional.ofNullable(clazz.cast(this.concurrency()));
            }
            case "CrossChannelBehavior": {
                return Optional.ofNullable(clazz.cast(this.crossChannelBehavior()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Channel", CHANNEL_FIELD);
        map.put("Concurrency", CONCURRENCY_FIELD);
        map.put("CrossChannelBehavior", CROSS_CHANNEL_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaConcurrency, T> g) {
        return obj -> g.apply((MediaConcurrency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channel;
        private Integer concurrency;
        private CrossChannelBehavior crossChannelBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaConcurrency model) {
            this.channel(model.channel);
            this.concurrency(model.concurrency);
            this.crossChannelBehavior(model.crossChannelBehavior);
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final Integer getConcurrency() {
            return this.concurrency;
        }

        public final void setConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
        }

        @Override
        public final Builder concurrency(Integer concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public final CrossChannelBehavior.Builder getCrossChannelBehavior() {
            return this.crossChannelBehavior != null ? this.crossChannelBehavior.toBuilder() : null;
        }

        public final void setCrossChannelBehavior(CrossChannelBehavior.BuilderImpl crossChannelBehavior) {
            this.crossChannelBehavior = crossChannelBehavior != null ? crossChannelBehavior.build() : null;
        }

        @Override
        public final Builder crossChannelBehavior(CrossChannelBehavior crossChannelBehavior) {
            this.crossChannelBehavior = crossChannelBehavior;
            return this;
        }

        public MediaConcurrency build() {
            return new MediaConcurrency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaConcurrency> {
        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder concurrency(Integer var1);

        public Builder crossChannelBehavior(CrossChannelBehavior var1);

        default public Builder crossChannelBehavior(Consumer<CrossChannelBehavior.Builder> crossChannelBehavior) {
            return this.crossChannelBehavior((CrossChannelBehavior)((CrossChannelBehavior.Builder)CrossChannelBehavior.builder().applyMutation(crossChannelBehavior)).build());
        }
    }
}

