/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.OutboundStrategyConfig;
import software.amazon.awssdk.services.connect.model.OutboundStrategyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutboundStrategy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutboundStrategy> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(OutboundStrategy.getter(OutboundStrategy::typeAsString)).setter(OutboundStrategy.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<OutboundStrategyConfig> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Config").getter(OutboundStrategy.getter(OutboundStrategy::config)).setter(OutboundStrategy.setter(Builder::config)).constructor(OutboundStrategyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutboundStrategy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final OutboundStrategyConfig config;

    private OutboundStrategy(BuilderImpl builder) {
        this.type = builder.type;
        this.config = builder.config;
    }

    public final OutboundStrategyType type() {
        return OutboundStrategyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final OutboundStrategyConfig config() {
        return this.config;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.config());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundStrategy)) {
            return false;
        }
        OutboundStrategy other = (OutboundStrategy)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.config(), other.config());
    }

    public final String toString() {
        return ToString.builder((String)"OutboundStrategy").add("Type", (Object)this.typeAsString()).add("Config", (Object)this.config()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Config", CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundStrategy, T> g) {
        return obj -> g.apply((OutboundStrategy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private OutboundStrategyConfig config;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundStrategy model) {
            this.type(model.type);
            this.config(model.config);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OutboundStrategyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final OutboundStrategyConfig.Builder getConfig() {
            return this.config != null ? this.config.toBuilder() : null;
        }

        public final void setConfig(OutboundStrategyConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(OutboundStrategyConfig config) {
            this.config = config;
            return this;
        }

        public OutboundStrategy build() {
            return new OutboundStrategy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutboundStrategy> {
        public Builder type(String var1);

        public Builder type(OutboundStrategyType var1);

        public Builder config(OutboundStrategyConfig var1);

        default public Builder config(Consumer<OutboundStrategyConfig.Builder> config) {
            return this.config((OutboundStrategyConfig)((OutboundStrategyConfig.Builder)OutboundStrategyConfig.builder().applyMutation(config)).build());
        }
    }
}

