/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingProfileManualAssignmentQueueConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingProfileManualAssignmentQueueConfigSummary> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(RoutingProfileManualAssignmentQueueConfigSummary.getter(RoutingProfileManualAssignmentQueueConfigSummary::queueId)).setter(RoutingProfileManualAssignmentQueueConfigSummary.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final SdkField<String> QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueArn").getter(RoutingProfileManualAssignmentQueueConfigSummary.getter(RoutingProfileManualAssignmentQueueConfigSummary::queueArn)).setter(RoutingProfileManualAssignmentQueueConfigSummary.setter(Builder::queueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueArn").build()}).build();
    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueName").getter(RoutingProfileManualAssignmentQueueConfigSummary.getter(RoutingProfileManualAssignmentQueueConfigSummary::queueName)).setter(RoutingProfileManualAssignmentQueueConfigSummary.setter(Builder::queueName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueName").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(RoutingProfileManualAssignmentQueueConfigSummary.getter(RoutingProfileManualAssignmentQueueConfigSummary::channelAsString)).setter(RoutingProfileManualAssignmentQueueConfigSummary.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD, QUEUE_ARN_FIELD, QUEUE_NAME_FIELD, CHANNEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoutingProfileManualAssignmentQueueConfigSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queueId;
    private final String queueArn;
    private final String queueName;
    private final String channel;

    private RoutingProfileManualAssignmentQueueConfigSummary(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.queueArn = builder.queueArn;
        this.queueName = builder.queueName;
        this.channel = builder.channel;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String queueArn() {
        return this.queueArn;
    }

    public final String queueName() {
        return this.queueName;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfileManualAssignmentQueueConfigSummary)) {
            return false;
        }
        RoutingProfileManualAssignmentQueueConfigSummary other = (RoutingProfileManualAssignmentQueueConfigSummary)obj;
        return Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.queueArn(), other.queueArn()) && Objects.equals(this.queueName(), other.queueName()) && Objects.equals(this.channelAsString(), other.channelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RoutingProfileManualAssignmentQueueConfigSummary").add("QueueId", (Object)this.queueId()).add("QueueArn", (Object)this.queueArn()).add("QueueName", (Object)this.queueName()).add("Channel", (Object)this.channelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "QueueArn": {
                return Optional.ofNullable(clazz.cast(this.queueArn()));
            }
            case "QueueName": {
                return Optional.ofNullable(clazz.cast(this.queueName()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("QueueArn", QUEUE_ARN_FIELD);
        map.put("QueueName", QUEUE_NAME_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfileManualAssignmentQueueConfigSummary, T> g) {
        return obj -> g.apply((RoutingProfileManualAssignmentQueueConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queueId;
        private String queueArn;
        private String queueName;
        private String channel;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfileManualAssignmentQueueConfigSummary model) {
            this.queueId(model.queueId);
            this.queueArn(model.queueArn);
            this.queueName(model.queueName);
            this.channel(model.channel);
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getQueueArn() {
            return this.queueArn;
        }

        public final void setQueueArn(String queueArn) {
            this.queueArn = queueArn;
        }

        @Override
        public final Builder queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        public final String getQueueName() {
            return this.queueName;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public RoutingProfileManualAssignmentQueueConfigSummary build() {
            return new RoutingProfileManualAssignmentQueueConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingProfileManualAssignmentQueueConfigSummary> {
        public Builder queueId(String var1);

        public Builder queueArn(String var1);

        public Builder queueName(String var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);
    }
}

