/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about agent-first outbound strategy configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentFirst implements SdkPojo, Serializable, ToCopyableBuilder<AgentFirst.Builder, AgentFirst> {
    private static final SdkField<Preview> PREVIEW_FIELD = SdkField.<Preview> builder(MarshallingType.SDK_POJO)
            .memberName("Preview").getter(getter(AgentFirst::preview)).setter(setter(Builder::preview))
            .constructor(Preview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preview").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Preview preview;

    private AgentFirst(BuilderImpl builder) {
        this.preview = builder.preview;
    }

    /**
     * <p>
     * Information about preview configuration of agent first outbound strategy
     * </p>
     * 
     * @return Information about preview configuration of agent first outbound strategy
     */
    public final Preview preview() {
        return preview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preview());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentFirst)) {
            return false;
        }
        AgentFirst other = (AgentFirst) obj;
        return Objects.equals(preview(), other.preview());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentFirst").add("Preview", preview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Preview":
            return Optional.ofNullable(clazz.cast(preview()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Preview", PREVIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentFirst, T> g) {
        return obj -> g.apply((AgentFirst) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentFirst> {
        /**
         * <p>
         * Information about preview configuration of agent first outbound strategy
         * </p>
         * 
         * @param preview
         *        Information about preview configuration of agent first outbound strategy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preview(Preview preview);

        /**
         * <p>
         * Information about preview configuration of agent first outbound strategy
         * </p>
         * This is a convenience method that creates an instance of the {@link Preview.Builder} avoiding the need to
         * create one manually via {@link Preview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Preview.Builder#build()} is called immediately and its result is
         * passed to {@link #preview(Preview)}.
         * 
         * @param preview
         *        a consumer that will call methods on {@link Preview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preview(Preview)
         */
        default Builder preview(Consumer<Preview.Builder> preview) {
            return preview(Preview.builder().applyMutation(preview).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Preview preview;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentFirst model) {
            preview(model.preview);
        }

        public final Preview.Builder getPreview() {
            return preview != null ? preview.toBuilder() : null;
        }

        public final void setPreview(Preview.BuilderImpl preview) {
            this.preview = preview != null ? preview.build() : null;
        }

        @Override
        public final Builder preview(Preview preview) {
            this.preview = preview;
            return this;
        }

        @Override
        public AgentFirst build() {
            return new AgentFirst(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
