/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AssignSla action definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignSlaActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<AssignSlaActionDefinition.Builder, AssignSlaActionDefinition> {
    private static final SdkField<String> SLA_ASSIGNMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlaAssignmentType").getter(getter(AssignSlaActionDefinition::slaAssignmentTypeAsString))
            .setter(setter(Builder::slaAssignmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlaAssignmentType").build()).build();

    private static final SdkField<CaseSlaConfiguration> CASE_SLA_CONFIGURATION_FIELD = SdkField
            .<CaseSlaConfiguration> builder(MarshallingType.SDK_POJO).memberName("CaseSlaConfiguration")
            .getter(getter(AssignSlaActionDefinition::caseSlaConfiguration)).setter(setter(Builder::caseSlaConfiguration))
            .constructor(CaseSlaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseSlaConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLA_ASSIGNMENT_TYPE_FIELD,
            CASE_SLA_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String slaAssignmentType;

    private final CaseSlaConfiguration caseSlaConfiguration;

    private AssignSlaActionDefinition(BuilderImpl builder) {
        this.slaAssignmentType = builder.slaAssignmentType;
        this.caseSlaConfiguration = builder.caseSlaConfiguration;
    }

    /**
     * <p>
     * Type of SLA assignment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slaAssignmentType}
     * will return {@link SlaAssignmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slaAssignmentTypeAsString}.
     * </p>
     * 
     * @return Type of SLA assignment.
     * @see SlaAssignmentType
     */
    public final SlaAssignmentType slaAssignmentType() {
        return SlaAssignmentType.fromValue(slaAssignmentType);
    }

    /**
     * <p>
     * Type of SLA assignment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slaAssignmentType}
     * will return {@link SlaAssignmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slaAssignmentTypeAsString}.
     * </p>
     * 
     * @return Type of SLA assignment.
     * @see SlaAssignmentType
     */
    public final String slaAssignmentTypeAsString() {
        return slaAssignmentType;
    }

    /**
     * <p>
     * The SLA configuration for Case SLA Assignment.
     * </p>
     * 
     * @return The SLA configuration for Case SLA Assignment.
     */
    public final CaseSlaConfiguration caseSlaConfiguration() {
        return caseSlaConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slaAssignmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(caseSlaConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignSlaActionDefinition)) {
            return false;
        }
        AssignSlaActionDefinition other = (AssignSlaActionDefinition) obj;
        return Objects.equals(slaAssignmentTypeAsString(), other.slaAssignmentTypeAsString())
                && Objects.equals(caseSlaConfiguration(), other.caseSlaConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignSlaActionDefinition").add("SlaAssignmentType", slaAssignmentTypeAsString())
                .add("CaseSlaConfiguration", caseSlaConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SlaAssignmentType":
            return Optional.ofNullable(clazz.cast(slaAssignmentTypeAsString()));
        case "CaseSlaConfiguration":
            return Optional.ofNullable(clazz.cast(caseSlaConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SlaAssignmentType", SLA_ASSIGNMENT_TYPE_FIELD);
        map.put("CaseSlaConfiguration", CASE_SLA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssignSlaActionDefinition, T> g) {
        return obj -> g.apply((AssignSlaActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssignSlaActionDefinition> {
        /**
         * <p>
         * Type of SLA assignment.
         * </p>
         * 
         * @param slaAssignmentType
         *        Type of SLA assignment.
         * @see SlaAssignmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlaAssignmentType
         */
        Builder slaAssignmentType(String slaAssignmentType);

        /**
         * <p>
         * Type of SLA assignment.
         * </p>
         * 
         * @param slaAssignmentType
         *        Type of SLA assignment.
         * @see SlaAssignmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlaAssignmentType
         */
        Builder slaAssignmentType(SlaAssignmentType slaAssignmentType);

        /**
         * <p>
         * The SLA configuration for Case SLA Assignment.
         * </p>
         * 
         * @param caseSlaConfiguration
         *        The SLA configuration for Case SLA Assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSlaConfiguration(CaseSlaConfiguration caseSlaConfiguration);

        /**
         * <p>
         * The SLA configuration for Case SLA Assignment.
         * </p>
         * This is a convenience method that creates an instance of the {@link CaseSlaConfiguration.Builder} avoiding
         * the need to create one manually via {@link CaseSlaConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaseSlaConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #caseSlaConfiguration(CaseSlaConfiguration)}.
         * 
         * @param caseSlaConfiguration
         *        a consumer that will call methods on {@link CaseSlaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #caseSlaConfiguration(CaseSlaConfiguration)
         */
        default Builder caseSlaConfiguration(Consumer<CaseSlaConfiguration.Builder> caseSlaConfiguration) {
            return caseSlaConfiguration(CaseSlaConfiguration.builder().applyMutation(caseSlaConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String slaAssignmentType;

        private CaseSlaConfiguration caseSlaConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignSlaActionDefinition model) {
            slaAssignmentType(model.slaAssignmentType);
            caseSlaConfiguration(model.caseSlaConfiguration);
        }

        public final String getSlaAssignmentType() {
            return slaAssignmentType;
        }

        public final void setSlaAssignmentType(String slaAssignmentType) {
            this.slaAssignmentType = slaAssignmentType;
        }

        @Override
        public final Builder slaAssignmentType(String slaAssignmentType) {
            this.slaAssignmentType = slaAssignmentType;
            return this;
        }

        @Override
        public final Builder slaAssignmentType(SlaAssignmentType slaAssignmentType) {
            this.slaAssignmentType(slaAssignmentType == null ? null : slaAssignmentType.toString());
            return this;
        }

        public final CaseSlaConfiguration.Builder getCaseSlaConfiguration() {
            return caseSlaConfiguration != null ? caseSlaConfiguration.toBuilder() : null;
        }

        public final void setCaseSlaConfiguration(CaseSlaConfiguration.BuilderImpl caseSlaConfiguration) {
            this.caseSlaConfiguration = caseSlaConfiguration != null ? caseSlaConfiguration.build() : null;
        }

        @Override
        public final Builder caseSlaConfiguration(CaseSlaConfiguration caseSlaConfiguration) {
            this.caseSlaConfiguration = caseSlaConfiguration;
            return this;
        }

        @Override
        public AssignSlaActionDefinition build() {
            return new AssignSlaActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
