/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about automated evaluations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoEvaluationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoEvaluationDetails.Builder, AutoEvaluationDetails> {
    private static final SdkField<Boolean> AUTO_EVALUATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEvaluationEnabled").getter(getter(AutoEvaluationDetails::autoEvaluationEnabled))
            .setter(setter(Builder::autoEvaluationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationEnabled").build())
            .build();

    private static final SdkField<String> AUTO_EVALUATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoEvaluationStatus").getter(getter(AutoEvaluationDetails::autoEvaluationStatusAsString))
            .setter(setter(Builder::autoEvaluationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_EVALUATION_ENABLED_FIELD,
            AUTO_EVALUATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean autoEvaluationEnabled;

    private final String autoEvaluationStatus;

    private AutoEvaluationDetails(BuilderImpl builder) {
        this.autoEvaluationEnabled = builder.autoEvaluationEnabled;
        this.autoEvaluationStatus = builder.autoEvaluationStatus;
    }

    /**
     * <p>
     * Whether automated evaluation is enabled.
     * </p>
     * 
     * @return Whether automated evaluation is enabled.
     */
    public final Boolean autoEvaluationEnabled() {
        return autoEvaluationEnabled;
    }

    /**
     * <p>
     * The status of the contact auto-evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEvaluationStatus} will return {@link AutoEvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEvaluationStatusAsString}.
     * </p>
     * 
     * @return The status of the contact auto-evaluation.
     * @see AutoEvaluationStatus
     */
    public final AutoEvaluationStatus autoEvaluationStatus() {
        return AutoEvaluationStatus.fromValue(autoEvaluationStatus);
    }

    /**
     * <p>
     * The status of the contact auto-evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEvaluationStatus} will return {@link AutoEvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEvaluationStatusAsString}.
     * </p>
     * 
     * @return The status of the contact auto-evaluation.
     * @see AutoEvaluationStatus
     */
    public final String autoEvaluationStatusAsString() {
        return autoEvaluationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoEvaluationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(autoEvaluationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoEvaluationDetails)) {
            return false;
        }
        AutoEvaluationDetails other = (AutoEvaluationDetails) obj;
        return Objects.equals(autoEvaluationEnabled(), other.autoEvaluationEnabled())
                && Objects.equals(autoEvaluationStatusAsString(), other.autoEvaluationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoEvaluationDetails").add("AutoEvaluationEnabled", autoEvaluationEnabled())
                .add("AutoEvaluationStatus", autoEvaluationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEvaluationEnabled":
            return Optional.ofNullable(clazz.cast(autoEvaluationEnabled()));
        case "AutoEvaluationStatus":
            return Optional.ofNullable(clazz.cast(autoEvaluationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoEvaluationEnabled", AUTO_EVALUATION_ENABLED_FIELD);
        map.put("AutoEvaluationStatus", AUTO_EVALUATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoEvaluationDetails, T> g) {
        return obj -> g.apply((AutoEvaluationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoEvaluationDetails> {
        /**
         * <p>
         * Whether automated evaluation is enabled.
         * </p>
         * 
         * @param autoEvaluationEnabled
         *        Whether automated evaluation is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEvaluationEnabled(Boolean autoEvaluationEnabled);

        /**
         * <p>
         * The status of the contact auto-evaluation.
         * </p>
         * 
         * @param autoEvaluationStatus
         *        The status of the contact auto-evaluation.
         * @see AutoEvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEvaluationStatus
         */
        Builder autoEvaluationStatus(String autoEvaluationStatus);

        /**
         * <p>
         * The status of the contact auto-evaluation.
         * </p>
         * 
         * @param autoEvaluationStatus
         *        The status of the contact auto-evaluation.
         * @see AutoEvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEvaluationStatus
         */
        Builder autoEvaluationStatus(AutoEvaluationStatus autoEvaluationStatus);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoEvaluationEnabled;

        private String autoEvaluationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoEvaluationDetails model) {
            autoEvaluationEnabled(model.autoEvaluationEnabled);
            autoEvaluationStatus(model.autoEvaluationStatus);
        }

        public final Boolean getAutoEvaluationEnabled() {
            return autoEvaluationEnabled;
        }

        public final void setAutoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
        }

        @Override
        public final Builder autoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
            return this;
        }

        public final String getAutoEvaluationStatus() {
            return autoEvaluationStatus;
        }

        public final void setAutoEvaluationStatus(String autoEvaluationStatus) {
            this.autoEvaluationStatus = autoEvaluationStatus;
        }

        @Override
        public final Builder autoEvaluationStatus(String autoEvaluationStatus) {
            this.autoEvaluationStatus = autoEvaluationStatus;
            return this;
        }

        @Override
        public final Builder autoEvaluationStatus(AutoEvaluationStatus autoEvaluationStatus) {
            this.autoEvaluationStatus(autoEvaluationStatus == null ? null : autoEvaluationStatus.toString());
            return this;
        }

        @Override
        public AutoEvaluationDetails build() {
            return new AutoEvaluationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
