/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateAnalyticsDataSetResponse extends ConnectResponse implements
        ToCopyableBuilder<BatchAssociateAnalyticsDataSetResponse.Builder, BatchAssociateAnalyticsDataSetResponse> {
    private static final SdkField<List<AnalyticsDataAssociationResult>> CREATED_FIELD = SdkField
            .<List<AnalyticsDataAssociationResult>> builder(MarshallingType.LIST)
            .memberName("Created")
            .getter(getter(BatchAssociateAnalyticsDataSetResponse::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsDataAssociationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsDataAssociationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ErrorResult>> ERRORS_FIELD = SdkField
            .<List<ErrorResult>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchAssociateAnalyticsDataSetResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AnalyticsDataAssociationResult> created;

    private final List<ErrorResult> errors;

    private BatchAssociateAnalyticsDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.created = builder.created;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Created property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCreated() {
        return created != null && !(created instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about associations that are successfully created: <code>DataSetId</code>,
     * <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreated} method.
     * </p>
     * 
     * @return Information about associations that are successfully created: <code>DataSetId</code>,
     *         <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>.
     */
    public final List<AnalyticsDataAssociationResult> created() {
        return created;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors for datasets that aren't successfully associated with the target account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors for datasets that aren't successfully associated with the target account.
     */
    public final List<ErrorResult> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCreated() ? created() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateAnalyticsDataSetResponse)) {
            return false;
        }
        BatchAssociateAnalyticsDataSetResponse other = (BatchAssociateAnalyticsDataSetResponse) obj;
        return hasCreated() == other.hasCreated() && Objects.equals(created(), other.created())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateAnalyticsDataSetResponse").add("Created", hasCreated() ? created() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Created", CREATED_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateAnalyticsDataSetResponse, T> g) {
        return obj -> g.apply((BatchAssociateAnalyticsDataSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateAnalyticsDataSetResponse> {
        /**
         * <p>
         * Information about associations that are successfully created: <code>DataSetId</code>,
         * <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>.
         * </p>
         * 
         * @param created
         *        Information about associations that are successfully created: <code>DataSetId</code>,
         *        <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Collection<AnalyticsDataAssociationResult> created);

        /**
         * <p>
         * Information about associations that are successfully created: <code>DataSetId</code>,
         * <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>.
         * </p>
         * 
         * @param created
         *        Information about associations that are successfully created: <code>DataSetId</code>,
         *        <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(AnalyticsDataAssociationResult... created);

        /**
         * <p>
         * Information about associations that are successfully created: <code>DataSetId</code>,
         * <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.AnalyticsDataAssociationResult.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.AnalyticsDataAssociationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.AnalyticsDataAssociationResult.Builder#build()} is
         * called immediately and its result is passed to {@link #created(List<AnalyticsDataAssociationResult>)}.
         * 
         * @param created
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.AnalyticsDataAssociationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #created(java.util.Collection<AnalyticsDataAssociationResult>)
         */
        Builder created(Consumer<AnalyticsDataAssociationResult.Builder>... created);

        /**
         * <p>
         * A list of errors for datasets that aren't successfully associated with the target account.
         * </p>
         * 
         * @param errors
         *        A list of errors for datasets that aren't successfully associated with the target account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<ErrorResult> errors);

        /**
         * <p>
         * A list of errors for datasets that aren't successfully associated with the target account.
         * </p>
         * 
         * @param errors
         *        A list of errors for datasets that aren't successfully associated with the target account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(ErrorResult... errors);

        /**
         * <p>
         * A list of errors for datasets that aren't successfully associated with the target account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ErrorResult.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.ErrorResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ErrorResult.Builder#build()} is called immediately and
         * its result is passed to {@link #errors(List<ErrorResult>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ErrorResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<ErrorResult>)
         */
        Builder errors(Consumer<ErrorResult.Builder>... errors);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<AnalyticsDataAssociationResult> created = DefaultSdkAutoConstructList.getInstance();

        private List<ErrorResult> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateAnalyticsDataSetResponse model) {
            super(model);
            created(model.created);
            errors(model.errors);
        }

        public final List<AnalyticsDataAssociationResult.Builder> getCreated() {
            List<AnalyticsDataAssociationResult.Builder> result = AnalyticsDataAssociationResultsCopier
                    .copyToBuilder(this.created);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreated(Collection<AnalyticsDataAssociationResult.BuilderImpl> created) {
            this.created = AnalyticsDataAssociationResultsCopier.copyFromBuilder(created);
        }

        @Override
        public final Builder created(Collection<AnalyticsDataAssociationResult> created) {
            this.created = AnalyticsDataAssociationResultsCopier.copy(created);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder created(AnalyticsDataAssociationResult... created) {
            created(Arrays.asList(created));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder created(Consumer<AnalyticsDataAssociationResult.Builder>... created) {
            created(Stream.of(created).map(c -> AnalyticsDataAssociationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorResult.Builder> getErrors() {
            List<ErrorResult.Builder> result = ErrorResultsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ErrorResult.BuilderImpl> errors) {
            this.errors = ErrorResultsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ErrorResult> errors) {
            this.errors = ErrorResultsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorResult... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorResult.Builder>... errors) {
            errors(Stream.of(errors).map(c -> ErrorResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateAnalyticsDataSetResponse build() {
            return new BatchAssociateAnalyticsDataSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
