/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how agent, bot, and customer interact in a chat contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatMetrics implements SdkPojo, Serializable, ToCopyableBuilder<ChatMetrics.Builder, ChatMetrics> {
    private static final SdkField<ChatContactMetrics> CHAT_CONTACT_METRICS_FIELD = SdkField
            .<ChatContactMetrics> builder(MarshallingType.SDK_POJO).memberName("ChatContactMetrics")
            .getter(getter(ChatMetrics::chatContactMetrics)).setter(setter(Builder::chatContactMetrics))
            .constructor(ChatContactMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatContactMetrics").build())
            .build();

    private static final SdkField<ParticipantMetrics> AGENT_METRICS_FIELD = SdkField
            .<ParticipantMetrics> builder(MarshallingType.SDK_POJO).memberName("AgentMetrics")
            .getter(getter(ChatMetrics::agentMetrics)).setter(setter(Builder::agentMetrics))
            .constructor(ParticipantMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentMetrics").build()).build();

    private static final SdkField<ParticipantMetrics> CUSTOMER_METRICS_FIELD = SdkField
            .<ParticipantMetrics> builder(MarshallingType.SDK_POJO).memberName("CustomerMetrics")
            .getter(getter(ChatMetrics::customerMetrics)).setter(setter(Builder::customerMetrics))
            .constructor(ParticipantMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_CONTACT_METRICS_FIELD,
            AGENT_METRICS_FIELD, CUSTOMER_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ChatContactMetrics chatContactMetrics;

    private final ParticipantMetrics agentMetrics;

    private final ParticipantMetrics customerMetrics;

    private ChatMetrics(BuilderImpl builder) {
        this.chatContactMetrics = builder.chatContactMetrics;
        this.agentMetrics = builder.agentMetrics;
        this.customerMetrics = builder.customerMetrics;
    }

    /**
     * <p>
     * Information about the overall participant interactions at the contact level.
     * </p>
     * 
     * @return Information about the overall participant interactions at the contact level.
     */
    public final ChatContactMetrics chatContactMetrics() {
        return chatContactMetrics;
    }

    /**
     * <p>
     * Information about agent interactions in a contact.
     * </p>
     * 
     * @return Information about agent interactions in a contact.
     */
    public final ParticipantMetrics agentMetrics() {
        return agentMetrics;
    }

    /**
     * <p>
     * Information about customer interactions in a contact.
     * </p>
     * 
     * @return Information about customer interactions in a contact.
     */
    public final ParticipantMetrics customerMetrics() {
        return customerMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chatContactMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(agentMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(customerMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatMetrics)) {
            return false;
        }
        ChatMetrics other = (ChatMetrics) obj;
        return Objects.equals(chatContactMetrics(), other.chatContactMetrics())
                && Objects.equals(agentMetrics(), other.agentMetrics())
                && Objects.equals(customerMetrics(), other.customerMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatMetrics").add("ChatContactMetrics", chatContactMetrics())
                .add("AgentMetrics", agentMetrics()).add("CustomerMetrics", customerMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChatContactMetrics":
            return Optional.ofNullable(clazz.cast(chatContactMetrics()));
        case "AgentMetrics":
            return Optional.ofNullable(clazz.cast(agentMetrics()));
        case "CustomerMetrics":
            return Optional.ofNullable(clazz.cast(customerMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChatContactMetrics", CHAT_CONTACT_METRICS_FIELD);
        map.put("AgentMetrics", AGENT_METRICS_FIELD);
        map.put("CustomerMetrics", CUSTOMER_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatMetrics, T> g) {
        return obj -> g.apply((ChatMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatMetrics> {
        /**
         * <p>
         * Information about the overall participant interactions at the contact level.
         * </p>
         * 
         * @param chatContactMetrics
         *        Information about the overall participant interactions at the contact level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatContactMetrics(ChatContactMetrics chatContactMetrics);

        /**
         * <p>
         * Information about the overall participant interactions at the contact level.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatContactMetrics.Builder} avoiding the
         * need to create one manually via {@link ChatContactMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatContactMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #chatContactMetrics(ChatContactMetrics)}.
         * 
         * @param chatContactMetrics
         *        a consumer that will call methods on {@link ChatContactMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chatContactMetrics(ChatContactMetrics)
         */
        default Builder chatContactMetrics(Consumer<ChatContactMetrics.Builder> chatContactMetrics) {
            return chatContactMetrics(ChatContactMetrics.builder().applyMutation(chatContactMetrics).build());
        }

        /**
         * <p>
         * Information about agent interactions in a contact.
         * </p>
         * 
         * @param agentMetrics
         *        Information about agent interactions in a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentMetrics(ParticipantMetrics agentMetrics);

        /**
         * <p>
         * Information about agent interactions in a contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipantMetrics.Builder} avoiding the
         * need to create one manually via {@link ParticipantMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #agentMetrics(ParticipantMetrics)}.
         * 
         * @param agentMetrics
         *        a consumer that will call methods on {@link ParticipantMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentMetrics(ParticipantMetrics)
         */
        default Builder agentMetrics(Consumer<ParticipantMetrics.Builder> agentMetrics) {
            return agentMetrics(ParticipantMetrics.builder().applyMutation(agentMetrics).build());
        }

        /**
         * <p>
         * Information about customer interactions in a contact.
         * </p>
         * 
         * @param customerMetrics
         *        Information about customer interactions in a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerMetrics(ParticipantMetrics customerMetrics);

        /**
         * <p>
         * Information about customer interactions in a contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipantMetrics.Builder} avoiding the
         * need to create one manually via {@link ParticipantMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #customerMetrics(ParticipantMetrics)}.
         * 
         * @param customerMetrics
         *        a consumer that will call methods on {@link ParticipantMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerMetrics(ParticipantMetrics)
         */
        default Builder customerMetrics(Consumer<ParticipantMetrics.Builder> customerMetrics) {
            return customerMetrics(ParticipantMetrics.builder().applyMutation(customerMetrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChatContactMetrics chatContactMetrics;

        private ParticipantMetrics agentMetrics;

        private ParticipantMetrics customerMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatMetrics model) {
            chatContactMetrics(model.chatContactMetrics);
            agentMetrics(model.agentMetrics);
            customerMetrics(model.customerMetrics);
        }

        public final ChatContactMetrics.Builder getChatContactMetrics() {
            return chatContactMetrics != null ? chatContactMetrics.toBuilder() : null;
        }

        public final void setChatContactMetrics(ChatContactMetrics.BuilderImpl chatContactMetrics) {
            this.chatContactMetrics = chatContactMetrics != null ? chatContactMetrics.build() : null;
        }

        @Override
        public final Builder chatContactMetrics(ChatContactMetrics chatContactMetrics) {
            this.chatContactMetrics = chatContactMetrics;
            return this;
        }

        public final ParticipantMetrics.Builder getAgentMetrics() {
            return agentMetrics != null ? agentMetrics.toBuilder() : null;
        }

        public final void setAgentMetrics(ParticipantMetrics.BuilderImpl agentMetrics) {
            this.agentMetrics = agentMetrics != null ? agentMetrics.build() : null;
        }

        @Override
        public final Builder agentMetrics(ParticipantMetrics agentMetrics) {
            this.agentMetrics = agentMetrics;
            return this;
        }

        public final ParticipantMetrics.Builder getCustomerMetrics() {
            return customerMetrics != null ? customerMetrics.toBuilder() : null;
        }

        public final void setCustomerMetrics(ParticipantMetrics.BuilderImpl customerMetrics) {
            this.customerMetrics = customerMetrics != null ? customerMetrics.build() : null;
        }

        @Override
        public final Builder customerMetrics(ParticipantMetrics customerMetrics) {
            this.customerMetrics = customerMetrics;
            return this;
        }

        @Override
        public ChatMetrics build() {
            return new ChatMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
