/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The streaming configuration, such as the Amazon SNS streaming endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatStreamingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChatStreamingConfiguration.Builder, ChatStreamingConfiguration> {
    private static final SdkField<String> STREAMING_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamingEndpointArn").getter(getter(ChatStreamingConfiguration::streamingEndpointArn))
            .setter(setter(Builder::streamingEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingEndpointArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_ENDPOINT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamingEndpointArn;

    private ChatStreamingConfiguration(BuilderImpl builder) {
        this.streamingEndpointArn = builder.streamingEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the streaming
     * endpoint that is used to publish real-time message streaming for chat conversations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the
     *         streaming endpoint that is used to publish real-time message streaming for chat conversations.
     */
    public final String streamingEndpointArn() {
        return streamingEndpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingEndpointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatStreamingConfiguration)) {
            return false;
        }
        ChatStreamingConfiguration other = (ChatStreamingConfiguration) obj;
        return Objects.equals(streamingEndpointArn(), other.streamingEndpointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatStreamingConfiguration").add("StreamingEndpointArn", streamingEndpointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingEndpointArn":
            return Optional.ofNullable(clazz.cast(streamingEndpointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamingEndpointArn", STREAMING_ENDPOINT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatStreamingConfiguration, T> g) {
        return obj -> g.apply((ChatStreamingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatStreamingConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the
         * streaming endpoint that is used to publish real-time message streaming for chat conversations.
         * </p>
         * 
         * @param streamingEndpointArn
         *        The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the
         *        streaming endpoint that is used to publish real-time message streaming for chat conversations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingEndpointArn(String streamingEndpointArn);
    }

    static final class BuilderImpl implements Builder {
        private String streamingEndpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatStreamingConfiguration model) {
            streamingEndpointArn(model.streamingEndpointArn);
        }

        public final String getStreamingEndpointArn() {
            return streamingEndpointArn;
        }

        public final void setStreamingEndpointArn(String streamingEndpointArn) {
            this.streamingEndpointArn = streamingEndpointArn;
        }

        @Override
        public final Builder streamingEndpointArn(String streamingEndpointArn) {
            this.streamingEndpointArn = streamingEndpointArn;
            return this;
        }

        @Override
        public ChatStreamingConfiguration build() {
            return new ChatStreamingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
