/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a flow.
 * </p>
 * <p>
 * You can also create and update flows using the <a
 * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow language</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowSummary.Builder, ContactFlowSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ContactFlowSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ContactFlowSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ContactFlowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CONTACT_FLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowType").getter(getter(ContactFlowSummary::contactFlowTypeAsString))
            .setter(setter(Builder::contactFlowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowType").build()).build();

    private static final SdkField<String> CONTACT_FLOW_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowState").getter(getter(ContactFlowSummary::contactFlowStateAsString))
            .setter(setter(Builder::contactFlowState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowState").build()).build();

    private static final SdkField<String> CONTACT_FLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowStatus").getter(getter(ContactFlowSummary::contactFlowStatusAsString))
            .setter(setter(Builder::contactFlowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, CONTACT_FLOW_TYPE_FIELD, CONTACT_FLOW_STATE_FIELD, CONTACT_FLOW_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String contactFlowType;

    private final String contactFlowState;

    private final String contactFlowStatus;

    private ContactFlowSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.contactFlowType = builder.contactFlowType;
        this.contactFlowState = builder.contactFlowState;
        this.contactFlowStatus = builder.contactFlowStatus;
    }

    /**
     * <p>
     * The identifier of the flow.
     * </p>
     * 
     * @return The identifier of the flow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the flow.
     * </p>
     * 
     * @return The name of the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowType}
     * will return {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowTypeAsString}.
     * </p>
     * 
     * @return The type of flow.
     * @see ContactFlowType
     */
    public final ContactFlowType contactFlowType() {
        return ContactFlowType.fromValue(contactFlowType);
    }

    /**
     * <p>
     * The type of flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowType}
     * will return {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowTypeAsString}.
     * </p>
     * 
     * @return The type of flow.
     * @see ContactFlowType
     */
    public final String contactFlowTypeAsString() {
        return contactFlowType;
    }

    /**
     * <p>
     * The type of flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowState}
     * will return {@link ContactFlowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowStateAsString}.
     * </p>
     * 
     * @return The type of flow.
     * @see ContactFlowState
     */
    public final ContactFlowState contactFlowState() {
        return ContactFlowState.fromValue(contactFlowState);
    }

    /**
     * <p>
     * The type of flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowState}
     * will return {@link ContactFlowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowStateAsString}.
     * </p>
     * 
     * @return The type of flow.
     * @see ContactFlowState
     */
    public final String contactFlowStateAsString() {
        return contactFlowState;
    }

    /**
     * <p>
     * The status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowStatus}
     * will return {@link ContactFlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowStatusAsString}.
     * </p>
     * 
     * @return The status of the flow.
     * @see ContactFlowStatus
     */
    public final ContactFlowStatus contactFlowStatus() {
        return ContactFlowStatus.fromValue(contactFlowStatus);
    }

    /**
     * <p>
     * The status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contactFlowStatus}
     * will return {@link ContactFlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contactFlowStatusAsString}.
     * </p>
     * 
     * @return The status of the flow.
     * @see ContactFlowStatus
     */
    public final String contactFlowStatusAsString() {
        return contactFlowStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowSummary)) {
            return false;
        }
        ContactFlowSummary other = (ContactFlowSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(contactFlowTypeAsString(), other.contactFlowTypeAsString())
                && Objects.equals(contactFlowStateAsString(), other.contactFlowStateAsString())
                && Objects.equals(contactFlowStatusAsString(), other.contactFlowStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("ContactFlowType", contactFlowTypeAsString()).add("ContactFlowState", contactFlowStateAsString())
                .add("ContactFlowStatus", contactFlowStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ContactFlowType":
            return Optional.ofNullable(clazz.cast(contactFlowTypeAsString()));
        case "ContactFlowState":
            return Optional.ofNullable(clazz.cast(contactFlowStateAsString()));
        case "ContactFlowStatus":
            return Optional.ofNullable(clazz.cast(contactFlowStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ContactFlowType", CONTACT_FLOW_TYPE_FIELD);
        map.put("ContactFlowState", CONTACT_FLOW_STATE_FIELD);
        map.put("ContactFlowStatus", CONTACT_FLOW_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowSummary, T> g) {
        return obj -> g.apply((ContactFlowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowSummary> {
        /**
         * <p>
         * The identifier of the flow.
         * </p>
         * 
         * @param id
         *        The identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the flow.
         * </p>
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of flow.
         * </p>
         * 
         * @param contactFlowType
         *        The type of flow.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder contactFlowType(String contactFlowType);

        /**
         * <p>
         * The type of flow.
         * </p>
         * 
         * @param contactFlowType
         *        The type of flow.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder contactFlowType(ContactFlowType contactFlowType);

        /**
         * <p>
         * The type of flow.
         * </p>
         * 
         * @param contactFlowState
         *        The type of flow.
         * @see ContactFlowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowState
         */
        Builder contactFlowState(String contactFlowState);

        /**
         * <p>
         * The type of flow.
         * </p>
         * 
         * @param contactFlowState
         *        The type of flow.
         * @see ContactFlowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowState
         */
        Builder contactFlowState(ContactFlowState contactFlowState);

        /**
         * <p>
         * The status of the flow.
         * </p>
         * 
         * @param contactFlowStatus
         *        The status of the flow.
         * @see ContactFlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowStatus
         */
        Builder contactFlowStatus(String contactFlowStatus);

        /**
         * <p>
         * The status of the flow.
         * </p>
         * 
         * @param contactFlowStatus
         *        The status of the flow.
         * @see ContactFlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowStatus
         */
        Builder contactFlowStatus(ContactFlowStatus contactFlowStatus);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String contactFlowType;

        private String contactFlowState;

        private String contactFlowStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            contactFlowType(model.contactFlowType);
            contactFlowState(model.contactFlowState);
            contactFlowStatus(model.contactFlowStatus);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getContactFlowType() {
            return contactFlowType;
        }

        public final void setContactFlowType(String contactFlowType) {
            this.contactFlowType = contactFlowType;
        }

        @Override
        public final Builder contactFlowType(String contactFlowType) {
            this.contactFlowType = contactFlowType;
            return this;
        }

        @Override
        public final Builder contactFlowType(ContactFlowType contactFlowType) {
            this.contactFlowType(contactFlowType == null ? null : contactFlowType.toString());
            return this;
        }

        public final String getContactFlowState() {
            return contactFlowState;
        }

        public final void setContactFlowState(String contactFlowState) {
            this.contactFlowState = contactFlowState;
        }

        @Override
        public final Builder contactFlowState(String contactFlowState) {
            this.contactFlowState = contactFlowState;
            return this;
        }

        @Override
        public final Builder contactFlowState(ContactFlowState contactFlowState) {
            this.contactFlowState(contactFlowState == null ? null : contactFlowState.toString());
            return this;
        }

        public final String getContactFlowStatus() {
            return contactFlowStatus;
        }

        public final void setContactFlowStatus(String contactFlowStatus) {
            this.contactFlowStatus = contactFlowStatus;
        }

        @Override
        public final Builder contactFlowStatus(String contactFlowStatus) {
            this.contactFlowStatus = contactFlowStatus;
            return this;
        }

        @Override
        public final Builder contactFlowStatus(ContactFlowStatus contactFlowStatus) {
            this.contactFlowStatus(contactFlowStatus == null ? null : contactFlowStatus.toString());
            return this;
        }

        @Override
        public ContactFlowSummary build() {
            return new ContactFlowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
