/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePredefinedAttributeRequest extends ConnectRequest implements
        ToCopyableBuilder<CreatePredefinedAttributeRequest.Builder, CreatePredefinedAttributeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreatePredefinedAttributeRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreatePredefinedAttributeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PredefinedAttributeValues> VALUES_FIELD = SdkField
            .<PredefinedAttributeValues> builder(MarshallingType.SDK_POJO).memberName("Values")
            .getter(getter(CreatePredefinedAttributeRequest::values)).setter(setter(Builder::values))
            .constructor(PredefinedAttributeValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build()).build();

    private static final SdkField<List<String>> PURPOSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Purposes")
            .getter(getter(CreatePredefinedAttributeRequest::purposes))
            .setter(setter(Builder::purposes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Purposes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InputPredefinedAttributeConfiguration> ATTRIBUTE_CONFIGURATION_FIELD = SdkField
            .<InputPredefinedAttributeConfiguration> builder(MarshallingType.SDK_POJO).memberName("AttributeConfiguration")
            .getter(getter(CreatePredefinedAttributeRequest::attributeConfiguration))
            .setter(setter(Builder::attributeConfiguration)).constructor(InputPredefinedAttributeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            VALUES_FIELD, PURPOSES_FIELD, ATTRIBUTE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String name;

    private final PredefinedAttributeValues values;

    private final List<String> purposes;

    private final InputPredefinedAttributeConfiguration attributeConfiguration;

    private CreatePredefinedAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.values = builder.values;
        this.purposes = builder.purposes;
        this.attributeConfiguration = builder.attributeConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of
     * the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name
     *         (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the predefined attribute.
     * </p>
     * 
     * @return The name of the predefined attribute.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The values of the predefined attribute.
     * </p>
     * 
     * @return The values of the predefined attribute.
     */
    public final PredefinedAttributeValues values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the Purposes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPurposes() {
        return purposes != null && !(purposes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Values that enable you to categorize your predefined attributes. You can use them in custom UI elements across
     * the Amazon Connect admin website.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPurposes} method.
     * </p>
     * 
     * @return Values that enable you to categorize your predefined attributes. You can use them in custom UI elements
     *         across the Amazon Connect admin website.
     */
    public final List<String> purposes() {
        return purposes;
    }

    /**
     * <p>
     * Custom metadata that is associated to predefined attributes to control behavior in upstream services, such as
     * controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
     * </p>
     * 
     * @return Custom metadata that is associated to predefined attributes to control behavior in upstream services,
     *         such as controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
     */
    public final InputPredefinedAttributeConfiguration attributeConfiguration() {
        return attributeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(hasPurposes() ? purposes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePredefinedAttributeRequest)) {
            return false;
        }
        CreatePredefinedAttributeRequest other = (CreatePredefinedAttributeRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(values(), other.values()) && hasPurposes() == other.hasPurposes()
                && Objects.equals(purposes(), other.purposes())
                && Objects.equals(attributeConfiguration(), other.attributeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePredefinedAttributeRequest").add("InstanceId", instanceId()).add("Name", name())
                .add("Values", values()).add("Purposes", hasPurposes() ? purposes() : null)
                .add("AttributeConfiguration", attributeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Purposes":
            return Optional.ofNullable(clazz.cast(purposes()));
        case "AttributeConfiguration":
            return Optional.ofNullable(clazz.cast(attributeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("Purposes", PURPOSES_FIELD);
        map.put("AttributeConfiguration", ATTRIBUTE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePredefinedAttributeRequest, T> g) {
        return obj -> g.apply((CreatePredefinedAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePredefinedAttributeRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN)
         * of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource
         *        Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the predefined attribute.
         * </p>
         * 
         * @param name
         *        The name of the predefined attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The values of the predefined attribute.
         * </p>
         * 
         * @param values
         *        The values of the predefined attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(PredefinedAttributeValues values);

        /**
         * <p>
         * The values of the predefined attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredefinedAttributeValues.Builder}
         * avoiding the need to create one manually via {@link PredefinedAttributeValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredefinedAttributeValues.Builder#build()} is called immediately
         * and its result is passed to {@link #values(PredefinedAttributeValues)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link PredefinedAttributeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(PredefinedAttributeValues)
         */
        default Builder values(Consumer<PredefinedAttributeValues.Builder> values) {
            return values(PredefinedAttributeValues.builder().applyMutation(values).build());
        }

        /**
         * <p>
         * Values that enable you to categorize your predefined attributes. You can use them in custom UI elements
         * across the Amazon Connect admin website.
         * </p>
         * 
         * @param purposes
         *        Values that enable you to categorize your predefined attributes. You can use them in custom UI
         *        elements across the Amazon Connect admin website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purposes(Collection<String> purposes);

        /**
         * <p>
         * Values that enable you to categorize your predefined attributes. You can use them in custom UI elements
         * across the Amazon Connect admin website.
         * </p>
         * 
         * @param purposes
         *        Values that enable you to categorize your predefined attributes. You can use them in custom UI
         *        elements across the Amazon Connect admin website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purposes(String... purposes);

        /**
         * <p>
         * Custom metadata that is associated to predefined attributes to control behavior in upstream services, such as
         * controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
         * </p>
         * 
         * @param attributeConfiguration
         *        Custom metadata that is associated to predefined attributes to control behavior in upstream services,
         *        such as controlling how a predefined attribute should be displayed in the Amazon Connect admin
         *        website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeConfiguration(InputPredefinedAttributeConfiguration attributeConfiguration);

        /**
         * <p>
         * Custom metadata that is associated to predefined attributes to control behavior in upstream services, such as
         * controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InputPredefinedAttributeConfiguration.Builder} avoiding the need to create one manually via
         * {@link InputPredefinedAttributeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputPredefinedAttributeConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #attributeConfiguration(InputPredefinedAttributeConfiguration)}.
         * 
         * @param attributeConfiguration
         *        a consumer that will call methods on {@link InputPredefinedAttributeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeConfiguration(InputPredefinedAttributeConfiguration)
         */
        default Builder attributeConfiguration(Consumer<InputPredefinedAttributeConfiguration.Builder> attributeConfiguration) {
            return attributeConfiguration(InputPredefinedAttributeConfiguration.builder().applyMutation(attributeConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private PredefinedAttributeValues values;

        private List<String> purposes = DefaultSdkAutoConstructList.getInstance();

        private InputPredefinedAttributeConfiguration attributeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePredefinedAttributeRequest model) {
            super(model);
            instanceId(model.instanceId);
            name(model.name);
            values(model.values);
            purposes(model.purposes);
            attributeConfiguration(model.attributeConfiguration);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PredefinedAttributeValues.Builder getValues() {
            return values != null ? values.toBuilder() : null;
        }

        public final void setValues(PredefinedAttributeValues.BuilderImpl values) {
            this.values = values != null ? values.build() : null;
        }

        @Override
        public final Builder values(PredefinedAttributeValues values) {
            this.values = values;
            return this;
        }

        public final Collection<String> getPurposes() {
            if (purposes instanceof SdkAutoConstructList) {
                return null;
            }
            return purposes;
        }

        public final void setPurposes(Collection<String> purposes) {
            this.purposes = PredefinedAttributePurposeNameListCopier.copy(purposes);
        }

        @Override
        public final Builder purposes(Collection<String> purposes) {
            this.purposes = PredefinedAttributePurposeNameListCopier.copy(purposes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purposes(String... purposes) {
            purposes(Arrays.asList(purposes));
            return this;
        }

        public final InputPredefinedAttributeConfiguration.Builder getAttributeConfiguration() {
            return attributeConfiguration != null ? attributeConfiguration.toBuilder() : null;
        }

        public final void setAttributeConfiguration(InputPredefinedAttributeConfiguration.BuilderImpl attributeConfiguration) {
            this.attributeConfiguration = attributeConfiguration != null ? attributeConfiguration.build() : null;
        }

        @Override
        public final Builder attributeConfiguration(InputPredefinedAttributeConfiguration attributeConfiguration) {
            this.attributeConfiguration = attributeConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePredefinedAttributeRequest build() {
            return new CreatePredefinedAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
