/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeInstanceResponse.Builder, DescribeInstanceResponse> {
    private static final SdkField<Instance> INSTANCE_FIELD = SdkField.<Instance> builder(MarshallingType.SDK_POJO)
            .memberName("Instance").getter(getter(DescribeInstanceResponse::instance)).setter(setter(Builder::instance))
            .constructor(Instance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instance").build()).build();

    private static final SdkField<ReplicationConfiguration> REPLICATION_CONFIGURATION_FIELD = SdkField
            .<ReplicationConfiguration> builder(MarshallingType.SDK_POJO).memberName("ReplicationConfiguration")
            .getter(getter(DescribeInstanceResponse::replicationConfiguration)).setter(setter(Builder::replicationConfiguration))
            .constructor(ReplicationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD,
            REPLICATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instance instance;

    private final ReplicationConfiguration replicationConfiguration;

    private DescribeInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instance = builder.instance;
        this.replicationConfiguration = builder.replicationConfiguration;
    }

    /**
     * <p>
     * The name of the instance.
     * </p>
     * 
     * @return The name of the instance.
     */
    public final Instance instance() {
        return instance;
    }

    /**
     * <p>
     * Status information about the replication process. This field is included only when you are using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html">ReplicateInstance</a>
     * API to replicate an Amazon Connect instance across Amazon Web Services Regions. For information about replicating
     * Amazon Connect instances, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html">Create a
     * replica of your existing Amazon Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return Status information about the replication process. This field is included only when you are using the <a
     *         href
     *         ="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html">ReplicateInstance
     *         </a> API to replicate an Amazon Connect instance across Amazon Web Services Regions. For information
     *         about replicating Amazon Connect instances, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html">Create
     *         a replica of your existing Amazon Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final ReplicationConfiguration replicationConfiguration() {
        return replicationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceResponse)) {
            return false;
        }
        DescribeInstanceResponse other = (DescribeInstanceResponse) obj;
        return Objects.equals(instance(), other.instance())
                && Objects.equals(replicationConfiguration(), other.replicationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceResponse").add("Instance", instance())
                .add("ReplicationConfiguration", replicationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instance":
            return Optional.ofNullable(clazz.cast(instance()));
        case "ReplicationConfiguration":
            return Optional.ofNullable(clazz.cast(replicationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Instance", INSTANCE_FIELD);
        map.put("ReplicationConfiguration", REPLICATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceResponse, T> g) {
        return obj -> g.apply((DescribeInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceResponse> {
        /**
         * <p>
         * The name of the instance.
         * </p>
         * 
         * @param instance
         *        The name of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(Instance instance);

        /**
         * <p>
         * The name of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link Instance.Builder} avoiding the need to
         * create one manually via {@link Instance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Instance.Builder#build()} is called immediately and its result is
         * passed to {@link #instance(Instance)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(Instance)
         */
        default Builder instance(Consumer<Instance.Builder> instance) {
            return instance(Instance.builder().applyMutation(instance).build());
        }

        /**
         * <p>
         * Status information about the replication process. This field is included only when you are using the <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html"
         * >ReplicateInstance</a> API to replicate an Amazon Connect instance across Amazon Web Services Regions. For
         * information about replicating Amazon Connect instances, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html">Create a
         * replica of your existing Amazon Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param replicationConfiguration
         *        Status information about the replication process. This field is included only when you are using the
         *        <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html">
         *        ReplicateInstance</a> API to replicate an Amazon Connect instance across Amazon Web Services Regions.
         *        For information about replicating Amazon Connect instances, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html"
         *        >Create a replica of your existing Amazon Connect instance</a> in the <i>Amazon Connect Administrator
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfiguration(ReplicationConfiguration replicationConfiguration);

        /**
         * <p>
         * Status information about the replication process. This field is included only when you are using the <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html"
         * >ReplicateInstance</a> API to replicate an Amazon Connect instance across Amazon Web Services Regions. For
         * information about replicating Amazon Connect instances, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html">Create a
         * replica of your existing Amazon Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ReplicationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #replicationConfiguration(ReplicationConfiguration)}.
         * 
         * @param replicationConfiguration
         *        a consumer that will call methods on {@link ReplicationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationConfiguration(ReplicationConfiguration)
         */
        default Builder replicationConfiguration(Consumer<ReplicationConfiguration.Builder> replicationConfiguration) {
            return replicationConfiguration(ReplicationConfiguration.builder().applyMutation(replicationConfiguration).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private Instance instance;

        private ReplicationConfiguration replicationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceResponse model) {
            super(model);
            instance(model.instance);
            replicationConfiguration(model.replicationConfiguration);
        }

        public final Instance.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        public final void setInstance(Instance.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public final Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public final ReplicationConfiguration.Builder getReplicationConfiguration() {
            return replicationConfiguration != null ? replicationConfiguration.toBuilder() : null;
        }

        public final void setReplicationConfiguration(ReplicationConfiguration.BuilderImpl replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration != null ? replicationConfiguration.build() : null;
        }

        @Override
        public final Builder replicationConfiguration(ReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        @Override
        public DescribeInstanceResponse build() {
            return new DescribeInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
