/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an evaluation acknowledgement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationAcknowledgementSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationAcknowledgementSummary.Builder, EvaluationAcknowledgementSummary> {
    private static final SdkField<Instant> ACKNOWLEDGED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AcknowledgedTime").getter(getter(EvaluationAcknowledgementSummary::acknowledgedTime))
            .setter(setter(Builder::acknowledgedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgedTime").build()).build();

    private static final SdkField<String> ACKNOWLEDGED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcknowledgedBy").getter(getter(EvaluationAcknowledgementSummary::acknowledgedBy))
            .setter(setter(Builder::acknowledgedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgedBy").build()).build();

    private static final SdkField<String> ACKNOWLEDGER_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcknowledgerComment").getter(getter(EvaluationAcknowledgementSummary::acknowledgerComment))
            .setter(setter(Builder::acknowledgerComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgerComment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACKNOWLEDGED_TIME_FIELD,
            ACKNOWLEDGED_BY_FIELD, ACKNOWLEDGER_COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant acknowledgedTime;

    private final String acknowledgedBy;

    private final String acknowledgerComment;

    private EvaluationAcknowledgementSummary(BuilderImpl builder) {
        this.acknowledgedTime = builder.acknowledgedTime;
        this.acknowledgedBy = builder.acknowledgedBy;
        this.acknowledgerComment = builder.acknowledgerComment;
    }

    /**
     * <p>
     * The time when an agent acknowledged the evaluation.
     * </p>
     * 
     * @return The time when an agent acknowledged the evaluation.
     */
    public final Instant acknowledgedTime() {
        return acknowledgedTime;
    }

    /**
     * <p>
     * The agent who acknowledged the evaluation.
     * </p>
     * 
     * @return The agent who acknowledged the evaluation.
     */
    public final String acknowledgedBy() {
        return acknowledgedBy;
    }

    /**
     * <p>
     * A comment from the agent when they confirmed they acknowledged the evaluation.
     * </p>
     * 
     * @return A comment from the agent when they confirmed they acknowledged the evaluation.
     */
    public final String acknowledgerComment() {
        return acknowledgerComment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgedTime());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgedBy());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgerComment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAcknowledgementSummary)) {
            return false;
        }
        EvaluationAcknowledgementSummary other = (EvaluationAcknowledgementSummary) obj;
        return Objects.equals(acknowledgedTime(), other.acknowledgedTime())
                && Objects.equals(acknowledgedBy(), other.acknowledgedBy())
                && Objects.equals(acknowledgerComment(), other.acknowledgerComment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationAcknowledgementSummary").add("AcknowledgedTime", acknowledgedTime())
                .add("AcknowledgedBy", acknowledgedBy()).add("AcknowledgerComment", acknowledgerComment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcknowledgedTime":
            return Optional.ofNullable(clazz.cast(acknowledgedTime()));
        case "AcknowledgedBy":
            return Optional.ofNullable(clazz.cast(acknowledgedBy()));
        case "AcknowledgerComment":
            return Optional.ofNullable(clazz.cast(acknowledgerComment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcknowledgedTime", ACKNOWLEDGED_TIME_FIELD);
        map.put("AcknowledgedBy", ACKNOWLEDGED_BY_FIELD);
        map.put("AcknowledgerComment", ACKNOWLEDGER_COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAcknowledgementSummary, T> g) {
        return obj -> g.apply((EvaluationAcknowledgementSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationAcknowledgementSummary> {
        /**
         * <p>
         * The time when an agent acknowledged the evaluation.
         * </p>
         * 
         * @param acknowledgedTime
         *        The time when an agent acknowledged the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgedTime(Instant acknowledgedTime);

        /**
         * <p>
         * The agent who acknowledged the evaluation.
         * </p>
         * 
         * @param acknowledgedBy
         *        The agent who acknowledged the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgedBy(String acknowledgedBy);

        /**
         * <p>
         * A comment from the agent when they confirmed they acknowledged the evaluation.
         * </p>
         * 
         * @param acknowledgerComment
         *        A comment from the agent when they confirmed they acknowledged the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgerComment(String acknowledgerComment);
    }

    static final class BuilderImpl implements Builder {
        private Instant acknowledgedTime;

        private String acknowledgedBy;

        private String acknowledgerComment;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAcknowledgementSummary model) {
            acknowledgedTime(model.acknowledgedTime);
            acknowledgedBy(model.acknowledgedBy);
            acknowledgerComment(model.acknowledgerComment);
        }

        public final Instant getAcknowledgedTime() {
            return acknowledgedTime;
        }

        public final void setAcknowledgedTime(Instant acknowledgedTime) {
            this.acknowledgedTime = acknowledgedTime;
        }

        @Override
        public final Builder acknowledgedTime(Instant acknowledgedTime) {
            this.acknowledgedTime = acknowledgedTime;
            return this;
        }

        public final String getAcknowledgedBy() {
            return acknowledgedBy;
        }

        public final void setAcknowledgedBy(String acknowledgedBy) {
            this.acknowledgedBy = acknowledgedBy;
        }

        @Override
        public final Builder acknowledgedBy(String acknowledgedBy) {
            this.acknowledgedBy = acknowledgedBy;
            return this;
        }

        public final String getAcknowledgerComment() {
            return acknowledgerComment;
        }

        public final void setAcknowledgerComment(String acknowledgerComment) {
            this.acknowledgerComment = acknowledgerComment;
        }

        @Override
        public final Builder acknowledgerComment(String acknowledgerComment) {
            this.acknowledgerComment = acknowledgerComment;
            return this;
        }

        @Override
        public EvaluationAcknowledgementSummary build() {
            return new EvaluationAcknowledgementSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
