/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Contact Lens category used by evaluation automation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationAutomationRuleCategory implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationAutomationRuleCategory.Builder, EvaluationAutomationRuleCategory> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(EvaluationAutomationRuleCategory::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Condition").getter(getter(EvaluationAutomationRuleCategory::conditionAsString))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<List<EvaluationTranscriptPointOfInterest>> POINTS_OF_INTEREST_FIELD = SdkField
            .<List<EvaluationTranscriptPointOfInterest>> builder(MarshallingType.LIST)
            .memberName("PointsOfInterest")
            .getter(getter(EvaluationAutomationRuleCategory::pointsOfInterest))
            .setter(setter(Builder::pointsOfInterest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointsOfInterest").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationTranscriptPointOfInterest> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationTranscriptPointOfInterest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            CONDITION_FIELD, POINTS_OF_INTEREST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String condition;

    private final List<EvaluationTranscriptPointOfInterest> pointsOfInterest;

    private EvaluationAutomationRuleCategory(BuilderImpl builder) {
        this.category = builder.category;
        this.condition = builder.condition;
        this.pointsOfInterest = builder.pointsOfInterest;
    }

    /**
     * <p>
     * A category label.
     * </p>
     * 
     * @return A category label.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * An automation condition for a Contact Lens category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link QuestionRuleCategoryAutomationCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #conditionAsString}.
     * </p>
     * 
     * @return An automation condition for a Contact Lens category.
     * @see QuestionRuleCategoryAutomationCondition
     */
    public final QuestionRuleCategoryAutomationCondition condition() {
        return QuestionRuleCategoryAutomationCondition.fromValue(condition);
    }

    /**
     * <p>
     * An automation condition for a Contact Lens category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link QuestionRuleCategoryAutomationCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #conditionAsString}.
     * </p>
     * 
     * @return An automation condition for a Contact Lens category.
     * @see QuestionRuleCategoryAutomationCondition
     */
    public final String conditionAsString() {
        return condition;
    }

    /**
     * For responses, this returns true if the service returned a value for the PointsOfInterest property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPointsOfInterest() {
        return pointsOfInterest != null && !(pointsOfInterest instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A point of interest in a contact transcript that indicates match of condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPointsOfInterest} method.
     * </p>
     * 
     * @return A point of interest in a contact transcript that indicates match of condition.
     */
    public final List<EvaluationTranscriptPointOfInterest> pointsOfInterest() {
        return pointsOfInterest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(conditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPointsOfInterest() ? pointsOfInterest() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAutomationRuleCategory)) {
            return false;
        }
        EvaluationAutomationRuleCategory other = (EvaluationAutomationRuleCategory) obj;
        return Objects.equals(category(), other.category()) && Objects.equals(conditionAsString(), other.conditionAsString())
                && hasPointsOfInterest() == other.hasPointsOfInterest()
                && Objects.equals(pointsOfInterest(), other.pointsOfInterest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationAutomationRuleCategory").add("Category", category())
                .add("Condition", conditionAsString()).add("PointsOfInterest", hasPointsOfInterest() ? pointsOfInterest() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(conditionAsString()));
        case "PointsOfInterest":
            return Optional.ofNullable(clazz.cast(pointsOfInterest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Category", CATEGORY_FIELD);
        map.put("Condition", CONDITION_FIELD);
        map.put("PointsOfInterest", POINTS_OF_INTEREST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAutomationRuleCategory, T> g) {
        return obj -> g.apply((EvaluationAutomationRuleCategory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationAutomationRuleCategory> {
        /**
         * <p>
         * A category label.
         * </p>
         * 
         * @param category
         *        A category label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * An automation condition for a Contact Lens category.
         * </p>
         * 
         * @param condition
         *        An automation condition for a Contact Lens category.
         * @see QuestionRuleCategoryAutomationCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuestionRuleCategoryAutomationCondition
         */
        Builder condition(String condition);

        /**
         * <p>
         * An automation condition for a Contact Lens category.
         * </p>
         * 
         * @param condition
         *        An automation condition for a Contact Lens category.
         * @see QuestionRuleCategoryAutomationCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuestionRuleCategoryAutomationCondition
         */
        Builder condition(QuestionRuleCategoryAutomationCondition condition);

        /**
         * <p>
         * A point of interest in a contact transcript that indicates match of condition.
         * </p>
         * 
         * @param pointsOfInterest
         *        A point of interest in a contact transcript that indicates match of condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointsOfInterest(Collection<EvaluationTranscriptPointOfInterest> pointsOfInterest);

        /**
         * <p>
         * A point of interest in a contact transcript that indicates match of condition.
         * </p>
         * 
         * @param pointsOfInterest
         *        A point of interest in a contact transcript that indicates match of condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointsOfInterest(EvaluationTranscriptPointOfInterest... pointsOfInterest);

        /**
         * <p>
         * A point of interest in a contact transcript that indicates match of condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #pointsOfInterest(List<EvaluationTranscriptPointOfInterest>)}.
         * 
         * @param pointsOfInterest
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointsOfInterest(java.util.Collection<EvaluationTranscriptPointOfInterest>)
         */
        Builder pointsOfInterest(Consumer<EvaluationTranscriptPointOfInterest.Builder>... pointsOfInterest);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String condition;

        private List<EvaluationTranscriptPointOfInterest> pointsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAutomationRuleCategory model) {
            category(model.category);
            condition(model.condition);
            pointsOfInterest(model.pointsOfInterest);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(QuestionRuleCategoryAutomationCondition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        public final List<EvaluationTranscriptPointOfInterest.Builder> getPointsOfInterest() {
            List<EvaluationTranscriptPointOfInterest.Builder> result = EvaluationTranscriptPointsOfInterestCopier
                    .copyToBuilder(this.pointsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPointsOfInterest(Collection<EvaluationTranscriptPointOfInterest.BuilderImpl> pointsOfInterest) {
            this.pointsOfInterest = EvaluationTranscriptPointsOfInterestCopier.copyFromBuilder(pointsOfInterest);
        }

        @Override
        public final Builder pointsOfInterest(Collection<EvaluationTranscriptPointOfInterest> pointsOfInterest) {
            this.pointsOfInterest = EvaluationTranscriptPointsOfInterestCopier.copy(pointsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pointsOfInterest(EvaluationTranscriptPointOfInterest... pointsOfInterest) {
            pointsOfInterest(Arrays.asList(pointsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pointsOfInterest(Consumer<EvaluationTranscriptPointOfInterest.Builder>... pointsOfInterest) {
            pointsOfInterest(Stream.of(pointsOfInterest)
                    .map(c -> EvaluationTranscriptPointOfInterest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EvaluationAutomationRuleCategory build() {
            return new EvaluationAutomationRuleCategory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
