/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An operand of the enablement condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormItemEnablementConditionOperand implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormItemEnablementConditionOperand.Builder, EvaluationFormItemEnablementConditionOperand> {
    private static final SdkField<EvaluationFormItemEnablementExpression> EXPRESSION_FIELD = SdkField
            .<EvaluationFormItemEnablementExpression> builder(MarshallingType.SDK_POJO).memberName("Expression")
            .getter(getter(EvaluationFormItemEnablementConditionOperand::expression)).setter(setter(Builder::expression))
            .constructor(EvaluationFormItemEnablementExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<EvaluationFormItemEnablementCondition> CONDITION_FIELD = SdkField
            .<EvaluationFormItemEnablementCondition> builder(MarshallingType.SDK_POJO).memberName("Condition")
            .getter(getter(EvaluationFormItemEnablementConditionOperand::condition)).setter(setter(Builder::condition))
            .constructor(EvaluationFormItemEnablementCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD,
            CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationFormItemEnablementExpression expression;

    private final EvaluationFormItemEnablementCondition condition;

    private final Type type;

    private EvaluationFormItemEnablementConditionOperand(BuilderImpl builder) {
        this.expression = builder.expression;
        this.condition = builder.condition;
        this.type = builder.type;
    }

    /**
     * <p>
     * An expression of the enablement condition.
     * </p>
     * 
     * @return An expression of the enablement condition.
     */
    public final EvaluationFormItemEnablementExpression expression() {
        return expression;
    }

    /**
     * <p>
     * A condition for item enablement.
     * </p>
     * 
     * @return A condition for item enablement.
     */
    public final EvaluationFormItemEnablementCondition condition() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItemEnablementConditionOperand)) {
            return false;
        }
        EvaluationFormItemEnablementConditionOperand other = (EvaluationFormItemEnablementConditionOperand) obj;
        return Objects.equals(expression(), other.expression()) && Objects.equals(condition(), other.condition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormItemEnablementConditionOperand").add("Expression", expression())
                .add("Condition", condition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #expression()} initialized to the given value.
     *
     * <p>
     * An expression of the enablement condition.
     * </p>
     * 
     * @param expression
     *        An expression of the enablement condition.
     */
    public static EvaluationFormItemEnablementConditionOperand fromExpression(EvaluationFormItemEnablementExpression expression) {
        return builder().expression(expression).build();
    }

    /**
     * Create an instance of this class with {@link #expression()} initialized to the given value.
     *
     * <p>
     * An expression of the enablement condition.
     * </p>
     * 
     * @param expression
     *        An expression of the enablement condition.
     */
    public static EvaluationFormItemEnablementConditionOperand fromExpression(
            Consumer<EvaluationFormItemEnablementExpression.Builder> expression) {
        EvaluationFormItemEnablementExpression.Builder builder = EvaluationFormItemEnablementExpression.builder();
        expression.accept(builder);
        return fromExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #condition()} initialized to the given value.
     *
     * <p>
     * A condition for item enablement.
     * </p>
     * 
     * @param condition
     *        A condition for item enablement.
     */
    public static EvaluationFormItemEnablementConditionOperand fromCondition(EvaluationFormItemEnablementCondition condition) {
        return builder().condition(condition).build();
    }

    /**
     * Create an instance of this class with {@link #condition()} initialized to the given value.
     *
     * <p>
     * A condition for item enablement.
     * </p>
     * 
     * @param condition
     *        A condition for item enablement.
     */
    public static EvaluationFormItemEnablementConditionOperand fromCondition(
            Consumer<EvaluationFormItemEnablementCondition.Builder> condition) {
        EvaluationFormItemEnablementCondition.Builder builder = EvaluationFormItemEnablementCondition.builder();
        condition.accept(builder);
        return fromCondition(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItemEnablementConditionOperand, T> g) {
        return obj -> g.apply((EvaluationFormItemEnablementConditionOperand) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormItemEnablementConditionOperand> {
        /**
         * <p>
         * An expression of the enablement condition.
         * </p>
         * 
         * @param expression
         *        An expression of the enablement condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(EvaluationFormItemEnablementExpression expression);

        /**
         * <p>
         * An expression of the enablement condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormItemEnablementExpression.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormItemEnablementExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormItemEnablementExpression.Builder#build()} is called
         * immediately and its result is passed to {@link #expression(EvaluationFormItemEnablementExpression)}.
         * 
         * @param expression
         *        a consumer that will call methods on {@link EvaluationFormItemEnablementExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expression(EvaluationFormItemEnablementExpression)
         */
        default Builder expression(Consumer<EvaluationFormItemEnablementExpression.Builder> expression) {
            return expression(EvaluationFormItemEnablementExpression.builder().applyMutation(expression).build());
        }

        /**
         * <p>
         * A condition for item enablement.
         * </p>
         * 
         * @param condition
         *        A condition for item enablement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(EvaluationFormItemEnablementCondition condition);

        /**
         * <p>
         * A condition for item enablement.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormItemEnablementCondition.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormItemEnablementCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormItemEnablementCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #condition(EvaluationFormItemEnablementCondition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link EvaluationFormItemEnablementCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(EvaluationFormItemEnablementCondition)
         */
        default Builder condition(Consumer<EvaluationFormItemEnablementCondition.Builder> condition) {
            return condition(EvaluationFormItemEnablementCondition.builder().applyMutation(condition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationFormItemEnablementExpression expression;

        private EvaluationFormItemEnablementCondition condition;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItemEnablementConditionOperand model) {
            expression(model.expression);
            condition(model.condition);
        }

        public final EvaluationFormItemEnablementExpression.Builder getExpression() {
            return expression != null ? expression.toBuilder() : null;
        }

        public final void setExpression(EvaluationFormItemEnablementExpression.BuilderImpl expression) {
            Object oldValue = this.expression;
            this.expression = expression != null ? expression.build() : null;
            handleUnionValueChange(Type.EXPRESSION, oldValue, this.expression);
        }

        @Override
        public final Builder expression(EvaluationFormItemEnablementExpression expression) {
            Object oldValue = this.expression;
            this.expression = expression;
            handleUnionValueChange(Type.EXPRESSION, oldValue, this.expression);
            return this;
        }

        public final EvaluationFormItemEnablementCondition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(EvaluationFormItemEnablementCondition.BuilderImpl condition) {
            Object oldValue = this.condition;
            this.condition = condition != null ? condition.build() : null;
            handleUnionValueChange(Type.CONDITION, oldValue, this.condition);
        }

        @Override
        public final Builder condition(EvaluationFormItemEnablementCondition condition) {
            Object oldValue = this.condition;
            this.condition = condition;
            handleUnionValueChange(Type.CONDITION, oldValue, this.condition);
            return this;
        }

        @Override
        public EvaluationFormItemEnablementConditionOperand build() {
            return new EvaluationFormItemEnablementConditionOperand(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationFormItemEnablementConditionOperand#type()
     */
    public enum Type {
        EXPRESSION,

        CONDITION,

        UNKNOWN_TO_SDK_VERSION
    }
}
