/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormSummary.Builder, EvaluationFormSummary> {
    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormId").getter(getter(EvaluationFormSummary::evaluationFormId))
            .setter(setter(Builder::evaluationFormId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()).build();

    private static final SdkField<String> EVALUATION_FORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormArn").getter(getter(EvaluationFormSummary::evaluationFormArn))
            .setter(setter(Builder::evaluationFormArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormArn").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(EvaluationFormSummary::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(EvaluationFormSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(EvaluationFormSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(EvaluationFormSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(EvaluationFormSummary::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_ACTIVATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastActivatedTime").getter(getter(EvaluationFormSummary::lastActivatedTime))
            .setter(setter(Builder::lastActivatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastActivatedTime").build()).build();

    private static final SdkField<String> LAST_ACTIVATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastActivatedBy").getter(getter(EvaluationFormSummary::lastActivatedBy))
            .setter(setter(Builder::lastActivatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastActivatedBy").build()).build();

    private static final SdkField<Integer> LATEST_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LatestVersion").getter(getter(EvaluationFormSummary::latestVersion))
            .setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()).build();

    private static final SdkField<Integer> ACTIVE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActiveVersion").getter(getter(EvaluationFormSummary::activeVersion))
            .setter(setter(Builder::activeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FORM_ID_FIELD,
            EVALUATION_FORM_ARN_FIELD, TITLE_FIELD, CREATED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD,
            LAST_MODIFIED_BY_FIELD, LAST_ACTIVATED_TIME_FIELD, LAST_ACTIVATED_BY_FIELD, LATEST_VERSION_FIELD,
            ACTIVE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String evaluationFormId;

    private final String evaluationFormArn;

    private final String title;

    private final Instant createdTime;

    private final String createdBy;

    private final Instant lastModifiedTime;

    private final String lastModifiedBy;

    private final Instant lastActivatedTime;

    private final String lastActivatedBy;

    private final Integer latestVersion;

    private final Integer activeVersion;

    private EvaluationFormSummary(BuilderImpl builder) {
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormArn = builder.evaluationFormArn;
        this.title = builder.title;
        this.createdTime = builder.createdTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastActivatedTime = builder.lastActivatedTime;
        this.lastActivatedBy = builder.lastActivatedBy;
        this.latestVersion = builder.latestVersion;
        this.activeVersion = builder.activeVersion;
    }

    /**
     * <p>
     * The unique identifier for the evaluation form.
     * </p>
     * 
     * @return The unique identifier for the evaluation form.
     */
    public final String evaluationFormId() {
        return evaluationFormId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the evaluation form resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the evaluation form resource.
     */
    public final String evaluationFormArn() {
        return evaluationFormArn;
    }

    /**
     * <p>
     * A title of the evaluation form.
     * </p>
     * 
     * @return A title of the evaluation form.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The timestamp for when the evaluation form was created.
     * </p>
     * 
     * @return The timestamp for when the evaluation form was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who created the evaluation form.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who created the evaluation form.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The timestamp for when the evaluation form was last updated.
     * </p>
     * 
     * @return The timestamp for when the evaluation form was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The timestamp for when the evaluation form was last activated.
     * </p>
     * 
     * @return The timestamp for when the evaluation form was last activated.
     */
    public final Instant lastActivatedTime() {
        return lastActivatedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last activated the evaluation form.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last activated the evaluation form.
     */
    public final String lastActivatedBy() {
        return lastActivatedBy;
    }

    /**
     * <p>
     * The version number of the latest evaluation form version.
     * </p>
     * 
     * @return The version number of the latest evaluation form version.
     */
    public final Integer latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The version of the active evaluation form version.
     * </p>
     * 
     * @return The version of the active evaluation form version.
     */
    public final Integer activeVersion() {
        return activeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormArn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastActivatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastActivatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(activeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSummary)) {
            return false;
        }
        EvaluationFormSummary other = (EvaluationFormSummary) obj;
        return Objects.equals(evaluationFormId(), other.evaluationFormId())
                && Objects.equals(evaluationFormArn(), other.evaluationFormArn()) && Objects.equals(title(), other.title())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastActivatedTime(), other.lastActivatedTime())
                && Objects.equals(lastActivatedBy(), other.lastActivatedBy())
                && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(activeVersion(), other.activeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormSummary").add("EvaluationFormId", evaluationFormId())
                .add("EvaluationFormArn", evaluationFormArn()).add("Title", title()).add("CreatedTime", createdTime())
                .add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("LastActivatedTime", lastActivatedTime())
                .add("LastActivatedBy", lastActivatedBy()).add("LatestVersion", latestVersion())
                .add("ActiveVersion", activeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationFormId":
            return Optional.ofNullable(clazz.cast(evaluationFormId()));
        case "EvaluationFormArn":
            return Optional.ofNullable(clazz.cast(evaluationFormArn()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastActivatedTime":
            return Optional.ofNullable(clazz.cast(lastActivatedTime()));
        case "LastActivatedBy":
            return Optional.ofNullable(clazz.cast(lastActivatedBy()));
        case "LatestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "ActiveVersion":
            return Optional.ofNullable(clazz.cast(activeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationFormId", EVALUATION_FORM_ID_FIELD);
        map.put("EvaluationFormArn", EVALUATION_FORM_ARN_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LastActivatedTime", LAST_ACTIVATED_TIME_FIELD);
        map.put("LastActivatedBy", LAST_ACTIVATED_BY_FIELD);
        map.put("LatestVersion", LATEST_VERSION_FIELD);
        map.put("ActiveVersion", ACTIVE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormSummary, T> g) {
        return obj -> g.apply((EvaluationFormSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormSummary> {
        /**
         * <p>
         * The unique identifier for the evaluation form.
         * </p>
         * 
         * @param evaluationFormId
         *        The unique identifier for the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormId(String evaluationFormId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the evaluation form resource.
         * </p>
         * 
         * @param evaluationFormArn
         *        The Amazon Resource Name (ARN) for the evaluation form resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormArn(String evaluationFormArn);

        /**
         * <p>
         * A title of the evaluation form.
         * </p>
         * 
         * @param title
         *        A title of the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The timestamp for when the evaluation form was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp for when the evaluation form was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who created the evaluation form.
         * </p>
         * 
         * @param createdBy
         *        The Amazon Resource Name (ARN) of the user who created the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The timestamp for when the evaluation form was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp for when the evaluation form was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
         * </p>
         * 
         * @param lastModifiedBy
         *        The Amazon Resource Name (ARN) of the user who last updated the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The timestamp for when the evaluation form was last activated.
         * </p>
         * 
         * @param lastActivatedTime
         *        The timestamp for when the evaluation form was last activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastActivatedTime(Instant lastActivatedTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last activated the evaluation form.
         * </p>
         * 
         * @param lastActivatedBy
         *        The Amazon Resource Name (ARN) of the user who last activated the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastActivatedBy(String lastActivatedBy);

        /**
         * <p>
         * The version number of the latest evaluation form version.
         * </p>
         * 
         * @param latestVersion
         *        The version number of the latest evaluation form version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(Integer latestVersion);

        /**
         * <p>
         * The version of the active evaluation form version.
         * </p>
         * 
         * @param activeVersion
         *        The version of the active evaluation form version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeVersion(Integer activeVersion);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationFormId;

        private String evaluationFormArn;

        private String title;

        private Instant createdTime;

        private String createdBy;

        private Instant lastModifiedTime;

        private String lastModifiedBy;

        private Instant lastActivatedTime;

        private String lastActivatedBy;

        private Integer latestVersion;

        private Integer activeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormSummary model) {
            evaluationFormId(model.evaluationFormId);
            evaluationFormArn(model.evaluationFormArn);
            title(model.title);
            createdTime(model.createdTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            lastActivatedTime(model.lastActivatedTime);
            lastActivatedBy(model.lastActivatedBy);
            latestVersion(model.latestVersion);
            activeVersion(model.activeVersion);
        }

        public final String getEvaluationFormId() {
            return evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final String getEvaluationFormArn() {
            return evaluationFormArn;
        }

        public final void setEvaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
        }

        @Override
        public final Builder evaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastActivatedTime() {
            return lastActivatedTime;
        }

        public final void setLastActivatedTime(Instant lastActivatedTime) {
            this.lastActivatedTime = lastActivatedTime;
        }

        @Override
        public final Builder lastActivatedTime(Instant lastActivatedTime) {
            this.lastActivatedTime = lastActivatedTime;
            return this;
        }

        public final String getLastActivatedBy() {
            return lastActivatedBy;
        }

        public final void setLastActivatedBy(String lastActivatedBy) {
            this.lastActivatedBy = lastActivatedBy;
        }

        @Override
        public final Builder lastActivatedBy(String lastActivatedBy) {
            this.lastActivatedBy = lastActivatedBy;
            return this;
        }

        public final Integer getLatestVersion() {
            return latestVersion;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getActiveVersion() {
            return activeVersion;
        }

        public final void setActiveVersion(Integer activeVersion) {
            this.activeVersion = activeVersion;
        }

        @Override
        public final Builder activeVersion(Integer activeVersion) {
            this.activeVersion = activeVersion;
            return this;
        }

        @Override
        public EvaluationFormSummary build() {
            return new EvaluationFormSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
