/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata information about an evaluation search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationSearchMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationSearchMetadata.Builder, EvaluationSearchMetadata> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(EvaluationSearchMetadata::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluatorArn").getter(getter(EvaluationSearchMetadata::evaluatorArn))
            .setter(setter(Builder::evaluatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatorArn").build()).build();

    private static final SdkField<String> CONTACT_AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactAgentId").getter(getter(EvaluationSearchMetadata::contactAgentId))
            .setter(setter(Builder::contactAgentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactAgentId").build()).build();

    private static final SdkField<String> CALIBRATION_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalibrationSessionId").getter(getter(EvaluationSearchMetadata::calibrationSessionId))
            .setter(setter(Builder::calibrationSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalibrationSessionId").build())
            .build();

    private static final SdkField<Double> SCORE_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ScorePercentage").getter(getter(EvaluationSearchMetadata::scorePercentage))
            .setter(setter(Builder::scorePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScorePercentage").build()).build();

    private static final SdkField<Boolean> SCORE_AUTOMATIC_FAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ScoreAutomaticFail").getter(getter(EvaluationSearchMetadata::scoreAutomaticFail))
            .setter(setter(Builder::scoreAutomaticFail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreAutomaticFail").build())
            .build();

    private static final SdkField<Boolean> SCORE_NOT_APPLICABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ScoreNotApplicable").getter(getter(EvaluationSearchMetadata::scoreNotApplicable))
            .setter(setter(Builder::scoreNotApplicable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreNotApplicable").build())
            .build();

    private static final SdkField<Boolean> AUTO_EVALUATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEvaluationEnabled").getter(getter(EvaluationSearchMetadata::autoEvaluationEnabled))
            .setter(setter(Builder::autoEvaluationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationEnabled").build())
            .build();

    private static final SdkField<String> AUTO_EVALUATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoEvaluationStatus").getter(getter(EvaluationSearchMetadata::autoEvaluationStatusAsString))
            .setter(setter(Builder::autoEvaluationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationStatus").build())
            .build();

    private static final SdkField<Instant> ACKNOWLEDGED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AcknowledgedTime").getter(getter(EvaluationSearchMetadata::acknowledgedTime))
            .setter(setter(Builder::acknowledgedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgedTime").build()).build();

    private static final SdkField<String> ACKNOWLEDGED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcknowledgedBy").getter(getter(EvaluationSearchMetadata::acknowledgedBy))
            .setter(setter(Builder::acknowledgedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgedBy").build()).build();

    private static final SdkField<String> ACKNOWLEDGER_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcknowledgerComment").getter(getter(EvaluationSearchMetadata::acknowledgerComment))
            .setter(setter(Builder::acknowledgerComment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgerComment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            EVALUATOR_ARN_FIELD, CONTACT_AGENT_ID_FIELD, CALIBRATION_SESSION_ID_FIELD, SCORE_PERCENTAGE_FIELD,
            SCORE_AUTOMATIC_FAIL_FIELD, SCORE_NOT_APPLICABLE_FIELD, AUTO_EVALUATION_ENABLED_FIELD, AUTO_EVALUATION_STATUS_FIELD,
            ACKNOWLEDGED_TIME_FIELD, ACKNOWLEDGED_BY_FIELD, ACKNOWLEDGER_COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactId;

    private final String evaluatorArn;

    private final String contactAgentId;

    private final String calibrationSessionId;

    private final Double scorePercentage;

    private final Boolean scoreAutomaticFail;

    private final Boolean scoreNotApplicable;

    private final Boolean autoEvaluationEnabled;

    private final String autoEvaluationStatus;

    private final Instant acknowledgedTime;

    private final String acknowledgedBy;

    private final String acknowledgerComment;

    private EvaluationSearchMetadata(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.evaluatorArn = builder.evaluatorArn;
        this.contactAgentId = builder.contactAgentId;
        this.calibrationSessionId = builder.calibrationSessionId;
        this.scorePercentage = builder.scorePercentage;
        this.scoreAutomaticFail = builder.scoreAutomaticFail;
        this.scoreNotApplicable = builder.scoreNotApplicable;
        this.autoEvaluationEnabled = builder.autoEvaluationEnabled;
        this.autoEvaluationStatus = builder.autoEvaluationStatus;
        this.acknowledgedTime = builder.acknowledgedTime;
        this.acknowledgedBy = builder.acknowledgedBy;
        this.acknowledgerComment = builder.acknowledgerComment;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the person who evaluated the contact.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the person who evaluated the contact.
     */
    public final String evaluatorArn() {
        return evaluatorArn;
    }

    /**
     * <p>
     * The unique ID of the agent who handled the contact.
     * </p>
     * 
     * @return The unique ID of the agent who handled the contact.
     */
    public final String contactAgentId() {
        return contactAgentId;
    }

    /**
     * <p>
     * The calibration session ID that this evaluation belongs to.
     * </p>
     * 
     * @return The calibration session ID that this evaluation belongs to.
     */
    public final String calibrationSessionId() {
        return calibrationSessionId;
    }

    /**
     * <p>
     * The total evaluation score expressed as a percentage.
     * </p>
     * 
     * @return The total evaluation score expressed as a percentage.
     */
    public final Double scorePercentage() {
        return scorePercentage;
    }

    /**
     * <p>
     * The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail answer, this
     * flag is true.
     * </p>
     * 
     * @return The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail
     *         answer, this flag is true.
     */
    public final Boolean scoreAutomaticFail() {
        return scoreAutomaticFail;
    }

    /**
     * <p>
     * The flag to mark the item as not applicable for scoring.
     * </p>
     * 
     * @return The flag to mark the item as not applicable for scoring.
     */
    public final Boolean scoreNotApplicable() {
        return scoreNotApplicable;
    }

    /**
     * <p>
     * Whether auto-evaluation is enabled.
     * </p>
     * 
     * @return Whether auto-evaluation is enabled.
     */
    public final Boolean autoEvaluationEnabled() {
        return autoEvaluationEnabled;
    }

    /**
     * <p>
     * The status of the contact auto evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEvaluationStatus} will return {@link AutoEvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEvaluationStatusAsString}.
     * </p>
     * 
     * @return The status of the contact auto evaluation.
     * @see AutoEvaluationStatus
     */
    public final AutoEvaluationStatus autoEvaluationStatus() {
        return AutoEvaluationStatus.fromValue(autoEvaluationStatus);
    }

    /**
     * <p>
     * The status of the contact auto evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEvaluationStatus} will return {@link AutoEvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEvaluationStatusAsString}.
     * </p>
     * 
     * @return The status of the contact auto evaluation.
     * @see AutoEvaluationStatus
     */
    public final String autoEvaluationStatusAsString() {
        return autoEvaluationStatus;
    }

    /**
     * <p>
     * When the evaluation was acknowledged by the agent.
     * </p>
     * 
     * @return When the evaluation was acknowledged by the agent.
     */
    public final Instant acknowledgedTime() {
        return acknowledgedTime;
    }

    /**
     * <p>
     * The agent who acknowledged the evaluation.
     * </p>
     * 
     * @return The agent who acknowledged the evaluation.
     */
    public final String acknowledgedBy() {
        return acknowledgedBy;
    }

    /**
     * <p>
     * The comment from the agent when they acknowledged the evaluation.
     * </p>
     * 
     * @return The comment from the agent when they acknowledged the evaluation.
     */
    public final String acknowledgerComment() {
        return acknowledgerComment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(contactAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(calibrationSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(scorePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(scoreAutomaticFail());
        hashCode = 31 * hashCode + Objects.hashCode(scoreNotApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(autoEvaluationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(autoEvaluationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgedTime());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgedBy());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgerComment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSearchMetadata)) {
            return false;
        }
        EvaluationSearchMetadata other = (EvaluationSearchMetadata) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(evaluatorArn(), other.evaluatorArn())
                && Objects.equals(contactAgentId(), other.contactAgentId())
                && Objects.equals(calibrationSessionId(), other.calibrationSessionId())
                && Objects.equals(scorePercentage(), other.scorePercentage())
                && Objects.equals(scoreAutomaticFail(), other.scoreAutomaticFail())
                && Objects.equals(scoreNotApplicable(), other.scoreNotApplicable())
                && Objects.equals(autoEvaluationEnabled(), other.autoEvaluationEnabled())
                && Objects.equals(autoEvaluationStatusAsString(), other.autoEvaluationStatusAsString())
                && Objects.equals(acknowledgedTime(), other.acknowledgedTime())
                && Objects.equals(acknowledgedBy(), other.acknowledgedBy())
                && Objects.equals(acknowledgerComment(), other.acknowledgerComment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationSearchMetadata").add("ContactId", contactId()).add("EvaluatorArn", evaluatorArn())
                .add("ContactAgentId", contactAgentId()).add("CalibrationSessionId", calibrationSessionId())
                .add("ScorePercentage", scorePercentage()).add("ScoreAutomaticFail", scoreAutomaticFail())
                .add("ScoreNotApplicable", scoreNotApplicable()).add("AutoEvaluationEnabled", autoEvaluationEnabled())
                .add("AutoEvaluationStatus", autoEvaluationStatusAsString()).add("AcknowledgedTime", acknowledgedTime())
                .add("AcknowledgedBy", acknowledgedBy()).add("AcknowledgerComment", acknowledgerComment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "EvaluatorArn":
            return Optional.ofNullable(clazz.cast(evaluatorArn()));
        case "ContactAgentId":
            return Optional.ofNullable(clazz.cast(contactAgentId()));
        case "CalibrationSessionId":
            return Optional.ofNullable(clazz.cast(calibrationSessionId()));
        case "ScorePercentage":
            return Optional.ofNullable(clazz.cast(scorePercentage()));
        case "ScoreAutomaticFail":
            return Optional.ofNullable(clazz.cast(scoreAutomaticFail()));
        case "ScoreNotApplicable":
            return Optional.ofNullable(clazz.cast(scoreNotApplicable()));
        case "AutoEvaluationEnabled":
            return Optional.ofNullable(clazz.cast(autoEvaluationEnabled()));
        case "AutoEvaluationStatus":
            return Optional.ofNullable(clazz.cast(autoEvaluationStatusAsString()));
        case "AcknowledgedTime":
            return Optional.ofNullable(clazz.cast(acknowledgedTime()));
        case "AcknowledgedBy":
            return Optional.ofNullable(clazz.cast(acknowledgedBy()));
        case "AcknowledgerComment":
            return Optional.ofNullable(clazz.cast(acknowledgerComment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("EvaluatorArn", EVALUATOR_ARN_FIELD);
        map.put("ContactAgentId", CONTACT_AGENT_ID_FIELD);
        map.put("CalibrationSessionId", CALIBRATION_SESSION_ID_FIELD);
        map.put("ScorePercentage", SCORE_PERCENTAGE_FIELD);
        map.put("ScoreAutomaticFail", SCORE_AUTOMATIC_FAIL_FIELD);
        map.put("ScoreNotApplicable", SCORE_NOT_APPLICABLE_FIELD);
        map.put("AutoEvaluationEnabled", AUTO_EVALUATION_ENABLED_FIELD);
        map.put("AutoEvaluationStatus", AUTO_EVALUATION_STATUS_FIELD);
        map.put("AcknowledgedTime", ACKNOWLEDGED_TIME_FIELD);
        map.put("AcknowledgedBy", ACKNOWLEDGED_BY_FIELD);
        map.put("AcknowledgerComment", ACKNOWLEDGER_COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSearchMetadata, T> g) {
        return obj -> g.apply((EvaluationSearchMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationSearchMetadata> {
        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the person who evaluated the contact.
         * </p>
         * 
         * @param evaluatorArn
         *        The Amazon Resource Name (ARN) of the person who evaluated the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatorArn(String evaluatorArn);

        /**
         * <p>
         * The unique ID of the agent who handled the contact.
         * </p>
         * 
         * @param contactAgentId
         *        The unique ID of the agent who handled the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactAgentId(String contactAgentId);

        /**
         * <p>
         * The calibration session ID that this evaluation belongs to.
         * </p>
         * 
         * @param calibrationSessionId
         *        The calibration session ID that this evaluation belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calibrationSessionId(String calibrationSessionId);

        /**
         * <p>
         * The total evaluation score expressed as a percentage.
         * </p>
         * 
         * @param scorePercentage
         *        The total evaluation score expressed as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scorePercentage(Double scorePercentage);

        /**
         * <p>
         * The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail answer,
         * this flag is true.
         * </p>
         * 
         * @param scoreAutomaticFail
         *        The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail
         *        answer, this flag is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreAutomaticFail(Boolean scoreAutomaticFail);

        /**
         * <p>
         * The flag to mark the item as not applicable for scoring.
         * </p>
         * 
         * @param scoreNotApplicable
         *        The flag to mark the item as not applicable for scoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreNotApplicable(Boolean scoreNotApplicable);

        /**
         * <p>
         * Whether auto-evaluation is enabled.
         * </p>
         * 
         * @param autoEvaluationEnabled
         *        Whether auto-evaluation is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEvaluationEnabled(Boolean autoEvaluationEnabled);

        /**
         * <p>
         * The status of the contact auto evaluation.
         * </p>
         * 
         * @param autoEvaluationStatus
         *        The status of the contact auto evaluation.
         * @see AutoEvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEvaluationStatus
         */
        Builder autoEvaluationStatus(String autoEvaluationStatus);

        /**
         * <p>
         * The status of the contact auto evaluation.
         * </p>
         * 
         * @param autoEvaluationStatus
         *        The status of the contact auto evaluation.
         * @see AutoEvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEvaluationStatus
         */
        Builder autoEvaluationStatus(AutoEvaluationStatus autoEvaluationStatus);

        /**
         * <p>
         * When the evaluation was acknowledged by the agent.
         * </p>
         * 
         * @param acknowledgedTime
         *        When the evaluation was acknowledged by the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgedTime(Instant acknowledgedTime);

        /**
         * <p>
         * The agent who acknowledged the evaluation.
         * </p>
         * 
         * @param acknowledgedBy
         *        The agent who acknowledged the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgedBy(String acknowledgedBy);

        /**
         * <p>
         * The comment from the agent when they acknowledged the evaluation.
         * </p>
         * 
         * @param acknowledgerComment
         *        The comment from the agent when they acknowledged the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgerComment(String acknowledgerComment);
    }

    static final class BuilderImpl implements Builder {
        private String contactId;

        private String evaluatorArn;

        private String contactAgentId;

        private String calibrationSessionId;

        private Double scorePercentage;

        private Boolean scoreAutomaticFail;

        private Boolean scoreNotApplicable;

        private Boolean autoEvaluationEnabled;

        private String autoEvaluationStatus;

        private Instant acknowledgedTime;

        private String acknowledgedBy;

        private String acknowledgerComment;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSearchMetadata model) {
            contactId(model.contactId);
            evaluatorArn(model.evaluatorArn);
            contactAgentId(model.contactAgentId);
            calibrationSessionId(model.calibrationSessionId);
            scorePercentage(model.scorePercentage);
            scoreAutomaticFail(model.scoreAutomaticFail);
            scoreNotApplicable(model.scoreNotApplicable);
            autoEvaluationEnabled(model.autoEvaluationEnabled);
            autoEvaluationStatus(model.autoEvaluationStatus);
            acknowledgedTime(model.acknowledgedTime);
            acknowledgedBy(model.acknowledgedBy);
            acknowledgerComment(model.acknowledgerComment);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getEvaluatorArn() {
            return evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final String getContactAgentId() {
            return contactAgentId;
        }

        public final void setContactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
        }

        @Override
        public final Builder contactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
            return this;
        }

        public final String getCalibrationSessionId() {
            return calibrationSessionId;
        }

        public final void setCalibrationSessionId(String calibrationSessionId) {
            this.calibrationSessionId = calibrationSessionId;
        }

        @Override
        public final Builder calibrationSessionId(String calibrationSessionId) {
            this.calibrationSessionId = calibrationSessionId;
            return this;
        }

        public final Double getScorePercentage() {
            return scorePercentage;
        }

        public final void setScorePercentage(Double scorePercentage) {
            this.scorePercentage = scorePercentage;
        }

        @Override
        public final Builder scorePercentage(Double scorePercentage) {
            this.scorePercentage = scorePercentage;
            return this;
        }

        public final Boolean getScoreAutomaticFail() {
            return scoreAutomaticFail;
        }

        public final void setScoreAutomaticFail(Boolean scoreAutomaticFail) {
            this.scoreAutomaticFail = scoreAutomaticFail;
        }

        @Override
        public final Builder scoreAutomaticFail(Boolean scoreAutomaticFail) {
            this.scoreAutomaticFail = scoreAutomaticFail;
            return this;
        }

        public final Boolean getScoreNotApplicable() {
            return scoreNotApplicable;
        }

        public final void setScoreNotApplicable(Boolean scoreNotApplicable) {
            this.scoreNotApplicable = scoreNotApplicable;
        }

        @Override
        public final Builder scoreNotApplicable(Boolean scoreNotApplicable) {
            this.scoreNotApplicable = scoreNotApplicable;
            return this;
        }

        public final Boolean getAutoEvaluationEnabled() {
            return autoEvaluationEnabled;
        }

        public final void setAutoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
        }

        @Override
        public final Builder autoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
            return this;
        }

        public final String getAutoEvaluationStatus() {
            return autoEvaluationStatus;
        }

        public final void setAutoEvaluationStatus(String autoEvaluationStatus) {
            this.autoEvaluationStatus = autoEvaluationStatus;
        }

        @Override
        public final Builder autoEvaluationStatus(String autoEvaluationStatus) {
            this.autoEvaluationStatus = autoEvaluationStatus;
            return this;
        }

        @Override
        public final Builder autoEvaluationStatus(AutoEvaluationStatus autoEvaluationStatus) {
            this.autoEvaluationStatus(autoEvaluationStatus == null ? null : autoEvaluationStatus.toString());
            return this;
        }

        public final Instant getAcknowledgedTime() {
            return acknowledgedTime;
        }

        public final void setAcknowledgedTime(Instant acknowledgedTime) {
            this.acknowledgedTime = acknowledgedTime;
        }

        @Override
        public final Builder acknowledgedTime(Instant acknowledgedTime) {
            this.acknowledgedTime = acknowledgedTime;
            return this;
        }

        public final String getAcknowledgedBy() {
            return acknowledgedBy;
        }

        public final void setAcknowledgedBy(String acknowledgedBy) {
            this.acknowledgedBy = acknowledgedBy;
        }

        @Override
        public final Builder acknowledgedBy(String acknowledgedBy) {
            this.acknowledgedBy = acknowledgedBy;
            return this;
        }

        public final String getAcknowledgerComment() {
            return acknowledgerComment;
        }

        public final void setAcknowledgerComment(String acknowledgerComment) {
            this.acknowledgerComment = acknowledgerComment;
        }

        @Override
        public final Builder acknowledgerComment(String acknowledgerComment) {
            this.acknowledgerComment = acknowledgerComment;
            return this;
        }

        @Override
        public EvaluationSearchMetadata build() {
            return new EvaluationSearchMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
