/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the point of interest in transcript provided to evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationTranscriptPointOfInterest implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationTranscriptPointOfInterest.Builder, EvaluationTranscriptPointOfInterest> {
    private static final SdkField<EvaluationSuggestedAnswerTranscriptMillisecondOffsets> MILLISECOND_OFFSETS_FIELD = SdkField
            .<EvaluationSuggestedAnswerTranscriptMillisecondOffsets> builder(MarshallingType.SDK_POJO)
            .memberName("MillisecondOffsets").getter(getter(EvaluationTranscriptPointOfInterest::millisecondOffsets))
            .setter(setter(Builder::millisecondOffsets))
            .constructor(EvaluationSuggestedAnswerTranscriptMillisecondOffsets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MillisecondOffsets").build())
            .build();

    private static final SdkField<String> TRANSCRIPT_SEGMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscriptSegment").getter(getter(EvaluationTranscriptPointOfInterest::transcriptSegment))
            .setter(setter(Builder::transcriptSegment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptSegment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MILLISECOND_OFFSETS_FIELD,
            TRANSCRIPT_SEGMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationSuggestedAnswerTranscriptMillisecondOffsets millisecondOffsets;

    private final String transcriptSegment;

    private EvaluationTranscriptPointOfInterest(BuilderImpl builder) {
        this.millisecondOffsets = builder.millisecondOffsets;
        this.transcriptSegment = builder.transcriptSegment;
    }

    /**
     * <p>
     * Offset in milliseconds from the beginning of transcript.
     * </p>
     * 
     * @return Offset in milliseconds from the beginning of transcript.
     */
    public final EvaluationSuggestedAnswerTranscriptMillisecondOffsets millisecondOffsets() {
        return millisecondOffsets;
    }

    /**
     * <p>
     * Segment of transcript.
     * </p>
     * 
     * @return Segment of transcript.
     */
    public final String transcriptSegment() {
        return transcriptSegment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(millisecondOffsets());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptSegment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationTranscriptPointOfInterest)) {
            return false;
        }
        EvaluationTranscriptPointOfInterest other = (EvaluationTranscriptPointOfInterest) obj;
        return Objects.equals(millisecondOffsets(), other.millisecondOffsets())
                && Objects.equals(transcriptSegment(), other.transcriptSegment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationTranscriptPointOfInterest").add("MillisecondOffsets", millisecondOffsets())
                .add("TranscriptSegment", transcriptSegment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MillisecondOffsets":
            return Optional.ofNullable(clazz.cast(millisecondOffsets()));
        case "TranscriptSegment":
            return Optional.ofNullable(clazz.cast(transcriptSegment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MillisecondOffsets", MILLISECOND_OFFSETS_FIELD);
        map.put("TranscriptSegment", TRANSCRIPT_SEGMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationTranscriptPointOfInterest, T> g) {
        return obj -> g.apply((EvaluationTranscriptPointOfInterest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationTranscriptPointOfInterest> {
        /**
         * <p>
         * Offset in milliseconds from the beginning of transcript.
         * </p>
         * 
         * @param millisecondOffsets
         *        Offset in milliseconds from the beginning of transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder millisecondOffsets(EvaluationSuggestedAnswerTranscriptMillisecondOffsets millisecondOffsets);

        /**
         * <p>
         * Offset in milliseconds from the beginning of transcript.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationSuggestedAnswerTranscriptMillisecondOffsets.Builder} avoiding the need to create one
         * manually via {@link EvaluationSuggestedAnswerTranscriptMillisecondOffsets#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link EvaluationSuggestedAnswerTranscriptMillisecondOffsets.Builder#build()} is called immediately and its
         * result is passed to {@link #millisecondOffsets(EvaluationSuggestedAnswerTranscriptMillisecondOffsets)}.
         * 
         * @param millisecondOffsets
         *        a consumer that will call methods on
         *        {@link EvaluationSuggestedAnswerTranscriptMillisecondOffsets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #millisecondOffsets(EvaluationSuggestedAnswerTranscriptMillisecondOffsets)
         */
        default Builder millisecondOffsets(
                Consumer<EvaluationSuggestedAnswerTranscriptMillisecondOffsets.Builder> millisecondOffsets) {
            return millisecondOffsets(EvaluationSuggestedAnswerTranscriptMillisecondOffsets.builder()
                    .applyMutation(millisecondOffsets).build());
        }

        /**
         * <p>
         * Segment of transcript.
         * </p>
         * 
         * @param transcriptSegment
         *        Segment of transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptSegment(String transcriptSegment);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationSuggestedAnswerTranscriptMillisecondOffsets millisecondOffsets;

        private String transcriptSegment;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationTranscriptPointOfInterest model) {
            millisecondOffsets(model.millisecondOffsets);
            transcriptSegment(model.transcriptSegment);
        }

        public final EvaluationSuggestedAnswerTranscriptMillisecondOffsets.Builder getMillisecondOffsets() {
            return millisecondOffsets != null ? millisecondOffsets.toBuilder() : null;
        }

        public final void setMillisecondOffsets(
                EvaluationSuggestedAnswerTranscriptMillisecondOffsets.BuilderImpl millisecondOffsets) {
            this.millisecondOffsets = millisecondOffsets != null ? millisecondOffsets.build() : null;
        }

        @Override
        public final Builder millisecondOffsets(EvaluationSuggestedAnswerTranscriptMillisecondOffsets millisecondOffsets) {
            this.millisecondOffsets = millisecondOffsets;
            return this;
        }

        public final String getTranscriptSegment() {
            return transcriptSegment;
        }

        public final void setTranscriptSegment(String transcriptSegment) {
            this.transcriptSegment = transcriptSegment;
        }

        @Override
        public final Builder transcriptSegment(String transcriptSegment) {
            this.transcriptSegment = transcriptSegment;
            return this;
        }

        @Override
        public EvaluationTranscriptPointOfInterest build() {
            return new EvaluationTranscriptPointOfInterest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
