/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request for which contact failed to be generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedRequest implements SdkPojo, Serializable, ToCopyableBuilder<FailedRequest.Builder, FailedRequest> {
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestIdentifier").getter(getter(FailedRequest::requestIdentifier))
            .setter(setter(Builder::requestIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()).build();

    private static final SdkField<String> FAILURE_REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReasonCode").getter(getter(FailedRequest::failureReasonCodeAsString))
            .setter(setter(Builder::failureReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReasonCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReasonMessage").getter(getter(FailedRequest::failureReasonMessage))
            .setter(setter(Builder::failureReasonMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReasonMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_IDENTIFIER_FIELD,
            FAILURE_REASON_CODE_FIELD, FAILURE_REASON_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String requestIdentifier;

    private final String failureReasonCode;

    private final String failureReasonMessage;

    private FailedRequest(BuilderImpl builder) {
        this.requestIdentifier = builder.requestIdentifier;
        this.failureReasonCode = builder.failureReasonCode;
        this.failureReasonMessage = builder.failureReasonMessage;
    }

    /**
     * <p>
     * Request identifier provided in the API call in the ContactDataRequest to create a contact.
     * </p>
     * 
     * @return Request identifier provided in the API call in the ContactDataRequest to create a contact.
     */
    public final String requestIdentifier() {
        return requestIdentifier;
    }

    /**
     * <p>
     * Reason code for the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureReasonCode}
     * will return {@link FailureReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureReasonCodeAsString}.
     * </p>
     * 
     * @return Reason code for the failure.
     * @see FailureReasonCode
     */
    public final FailureReasonCode failureReasonCode() {
        return FailureReasonCode.fromValue(failureReasonCode);
    }

    /**
     * <p>
     * Reason code for the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureReasonCode}
     * will return {@link FailureReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureReasonCodeAsString}.
     * </p>
     * 
     * @return Reason code for the failure.
     * @see FailureReasonCode
     */
    public final String failureReasonCodeAsString() {
        return failureReasonCode;
    }

    /**
     * <p>
     * Why the request to create a contact failed.
     * </p>
     * 
     * @return Why the request to create a contact failed.
     */
    public final String failureReasonMessage() {
        return failureReasonMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(failureReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReasonMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedRequest)) {
            return false;
        }
        FailedRequest other = (FailedRequest) obj;
        return Objects.equals(requestIdentifier(), other.requestIdentifier())
                && Objects.equals(failureReasonCodeAsString(), other.failureReasonCodeAsString())
                && Objects.equals(failureReasonMessage(), other.failureReasonMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedRequest").add("RequestIdentifier", requestIdentifier())
                .add("FailureReasonCode", failureReasonCodeAsString()).add("FailureReasonMessage", failureReasonMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestIdentifier":
            return Optional.ofNullable(clazz.cast(requestIdentifier()));
        case "FailureReasonCode":
            return Optional.ofNullable(clazz.cast(failureReasonCodeAsString()));
        case "FailureReasonMessage":
            return Optional.ofNullable(clazz.cast(failureReasonMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
        map.put("FailureReasonCode", FAILURE_REASON_CODE_FIELD);
        map.put("FailureReasonMessage", FAILURE_REASON_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedRequest, T> g) {
        return obj -> g.apply((FailedRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedRequest> {
        /**
         * <p>
         * Request identifier provided in the API call in the ContactDataRequest to create a contact.
         * </p>
         * 
         * @param requestIdentifier
         *        Request identifier provided in the API call in the ContactDataRequest to create a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdentifier(String requestIdentifier);

        /**
         * <p>
         * Reason code for the failure.
         * </p>
         * 
         * @param failureReasonCode
         *        Reason code for the failure.
         * @see FailureReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureReasonCode
         */
        Builder failureReasonCode(String failureReasonCode);

        /**
         * <p>
         * Reason code for the failure.
         * </p>
         * 
         * @param failureReasonCode
         *        Reason code for the failure.
         * @see FailureReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureReasonCode
         */
        Builder failureReasonCode(FailureReasonCode failureReasonCode);

        /**
         * <p>
         * Why the request to create a contact failed.
         * </p>
         * 
         * @param failureReasonMessage
         *        Why the request to create a contact failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasonMessage(String failureReasonMessage);
    }

    static final class BuilderImpl implements Builder {
        private String requestIdentifier;

        private String failureReasonCode;

        private String failureReasonMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedRequest model) {
            requestIdentifier(model.requestIdentifier);
            failureReasonCode(model.failureReasonCode);
            failureReasonMessage(model.failureReasonMessage);
        }

        public final String getRequestIdentifier() {
            return requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final String getFailureReasonCode() {
            return failureReasonCode;
        }

        public final void setFailureReasonCode(String failureReasonCode) {
            this.failureReasonCode = failureReasonCode;
        }

        @Override
        public final Builder failureReasonCode(String failureReasonCode) {
            this.failureReasonCode = failureReasonCode;
            return this;
        }

        @Override
        public final Builder failureReasonCode(FailureReasonCode failureReasonCode) {
            this.failureReasonCode(failureReasonCode == null ? null : failureReasonCode.toString());
            return this;
        }

        public final String getFailureReasonMessage() {
            return failureReasonMessage;
        }

        public final void setFailureReasonMessage(String failureReasonMessage) {
            this.failureReasonMessage = failureReasonMessage;
        }

        @Override
        public final Builder failureReasonMessage(String failureReasonMessage) {
            this.failureReasonMessage = failureReasonMessage;
            return this;
        }

        @Override
        public FailedRequest build() {
            return new FailedRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
