/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object for case field values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldValue implements SdkPojo, Serializable, ToCopyableBuilder<FieldValue.Builder, FieldValue> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FieldValue::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<FieldValueUnion> VALUE_FIELD = SdkField.<FieldValueUnion> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(FieldValue::value)).setter(setter(Builder::value))
            .constructor(FieldValueUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final FieldValueUnion value;

    private FieldValue(BuilderImpl builder) {
        this.id = builder.id;
        this.value = builder.value;
    }

    /**
     * <p>
     * Unique identifier of a field.
     * </p>
     * 
     * @return Unique identifier of a field.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Union of potential field value types.
     * </p>
     * 
     * @return Union of potential field value types.
     */
    public final FieldValueUnion value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldValue)) {
            return false;
        }
        FieldValue other = (FieldValue) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldValue").add("Id", id()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldValue, T> g) {
        return obj -> g.apply((FieldValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldValue> {
        /**
         * <p>
         * Unique identifier of a field.
         * </p>
         * 
         * @param id
         *        Unique identifier of a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Union of potential field value types.
         * </p>
         * 
         * @param value
         *        Union of potential field value types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(FieldValueUnion value);

        /**
         * <p>
         * Union of potential field value types.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldValueUnion.Builder} avoiding the
         * need to create one manually via {@link FieldValueUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldValueUnion.Builder#build()} is called immediately and its
         * result is passed to {@link #value(FieldValueUnion)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link FieldValueUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(FieldValueUnion)
         */
        default Builder value(Consumer<FieldValueUnion.Builder> value) {
            return value(FieldValueUnion.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private FieldValueUnion value;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldValue model) {
            id(model.id);
            value(model.value);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final FieldValueUnion.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(FieldValueUnion.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(FieldValueUnion value) {
            this.value = value;
            return this;
        }

        @Override
        public FieldValue build() {
            return new FieldValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
