/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the filter to apply when retrieving metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filters implements SdkPojo, Serializable, ToCopyableBuilder<Filters.Builder, Filters> {
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Queues")
            .getter(getter(Filters::queues))
            .setter(setter(Builder::queues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Channels")
            .getter(getter(Filters::channelsAsStrings))
            .setter(setter(Builder::channelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ROUTING_PROFILES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RoutingProfiles")
            .getter(getter(Filters::routingProfiles))
            .setter(setter(Builder::routingProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ROUTING_STEP_EXPRESSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RoutingStepExpressions")
            .getter(getter(Filters::routingStepExpressions))
            .setter(setter(Builder::routingStepExpressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStepExpressions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AGENT_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentStatuses")
            .getter(getter(Filters::agentStatuses))
            .setter(setter(Builder::agentStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD, CHANNELS_FIELD,
            ROUTING_PROFILES_FIELD, ROUTING_STEP_EXPRESSIONS_FIELD, AGENT_STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> queues;

    private final List<String> channels;

    private final List<String> routingProfiles;

    private final List<String> routingStepExpressions;

    private final List<String> agentStatuses;

    private Filters(BuilderImpl builder) {
        this.queues = builder.queues;
        this.channels = builder.channels;
        this.routingProfiles = builder.routingProfiles;
        this.routingStepExpressions = builder.routingStepExpressions;
        this.agentStatuses = builder.agentStatuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueues() {
        return queues != null && !(queues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100 queues
     * per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you include a
     * <code>Filter</code> in your request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueues} method.
     * </p>
     * 
     * @return The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100
     *         queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you
     *         include a <code>Filter</code> in your request.
     */
    public final List<String> queues() {
        return queues;
    }

    /**
     * <p>
     * The channel to use to filter the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The channel to use to filter the metrics.
     */
    public final List<Channel> channels() {
        return ChannelsCopier.copyStringToEnum(channels);
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channel to use to filter the metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The channel to use to filter the metrics.
     */
    public final List<String> channelsAsStrings() {
        return channels;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingProfiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingProfiles() {
        return routingProfiles != null && !(routingProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 routing profile IDs or ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingProfiles} method.
     * </p>
     * 
     * @return A list of up to 100 routing profile IDs or ARNs.
     */
    public final List<String> routingProfiles() {
        return routingProfiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingStepExpressions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRoutingStepExpressions() {
        return routingStepExpressions != null && !(routingStepExpressions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of expressions as a filter, in which an expression is an object of a step in a routing criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingStepExpressions} method.
     * </p>
     * 
     * @return A list of expressions as a filter, in which an expression is an object of a step in a routing criteria.
     */
    public final List<String> routingStepExpressions() {
        return routingStepExpressions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentStatuses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentStatuses() {
        return agentStatuses != null && !(agentStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 agent status IDs or ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentStatuses} method.
     * </p>
     * 
     * @return A list of up to 50 agent status IDs or ARNs.
     */
    public final List<String> agentStatuses() {
        return agentStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasQueues() ? queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingProfiles() ? routingProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingStepExpressions() ? routingStepExpressions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentStatuses() ? agentStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters) obj;
        return hasQueues() == other.hasQueues() && Objects.equals(queues(), other.queues())
                && hasChannels() == other.hasChannels() && Objects.equals(channelsAsStrings(), other.channelsAsStrings())
                && hasRoutingProfiles() == other.hasRoutingProfiles()
                && Objects.equals(routingProfiles(), other.routingProfiles())
                && hasRoutingStepExpressions() == other.hasRoutingStepExpressions()
                && Objects.equals(routingStepExpressions(), other.routingStepExpressions())
                && hasAgentStatuses() == other.hasAgentStatuses() && Objects.equals(agentStatuses(), other.agentStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filters").add("Queues", hasQueues() ? queues() : null)
                .add("Channels", hasChannels() ? channelsAsStrings() : null)
                .add("RoutingProfiles", hasRoutingProfiles() ? routingProfiles() : null)
                .add("RoutingStepExpressions", hasRoutingStepExpressions() ? routingStepExpressions() : null)
                .add("AgentStatuses", hasAgentStatuses() ? agentStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Queues":
            return Optional.ofNullable(clazz.cast(queues()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channelsAsStrings()));
        case "RoutingProfiles":
            return Optional.ofNullable(clazz.cast(routingProfiles()));
        case "RoutingStepExpressions":
            return Optional.ofNullable(clazz.cast(routingStepExpressions()));
        case "AgentStatuses":
            return Optional.ofNullable(clazz.cast(agentStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Queues", QUEUES_FIELD);
        map.put("Channels", CHANNELS_FIELD);
        map.put("RoutingProfiles", ROUTING_PROFILES_FIELD);
        map.put("RoutingStepExpressions", ROUTING_STEP_EXPRESSIONS_FIELD);
        map.put("AgentStatuses", AGENT_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filters, T> g) {
        return obj -> g.apply((Filters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filters> {
        /**
         * <p>
         * The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100
         * queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you
         * include a <code>Filter</code> in your request.
         * </p>
         * 
         * @param queues
         *        The queues to use to filter the metrics. You should specify at least one queue, and can specify up to
         *        100 queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when
         *        you include a <code>Filter</code> in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Collection<String> queues);

        /**
         * <p>
         * The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100
         * queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you
         * include a <code>Filter</code> in your request.
         * </p>
         * 
         * @param queues
         *        The queues to use to filter the metrics. You should specify at least one queue, and can specify up to
         *        100 queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when
         *        you include a <code>Filter</code> in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(String... queues);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(Collection<String> channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(String... channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<Channel> channels);

        /**
         * <p>
         * The channel to use to filter the metrics.
         * </p>
         * 
         * @param channels
         *        The channel to use to filter the metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Channel... channels);

        /**
         * <p>
         * A list of up to 100 routing profile IDs or ARNs.
         * </p>
         * 
         * @param routingProfiles
         *        A list of up to 100 routing profile IDs or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfiles(Collection<String> routingProfiles);

        /**
         * <p>
         * A list of up to 100 routing profile IDs or ARNs.
         * </p>
         * 
         * @param routingProfiles
         *        A list of up to 100 routing profile IDs or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfiles(String... routingProfiles);

        /**
         * <p>
         * A list of expressions as a filter, in which an expression is an object of a step in a routing criteria.
         * </p>
         * 
         * @param routingStepExpressions
         *        A list of expressions as a filter, in which an expression is an object of a step in a routing
         *        criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingStepExpressions(Collection<String> routingStepExpressions);

        /**
         * <p>
         * A list of expressions as a filter, in which an expression is an object of a step in a routing criteria.
         * </p>
         * 
         * @param routingStepExpressions
         *        A list of expressions as a filter, in which an expression is an object of a step in a routing
         *        criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingStepExpressions(String... routingStepExpressions);

        /**
         * <p>
         * A list of up to 50 agent status IDs or ARNs.
         * </p>
         * 
         * @param agentStatuses
         *        A list of up to 50 agent status IDs or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatuses(Collection<String> agentStatuses);

        /**
         * <p>
         * A list of up to 50 agent status IDs or ARNs.
         * </p>
         * 
         * @param agentStatuses
         *        A list of up to 50 agent status IDs or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatuses(String... agentStatuses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();

        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private List<String> routingProfiles = DefaultSdkAutoConstructList.getInstance();

        private List<String> routingStepExpressions = DefaultSdkAutoConstructList.getInstance();

        private List<String> agentStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            queues(model.queues);
            channelsWithStrings(model.channels);
            routingProfiles(model.routingProfiles);
            routingStepExpressions(model.routingStepExpressions);
            agentStatuses(model.agentStatuses);
        }

        public final Collection<String> getQueues() {
            if (queues instanceof SdkAutoConstructList) {
                return null;
            }
            return queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String... queues) {
            queues(Arrays.asList(queues));
            return this;
        }

        public final Collection<String> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String... channels) {
            channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        public final Collection<String> getRoutingProfiles() {
            if (routingProfiles instanceof SdkAutoConstructList) {
                return null;
            }
            return routingProfiles;
        }

        public final void setRoutingProfiles(Collection<String> routingProfiles) {
            this.routingProfiles = RoutingProfilesCopier.copy(routingProfiles);
        }

        @Override
        public final Builder routingProfiles(Collection<String> routingProfiles) {
            this.routingProfiles = RoutingProfilesCopier.copy(routingProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfiles(String... routingProfiles) {
            routingProfiles(Arrays.asList(routingProfiles));
            return this;
        }

        public final Collection<String> getRoutingStepExpressions() {
            if (routingStepExpressions instanceof SdkAutoConstructList) {
                return null;
            }
            return routingStepExpressions;
        }

        public final void setRoutingStepExpressions(Collection<String> routingStepExpressions) {
            this.routingStepExpressions = RoutingExpressionsCopier.copy(routingStepExpressions);
        }

        @Override
        public final Builder routingStepExpressions(Collection<String> routingStepExpressions) {
            this.routingStepExpressions = RoutingExpressionsCopier.copy(routingStepExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingStepExpressions(String... routingStepExpressions) {
            routingStepExpressions(Arrays.asList(routingStepExpressions));
            return this;
        }

        public final Collection<String> getAgentStatuses() {
            if (agentStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return agentStatuses;
        }

        public final void setAgentStatuses(Collection<String> agentStatuses) {
            this.agentStatuses = AgentStatusesCopier.copy(agentStatuses);
        }

        @Override
        public final Builder agentStatuses(Collection<String> agentStatuses) {
            this.agentStatuses = AgentStatusesCopier.copy(agentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatuses(String... agentStatuses) {
            agentStatuses(Arrays.asList(agentStatuses));
            return this;
        }

        @Override
        public Filters build() {
            return new Filters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
