/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the levels in the hierarchy group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchyPathReference implements SdkPojo, Serializable,
        ToCopyableBuilder<HierarchyPathReference.Builder, HierarchyPathReference> {
    private static final SdkField<HierarchyGroupSummaryReference> LEVEL_ONE_FIELD = SdkField
            .<HierarchyGroupSummaryReference> builder(MarshallingType.SDK_POJO).memberName("LevelOne")
            .getter(getter(HierarchyPathReference::levelOne)).setter(setter(Builder::levelOne))
            .constructor(HierarchyGroupSummaryReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelOne").build()).build();

    private static final SdkField<HierarchyGroupSummaryReference> LEVEL_TWO_FIELD = SdkField
            .<HierarchyGroupSummaryReference> builder(MarshallingType.SDK_POJO).memberName("LevelTwo")
            .getter(getter(HierarchyPathReference::levelTwo)).setter(setter(Builder::levelTwo))
            .constructor(HierarchyGroupSummaryReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelTwo").build()).build();

    private static final SdkField<HierarchyGroupSummaryReference> LEVEL_THREE_FIELD = SdkField
            .<HierarchyGroupSummaryReference> builder(MarshallingType.SDK_POJO).memberName("LevelThree")
            .getter(getter(HierarchyPathReference::levelThree)).setter(setter(Builder::levelThree))
            .constructor(HierarchyGroupSummaryReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelThree").build()).build();

    private static final SdkField<HierarchyGroupSummaryReference> LEVEL_FOUR_FIELD = SdkField
            .<HierarchyGroupSummaryReference> builder(MarshallingType.SDK_POJO).memberName("LevelFour")
            .getter(getter(HierarchyPathReference::levelFour)).setter(setter(Builder::levelFour))
            .constructor(HierarchyGroupSummaryReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelFour").build()).build();

    private static final SdkField<HierarchyGroupSummaryReference> LEVEL_FIVE_FIELD = SdkField
            .<HierarchyGroupSummaryReference> builder(MarshallingType.SDK_POJO).memberName("LevelFive")
            .getter(getter(HierarchyPathReference::levelFive)).setter(setter(Builder::levelFive))
            .constructor(HierarchyGroupSummaryReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelFive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_ONE_FIELD,
            LEVEL_TWO_FIELD, LEVEL_THREE_FIELD, LEVEL_FOUR_FIELD, LEVEL_FIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HierarchyGroupSummaryReference levelOne;

    private final HierarchyGroupSummaryReference levelTwo;

    private final HierarchyGroupSummaryReference levelThree;

    private final HierarchyGroupSummaryReference levelFour;

    private final HierarchyGroupSummaryReference levelFive;

    private HierarchyPathReference(BuilderImpl builder) {
        this.levelOne = builder.levelOne;
        this.levelTwo = builder.levelTwo;
        this.levelThree = builder.levelThree;
        this.levelFour = builder.levelFour;
        this.levelFive = builder.levelFive;
    }

    /**
     * <p>
     * Information about level one.
     * </p>
     * 
     * @return Information about level one.
     */
    public final HierarchyGroupSummaryReference levelOne() {
        return levelOne;
    }

    /**
     * <p>
     * Information about level two.
     * </p>
     * 
     * @return Information about level two.
     */
    public final HierarchyGroupSummaryReference levelTwo() {
        return levelTwo;
    }

    /**
     * <p>
     * Information about level three.
     * </p>
     * 
     * @return Information about level three.
     */
    public final HierarchyGroupSummaryReference levelThree() {
        return levelThree;
    }

    /**
     * <p>
     * Information about level four.
     * </p>
     * 
     * @return Information about level four.
     */
    public final HierarchyGroupSummaryReference levelFour() {
        return levelFour;
    }

    /**
     * <p>
     * Information about level five.
     * </p>
     * 
     * @return Information about level five.
     */
    public final HierarchyGroupSummaryReference levelFive() {
        return levelFive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(levelOne());
        hashCode = 31 * hashCode + Objects.hashCode(levelTwo());
        hashCode = 31 * hashCode + Objects.hashCode(levelThree());
        hashCode = 31 * hashCode + Objects.hashCode(levelFour());
        hashCode = 31 * hashCode + Objects.hashCode(levelFive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyPathReference)) {
            return false;
        }
        HierarchyPathReference other = (HierarchyPathReference) obj;
        return Objects.equals(levelOne(), other.levelOne()) && Objects.equals(levelTwo(), other.levelTwo())
                && Objects.equals(levelThree(), other.levelThree()) && Objects.equals(levelFour(), other.levelFour())
                && Objects.equals(levelFive(), other.levelFive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HierarchyPathReference").add("LevelOne", levelOne()).add("LevelTwo", levelTwo())
                .add("LevelThree", levelThree()).add("LevelFour", levelFour()).add("LevelFive", levelFive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LevelOne":
            return Optional.ofNullable(clazz.cast(levelOne()));
        case "LevelTwo":
            return Optional.ofNullable(clazz.cast(levelTwo()));
        case "LevelThree":
            return Optional.ofNullable(clazz.cast(levelThree()));
        case "LevelFour":
            return Optional.ofNullable(clazz.cast(levelFour()));
        case "LevelFive":
            return Optional.ofNullable(clazz.cast(levelFive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LevelOne", LEVEL_ONE_FIELD);
        map.put("LevelTwo", LEVEL_TWO_FIELD);
        map.put("LevelThree", LEVEL_THREE_FIELD);
        map.put("LevelFour", LEVEL_FOUR_FIELD);
        map.put("LevelFive", LEVEL_FIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HierarchyPathReference, T> g) {
        return obj -> g.apply((HierarchyPathReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchyPathReference> {
        /**
         * <p>
         * Information about level one.
         * </p>
         * 
         * @param levelOne
         *        Information about level one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelOne(HierarchyGroupSummaryReference levelOne);

        /**
         * <p>
         * Information about level one.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyGroupSummaryReference.Builder}
         * avoiding the need to create one manually via {@link HierarchyGroupSummaryReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyGroupSummaryReference.Builder#build()} is called
         * immediately and its result is passed to {@link #levelOne(HierarchyGroupSummaryReference)}.
         * 
         * @param levelOne
         *        a consumer that will call methods on {@link HierarchyGroupSummaryReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelOne(HierarchyGroupSummaryReference)
         */
        default Builder levelOne(Consumer<HierarchyGroupSummaryReference.Builder> levelOne) {
            return levelOne(HierarchyGroupSummaryReference.builder().applyMutation(levelOne).build());
        }

        /**
         * <p>
         * Information about level two.
         * </p>
         * 
         * @param levelTwo
         *        Information about level two.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelTwo(HierarchyGroupSummaryReference levelTwo);

        /**
         * <p>
         * Information about level two.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyGroupSummaryReference.Builder}
         * avoiding the need to create one manually via {@link HierarchyGroupSummaryReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyGroupSummaryReference.Builder#build()} is called
         * immediately and its result is passed to {@link #levelTwo(HierarchyGroupSummaryReference)}.
         * 
         * @param levelTwo
         *        a consumer that will call methods on {@link HierarchyGroupSummaryReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelTwo(HierarchyGroupSummaryReference)
         */
        default Builder levelTwo(Consumer<HierarchyGroupSummaryReference.Builder> levelTwo) {
            return levelTwo(HierarchyGroupSummaryReference.builder().applyMutation(levelTwo).build());
        }

        /**
         * <p>
         * Information about level three.
         * </p>
         * 
         * @param levelThree
         *        Information about level three.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelThree(HierarchyGroupSummaryReference levelThree);

        /**
         * <p>
         * Information about level three.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyGroupSummaryReference.Builder}
         * avoiding the need to create one manually via {@link HierarchyGroupSummaryReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyGroupSummaryReference.Builder#build()} is called
         * immediately and its result is passed to {@link #levelThree(HierarchyGroupSummaryReference)}.
         * 
         * @param levelThree
         *        a consumer that will call methods on {@link HierarchyGroupSummaryReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelThree(HierarchyGroupSummaryReference)
         */
        default Builder levelThree(Consumer<HierarchyGroupSummaryReference.Builder> levelThree) {
            return levelThree(HierarchyGroupSummaryReference.builder().applyMutation(levelThree).build());
        }

        /**
         * <p>
         * Information about level four.
         * </p>
         * 
         * @param levelFour
         *        Information about level four.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelFour(HierarchyGroupSummaryReference levelFour);

        /**
         * <p>
         * Information about level four.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyGroupSummaryReference.Builder}
         * avoiding the need to create one manually via {@link HierarchyGroupSummaryReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyGroupSummaryReference.Builder#build()} is called
         * immediately and its result is passed to {@link #levelFour(HierarchyGroupSummaryReference)}.
         * 
         * @param levelFour
         *        a consumer that will call methods on {@link HierarchyGroupSummaryReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelFour(HierarchyGroupSummaryReference)
         */
        default Builder levelFour(Consumer<HierarchyGroupSummaryReference.Builder> levelFour) {
            return levelFour(HierarchyGroupSummaryReference.builder().applyMutation(levelFour).build());
        }

        /**
         * <p>
         * Information about level five.
         * </p>
         * 
         * @param levelFive
         *        Information about level five.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelFive(HierarchyGroupSummaryReference levelFive);

        /**
         * <p>
         * Information about level five.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyGroupSummaryReference.Builder}
         * avoiding the need to create one manually via {@link HierarchyGroupSummaryReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyGroupSummaryReference.Builder#build()} is called
         * immediately and its result is passed to {@link #levelFive(HierarchyGroupSummaryReference)}.
         * 
         * @param levelFive
         *        a consumer that will call methods on {@link HierarchyGroupSummaryReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelFive(HierarchyGroupSummaryReference)
         */
        default Builder levelFive(Consumer<HierarchyGroupSummaryReference.Builder> levelFive) {
            return levelFive(HierarchyGroupSummaryReference.builder().applyMutation(levelFive).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HierarchyGroupSummaryReference levelOne;

        private HierarchyGroupSummaryReference levelTwo;

        private HierarchyGroupSummaryReference levelThree;

        private HierarchyGroupSummaryReference levelFour;

        private HierarchyGroupSummaryReference levelFive;

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchyPathReference model) {
            levelOne(model.levelOne);
            levelTwo(model.levelTwo);
            levelThree(model.levelThree);
            levelFour(model.levelFour);
            levelFive(model.levelFive);
        }

        public final HierarchyGroupSummaryReference.Builder getLevelOne() {
            return levelOne != null ? levelOne.toBuilder() : null;
        }

        public final void setLevelOne(HierarchyGroupSummaryReference.BuilderImpl levelOne) {
            this.levelOne = levelOne != null ? levelOne.build() : null;
        }

        @Override
        public final Builder levelOne(HierarchyGroupSummaryReference levelOne) {
            this.levelOne = levelOne;
            return this;
        }

        public final HierarchyGroupSummaryReference.Builder getLevelTwo() {
            return levelTwo != null ? levelTwo.toBuilder() : null;
        }

        public final void setLevelTwo(HierarchyGroupSummaryReference.BuilderImpl levelTwo) {
            this.levelTwo = levelTwo != null ? levelTwo.build() : null;
        }

        @Override
        public final Builder levelTwo(HierarchyGroupSummaryReference levelTwo) {
            this.levelTwo = levelTwo;
            return this;
        }

        public final HierarchyGroupSummaryReference.Builder getLevelThree() {
            return levelThree != null ? levelThree.toBuilder() : null;
        }

        public final void setLevelThree(HierarchyGroupSummaryReference.BuilderImpl levelThree) {
            this.levelThree = levelThree != null ? levelThree.build() : null;
        }

        @Override
        public final Builder levelThree(HierarchyGroupSummaryReference levelThree) {
            this.levelThree = levelThree;
            return this;
        }

        public final HierarchyGroupSummaryReference.Builder getLevelFour() {
            return levelFour != null ? levelFour.toBuilder() : null;
        }

        public final void setLevelFour(HierarchyGroupSummaryReference.BuilderImpl levelFour) {
            this.levelFour = levelFour != null ? levelFour.build() : null;
        }

        @Override
        public final Builder levelFour(HierarchyGroupSummaryReference levelFour) {
            this.levelFour = levelFour;
            return this;
        }

        public final HierarchyGroupSummaryReference.Builder getLevelFive() {
            return levelFive != null ? levelFive.toBuilder() : null;
        }

        public final void setLevelFive(HierarchyGroupSummaryReference.BuilderImpl levelFive) {
            this.levelFive = levelFive != null ? levelFive.build() : null;
        }

        @Override
        public final Builder levelFive(HierarchyGroupSummaryReference levelFive) {
            this.levelFive = levelFive;
            return this;
        }

        @Override
        public HierarchyPathReference build() {
            return new HierarchyPathReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
