/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQuickConnectsRequest extends ConnectRequest implements
        ToCopyableBuilder<ListQuickConnectsRequest.Builder, ListQuickConnectsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ListQuickConnectsRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQuickConnectsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListQuickConnectsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> QUICK_CONNECT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QuickConnectTypes")
            .getter(getter(ListQuickConnectsRequest::quickConnectTypesAsStrings))
            .setter(setter(Builder::quickConnectTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("QuickConnectTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, QUICK_CONNECT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> quickConnectTypes;

    private ListQuickConnectsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.quickConnectTypes = builder.quickConnectTypes;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance. Both Instance ID and Instance ARN are supported input formats.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance. Both Instance ID and Instance ARN are supported
     *         input formats.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page. The default MaxResult size is 100.
     * </p>
     * 
     * @return The maximum number of results to return per page. The default MaxResult size is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are prompted
     * to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuickConnectTypes} method.
     * </p>
     * 
     * @return The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are
     *         prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     */
    public final List<QuickConnectType> quickConnectTypes() {
        return QuickConnectTypesCopier.copyStringToEnum(quickConnectTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the QuickConnectTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQuickConnectTypes() {
        return quickConnectTypes != null && !(quickConnectTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are prompted
     * to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuickConnectTypes} method.
     * </p>
     * 
     * @return The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are
     *         prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
     */
    public final List<String> quickConnectTypesAsStrings() {
        return quickConnectTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuickConnectTypes() ? quickConnectTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQuickConnectsRequest)) {
            return false;
        }
        ListQuickConnectsRequest other = (ListQuickConnectsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && hasQuickConnectTypes() == other.hasQuickConnectTypes()
                && Objects.equals(quickConnectTypesAsStrings(), other.quickConnectTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQuickConnectsRequest").add("InstanceId", instanceId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults())
                .add("QuickConnectTypes", hasQuickConnectTypes() ? quickConnectTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "QuickConnectTypes":
            return Optional.ofNullable(clazz.cast(quickConnectTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("QuickConnectTypes", QUICK_CONNECT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQuickConnectsRequest, T> g) {
        return obj -> g.apply((ListQuickConnectsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListQuickConnectsRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance. Both Instance ID and Instance ARN are supported input
         * formats.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance. Both Instance ID and Instance ARN are
         *        supported input formats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page. The default MaxResult size is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page. The default MaxResult size is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are
         * prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
         * </p>
         * 
         * @param quickConnectTypes
         *        The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you
         *        are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue
         *        (QUEUE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectTypesWithStrings(Collection<String> quickConnectTypes);

        /**
         * <p>
         * The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are
         * prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
         * </p>
         * 
         * @param quickConnectTypes
         *        The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you
         *        are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue
         *        (QUEUE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectTypesWithStrings(String... quickConnectTypes);

        /**
         * <p>
         * The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are
         * prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
         * </p>
         * 
         * @param quickConnectTypes
         *        The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you
         *        are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue
         *        (QUEUE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectTypes(Collection<QuickConnectType> quickConnectTypes);

        /**
         * <p>
         * The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are
         * prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
         * </p>
         * 
         * @param quickConnectTypes
         *        The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you
         *        are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue
         *        (QUEUE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectTypes(QuickConnectType... quickConnectTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String nextToken;

        private Integer maxResults;

        private List<String> quickConnectTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQuickConnectsRequest model) {
            super(model);
            instanceId(model.instanceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            quickConnectTypesWithStrings(model.quickConnectTypes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getQuickConnectTypes() {
            if (quickConnectTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return quickConnectTypes;
        }

        public final void setQuickConnectTypes(Collection<String> quickConnectTypes) {
            this.quickConnectTypes = QuickConnectTypesCopier.copy(quickConnectTypes);
        }

        @Override
        public final Builder quickConnectTypesWithStrings(Collection<String> quickConnectTypes) {
            this.quickConnectTypes = QuickConnectTypesCopier.copy(quickConnectTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectTypesWithStrings(String... quickConnectTypes) {
            quickConnectTypesWithStrings(Arrays.asList(quickConnectTypes));
            return this;
        }

        @Override
        public final Builder quickConnectTypes(Collection<QuickConnectType> quickConnectTypes) {
            this.quickConnectTypes = QuickConnectTypesCopier.copyEnumToString(quickConnectTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectTypes(QuickConnectType... quickConnectTypes) {
            quickConnectTypes(Arrays.asList(quickConnectTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQuickConnectsRequest build() {
            return new ListQuickConnectsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
