/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about email body content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutboundEmailContent implements SdkPojo, Serializable,
        ToCopyableBuilder<OutboundEmailContent.Builder, OutboundEmailContent> {
    private static final SdkField<String> MESSAGE_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageSourceType").getter(getter(OutboundEmailContent::messageSourceTypeAsString))
            .setter(setter(Builder::messageSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSourceType").build()).build();

    private static final SdkField<TemplatedMessageConfig> TEMPLATED_MESSAGE_CONFIG_FIELD = SdkField
            .<TemplatedMessageConfig> builder(MarshallingType.SDK_POJO).memberName("TemplatedMessageConfig")
            .getter(getter(OutboundEmailContent::templatedMessageConfig)).setter(setter(Builder::templatedMessageConfig))
            .constructor(TemplatedMessageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatedMessageConfig").build())
            .build();

    private static final SdkField<OutboundRawMessage> RAW_MESSAGE_FIELD = SdkField
            .<OutboundRawMessage> builder(MarshallingType.SDK_POJO).memberName("RawMessage")
            .getter(getter(OutboundEmailContent::rawMessage)).setter(setter(Builder::rawMessage))
            .constructor(OutboundRawMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_SOURCE_TYPE_FIELD,
            TEMPLATED_MESSAGE_CONFIG_FIELD, RAW_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageSourceType;

    private final TemplatedMessageConfig templatedMessageConfig;

    private final OutboundRawMessage rawMessage;

    private OutboundEmailContent(BuilderImpl builder) {
        this.messageSourceType = builder.messageSourceType;
        this.templatedMessageConfig = builder.templatedMessageConfig;
        this.rawMessage = builder.rawMessage;
    }

    /**
     * <p>
     * The message source type, that is, <code>RAW</code> or <code>TEMPLATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageSourceType}
     * will return {@link OutboundMessageSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #messageSourceTypeAsString}.
     * </p>
     * 
     * @return The message source type, that is, <code>RAW</code> or <code>TEMPLATE</code>.
     * @see OutboundMessageSourceType
     */
    public final OutboundMessageSourceType messageSourceType() {
        return OutboundMessageSourceType.fromValue(messageSourceType);
    }

    /**
     * <p>
     * The message source type, that is, <code>RAW</code> or <code>TEMPLATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageSourceType}
     * will return {@link OutboundMessageSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #messageSourceTypeAsString}.
     * </p>
     * 
     * @return The message source type, that is, <code>RAW</code> or <code>TEMPLATE</code>.
     * @see OutboundMessageSourceType
     */
    public final String messageSourceTypeAsString() {
        return messageSourceType;
    }

    /**
     * <p>
     * Information about template message configuration.
     * </p>
     * 
     * @return Information about template message configuration.
     */
    public final TemplatedMessageConfig templatedMessageConfig() {
        return templatedMessageConfig;
    }

    /**
     * <p>
     * The raw email body content.
     * </p>
     * 
     * @return The raw email body content.
     */
    public final OutboundRawMessage rawMessage() {
        return rawMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templatedMessageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(rawMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundEmailContent)) {
            return false;
        }
        OutboundEmailContent other = (OutboundEmailContent) obj;
        return Objects.equals(messageSourceTypeAsString(), other.messageSourceTypeAsString())
                && Objects.equals(templatedMessageConfig(), other.templatedMessageConfig())
                && Objects.equals(rawMessage(), other.rawMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutboundEmailContent").add("MessageSourceType", messageSourceTypeAsString())
                .add("TemplatedMessageConfig", templatedMessageConfig()).add("RawMessage", rawMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageSourceType":
            return Optional.ofNullable(clazz.cast(messageSourceTypeAsString()));
        case "TemplatedMessageConfig":
            return Optional.ofNullable(clazz.cast(templatedMessageConfig()));
        case "RawMessage":
            return Optional.ofNullable(clazz.cast(rawMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MessageSourceType", MESSAGE_SOURCE_TYPE_FIELD);
        map.put("TemplatedMessageConfig", TEMPLATED_MESSAGE_CONFIG_FIELD);
        map.put("RawMessage", RAW_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundEmailContent, T> g) {
        return obj -> g.apply((OutboundEmailContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutboundEmailContent> {
        /**
         * <p>
         * The message source type, that is, <code>RAW</code> or <code>TEMPLATE</code>.
         * </p>
         * 
         * @param messageSourceType
         *        The message source type, that is, <code>RAW</code> or <code>TEMPLATE</code>.
         * @see OutboundMessageSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutboundMessageSourceType
         */
        Builder messageSourceType(String messageSourceType);

        /**
         * <p>
         * The message source type, that is, <code>RAW</code> or <code>TEMPLATE</code>.
         * </p>
         * 
         * @param messageSourceType
         *        The message source type, that is, <code>RAW</code> or <code>TEMPLATE</code>.
         * @see OutboundMessageSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutboundMessageSourceType
         */
        Builder messageSourceType(OutboundMessageSourceType messageSourceType);

        /**
         * <p>
         * Information about template message configuration.
         * </p>
         * 
         * @param templatedMessageConfig
         *        Information about template message configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatedMessageConfig(TemplatedMessageConfig templatedMessageConfig);

        /**
         * <p>
         * Information about template message configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplatedMessageConfig.Builder} avoiding
         * the need to create one manually via {@link TemplatedMessageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplatedMessageConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #templatedMessageConfig(TemplatedMessageConfig)}.
         * 
         * @param templatedMessageConfig
         *        a consumer that will call methods on {@link TemplatedMessageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templatedMessageConfig(TemplatedMessageConfig)
         */
        default Builder templatedMessageConfig(Consumer<TemplatedMessageConfig.Builder> templatedMessageConfig) {
            return templatedMessageConfig(TemplatedMessageConfig.builder().applyMutation(templatedMessageConfig).build());
        }

        /**
         * <p>
         * The raw email body content.
         * </p>
         * 
         * @param rawMessage
         *        The raw email body content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawMessage(OutboundRawMessage rawMessage);

        /**
         * <p>
         * The raw email body content.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundRawMessage.Builder} avoiding the
         * need to create one manually via {@link OutboundRawMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundRawMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #rawMessage(OutboundRawMessage)}.
         * 
         * @param rawMessage
         *        a consumer that will call methods on {@link OutboundRawMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rawMessage(OutboundRawMessage)
         */
        default Builder rawMessage(Consumer<OutboundRawMessage.Builder> rawMessage) {
            return rawMessage(OutboundRawMessage.builder().applyMutation(rawMessage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String messageSourceType;

        private TemplatedMessageConfig templatedMessageConfig;

        private OutboundRawMessage rawMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundEmailContent model) {
            messageSourceType(model.messageSourceType);
            templatedMessageConfig(model.templatedMessageConfig);
            rawMessage(model.rawMessage);
        }

        public final String getMessageSourceType() {
            return messageSourceType;
        }

        public final void setMessageSourceType(String messageSourceType) {
            this.messageSourceType = messageSourceType;
        }

        @Override
        public final Builder messageSourceType(String messageSourceType) {
            this.messageSourceType = messageSourceType;
            return this;
        }

        @Override
        public final Builder messageSourceType(OutboundMessageSourceType messageSourceType) {
            this.messageSourceType(messageSourceType == null ? null : messageSourceType.toString());
            return this;
        }

        public final TemplatedMessageConfig.Builder getTemplatedMessageConfig() {
            return templatedMessageConfig != null ? templatedMessageConfig.toBuilder() : null;
        }

        public final void setTemplatedMessageConfig(TemplatedMessageConfig.BuilderImpl templatedMessageConfig) {
            this.templatedMessageConfig = templatedMessageConfig != null ? templatedMessageConfig.build() : null;
        }

        @Override
        public final Builder templatedMessageConfig(TemplatedMessageConfig templatedMessageConfig) {
            this.templatedMessageConfig = templatedMessageConfig;
            return this;
        }

        public final OutboundRawMessage.Builder getRawMessage() {
            return rawMessage != null ? rawMessage.toBuilder() : null;
        }

        public final void setRawMessage(OutboundRawMessage.BuilderImpl rawMessage) {
            this.rawMessage = rawMessage != null ? rawMessage.build() : null;
        }

        @Override
        public final Builder rawMessage(OutboundRawMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        @Override
        public OutboundEmailContent build() {
            return new OutboundEmailContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
