/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The config of the outbound strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutboundStrategyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OutboundStrategyConfig.Builder, OutboundStrategyConfig> {
    private static final SdkField<AgentFirst> AGENT_FIRST_FIELD = SdkField.<AgentFirst> builder(MarshallingType.SDK_POJO)
            .memberName("AgentFirst").getter(getter(OutboundStrategyConfig::agentFirst)).setter(setter(Builder::agentFirst))
            .constructor(AgentFirst::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentFirst").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_FIRST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AgentFirst agentFirst;

    private OutboundStrategyConfig(BuilderImpl builder) {
        this.agentFirst = builder.agentFirst;
    }

    /**
     * <p>
     * The config of agent first outbound strategy.
     * </p>
     * 
     * @return The config of agent first outbound strategy.
     */
    public final AgentFirst agentFirst() {
        return agentFirst;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentFirst());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundStrategyConfig)) {
            return false;
        }
        OutboundStrategyConfig other = (OutboundStrategyConfig) obj;
        return Objects.equals(agentFirst(), other.agentFirst());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutboundStrategyConfig").add("AgentFirst", agentFirst()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentFirst":
            return Optional.ofNullable(clazz.cast(agentFirst()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AgentFirst", AGENT_FIRST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundStrategyConfig, T> g) {
        return obj -> g.apply((OutboundStrategyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutboundStrategyConfig> {
        /**
         * <p>
         * The config of agent first outbound strategy.
         * </p>
         * 
         * @param agentFirst
         *        The config of agent first outbound strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentFirst(AgentFirst agentFirst);

        /**
         * <p>
         * The config of agent first outbound strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentFirst.Builder} avoiding the need to
         * create one manually via {@link AgentFirst#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentFirst.Builder#build()} is called immediately and its result
         * is passed to {@link #agentFirst(AgentFirst)}.
         * 
         * @param agentFirst
         *        a consumer that will call methods on {@link AgentFirst.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentFirst(AgentFirst)
         */
        default Builder agentFirst(Consumer<AgentFirst.Builder> agentFirst) {
            return agentFirst(AgentFirst.builder().applyMutation(agentFirst).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AgentFirst agentFirst;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundStrategyConfig model) {
            agentFirst(model.agentFirst);
        }

        public final AgentFirst.Builder getAgentFirst() {
            return agentFirst != null ? agentFirst.toBuilder() : null;
        }

        public final void setAgentFirst(AgentFirst.BuilderImpl agentFirst) {
            this.agentFirst = agentFirst != null ? agentFirst.build() : null;
        }

        @Override
        public final Builder agentFirst(AgentFirst agentFirst) {
            this.agentFirst = agentFirst;
            return this;
        }

        @Override
        public OutboundStrategyConfig build() {
            return new OutboundStrategyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
