/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a predefined attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredefinedAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<PredefinedAttribute.Builder, PredefinedAttribute> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PredefinedAttribute::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PredefinedAttributeValues> VALUES_FIELD = SdkField
            .<PredefinedAttributeValues> builder(MarshallingType.SDK_POJO).memberName("Values")
            .getter(getter(PredefinedAttribute::values)).setter(setter(Builder::values))
            .constructor(PredefinedAttributeValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build()).build();

    private static final SdkField<List<String>> PURPOSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Purposes")
            .getter(getter(PredefinedAttribute::purposes))
            .setter(setter(Builder::purposes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Purposes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PredefinedAttributeConfiguration> ATTRIBUTE_CONFIGURATION_FIELD = SdkField
            .<PredefinedAttributeConfiguration> builder(MarshallingType.SDK_POJO).memberName("AttributeConfiguration")
            .getter(getter(PredefinedAttribute::attributeConfiguration)).setter(setter(Builder::attributeConfiguration))
            .constructor(PredefinedAttributeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeConfiguration").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(PredefinedAttribute::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(PredefinedAttribute::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD,
            PURPOSES_FIELD, ATTRIBUTE_CONFIGURATION_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final PredefinedAttributeValues values;

    private final List<String> purposes;

    private final PredefinedAttributeConfiguration attributeConfiguration;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private PredefinedAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.purposes = builder.purposes;
        this.attributeConfiguration = builder.attributeConfiguration;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * The name of the predefined attribute.
     * </p>
     * 
     * @return The name of the predefined attribute.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The values of the predefined attribute.
     * </p>
     * 
     * @return The values of the predefined attribute.
     */
    public final PredefinedAttributeValues values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the Purposes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPurposes() {
        return purposes != null && !(purposes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Values that enable you to categorize your predefined attributes. You can use them in custom UI elements across
     * the Amazon Connect admin website.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPurposes} method.
     * </p>
     * 
     * @return Values that enable you to categorize your predefined attributes. You can use them in custom UI elements
     *         across the Amazon Connect admin website.
     */
    public final List<String> purposes() {
        return purposes;
    }

    /**
     * <p>
     * Custom metadata that is associated to predefined attributes to control behavior in upstream services, such as
     * controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
     * </p>
     * 
     * @return Custom metadata that is associated to predefined attributes to control behavior in upstream services,
     *         such as controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
     */
    public final PredefinedAttributeConfiguration attributeConfiguration() {
        return attributeConfiguration;
    }

    /**
     * <p>
     * Last modified time.
     * </p>
     * 
     * @return Last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Last modified region.
     * </p>
     * 
     * @return Last modified region.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(hasPurposes() ? purposes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedAttribute)) {
            return false;
        }
        PredefinedAttribute other = (PredefinedAttribute) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(values(), other.values())
                && hasPurposes() == other.hasPurposes() && Objects.equals(purposes(), other.purposes())
                && Objects.equals(attributeConfiguration(), other.attributeConfiguration())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredefinedAttribute").add("Name", name()).add("Values", values())
                .add("Purposes", hasPurposes() ? purposes() : null).add("AttributeConfiguration", attributeConfiguration())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Purposes":
            return Optional.ofNullable(clazz.cast(purposes()));
        case "AttributeConfiguration":
            return Optional.ofNullable(clazz.cast(attributeConfiguration()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("Purposes", PURPOSES_FIELD);
        map.put("AttributeConfiguration", ATTRIBUTE_CONFIGURATION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredefinedAttribute, T> g) {
        return obj -> g.apply((PredefinedAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredefinedAttribute> {
        /**
         * <p>
         * The name of the predefined attribute.
         * </p>
         * 
         * @param name
         *        The name of the predefined attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The values of the predefined attribute.
         * </p>
         * 
         * @param values
         *        The values of the predefined attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(PredefinedAttributeValues values);

        /**
         * <p>
         * The values of the predefined attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredefinedAttributeValues.Builder}
         * avoiding the need to create one manually via {@link PredefinedAttributeValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredefinedAttributeValues.Builder#build()} is called immediately
         * and its result is passed to {@link #values(PredefinedAttributeValues)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link PredefinedAttributeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(PredefinedAttributeValues)
         */
        default Builder values(Consumer<PredefinedAttributeValues.Builder> values) {
            return values(PredefinedAttributeValues.builder().applyMutation(values).build());
        }

        /**
         * <p>
         * Values that enable you to categorize your predefined attributes. You can use them in custom UI elements
         * across the Amazon Connect admin website.
         * </p>
         * 
         * @param purposes
         *        Values that enable you to categorize your predefined attributes. You can use them in custom UI
         *        elements across the Amazon Connect admin website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purposes(Collection<String> purposes);

        /**
         * <p>
         * Values that enable you to categorize your predefined attributes. You can use them in custom UI elements
         * across the Amazon Connect admin website.
         * </p>
         * 
         * @param purposes
         *        Values that enable you to categorize your predefined attributes. You can use them in custom UI
         *        elements across the Amazon Connect admin website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purposes(String... purposes);

        /**
         * <p>
         * Custom metadata that is associated to predefined attributes to control behavior in upstream services, such as
         * controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
         * </p>
         * 
         * @param attributeConfiguration
         *        Custom metadata that is associated to predefined attributes to control behavior in upstream services,
         *        such as controlling how a predefined attribute should be displayed in the Amazon Connect admin
         *        website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeConfiguration(PredefinedAttributeConfiguration attributeConfiguration);

        /**
         * <p>
         * Custom metadata that is associated to predefined attributes to control behavior in upstream services, such as
         * controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredefinedAttributeConfiguration.Builder}
         * avoiding the need to create one manually via {@link PredefinedAttributeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredefinedAttributeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeConfiguration(PredefinedAttributeConfiguration)}.
         * 
         * @param attributeConfiguration
         *        a consumer that will call methods on {@link PredefinedAttributeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeConfiguration(PredefinedAttributeConfiguration)
         */
        default Builder attributeConfiguration(Consumer<PredefinedAttributeConfiguration.Builder> attributeConfiguration) {
            return attributeConfiguration(PredefinedAttributeConfiguration.builder().applyMutation(attributeConfiguration)
                    .build());
        }

        /**
         * <p>
         * Last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        Last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Last modified region.
         * </p>
         * 
         * @param lastModifiedRegion
         *        Last modified region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private PredefinedAttributeValues values;

        private List<String> purposes = DefaultSdkAutoConstructList.getInstance();

        private PredefinedAttributeConfiguration attributeConfiguration;

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedAttribute model) {
            name(model.name);
            values(model.values);
            purposes(model.purposes);
            attributeConfiguration(model.attributeConfiguration);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PredefinedAttributeValues.Builder getValues() {
            return values != null ? values.toBuilder() : null;
        }

        public final void setValues(PredefinedAttributeValues.BuilderImpl values) {
            this.values = values != null ? values.build() : null;
        }

        @Override
        public final Builder values(PredefinedAttributeValues values) {
            this.values = values;
            return this;
        }

        public final Collection<String> getPurposes() {
            if (purposes instanceof SdkAutoConstructList) {
                return null;
            }
            return purposes;
        }

        public final void setPurposes(Collection<String> purposes) {
            this.purposes = PredefinedAttributePurposeNameListCopier.copy(purposes);
        }

        @Override
        public final Builder purposes(Collection<String> purposes) {
            this.purposes = PredefinedAttributePurposeNameListCopier.copy(purposes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purposes(String... purposes) {
            purposes(Arrays.asList(purposes));
            return this;
        }

        public final PredefinedAttributeConfiguration.Builder getAttributeConfiguration() {
            return attributeConfiguration != null ? attributeConfiguration.toBuilder() : null;
        }

        public final void setAttributeConfiguration(PredefinedAttributeConfiguration.BuilderImpl attributeConfiguration) {
            this.attributeConfiguration = attributeConfiguration != null ? attributeConfiguration.build() : null;
        }

        @Override
        public final Builder attributeConfiguration(PredefinedAttributeConfiguration attributeConfiguration) {
            this.attributeConfiguration = attributeConfiguration;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public PredefinedAttribute build() {
            return new PredefinedAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
