/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom metadata that is associated to predefined attributes to control behavior in upstream services, such as
 * controlling how a predefined attribute should be displayed in the Amazon Connect admin website.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredefinedAttributeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PredefinedAttributeConfiguration.Builder, PredefinedAttributeConfiguration> {
    private static final SdkField<Boolean> ENABLE_VALUE_VALIDATION_ON_ASSOCIATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableValueValidationOnAssociation")
            .getter(getter(PredefinedAttributeConfiguration::enableValueValidationOnAssociation))
            .setter(setter(Builder::enableValueValidationOnAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableValueValidationOnAssociation")
                    .build()).build();

    private static final SdkField<Boolean> IS_READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsReadOnly").getter(getter(PredefinedAttributeConfiguration::isReadOnly))
            .setter(setter(Builder::isReadOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsReadOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_VALUE_VALIDATION_ON_ASSOCIATION_FIELD, IS_READ_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableValueValidationOnAssociation;

    private final Boolean isReadOnly;

    private PredefinedAttributeConfiguration(BuilderImpl builder) {
        this.enableValueValidationOnAssociation = builder.enableValueValidationOnAssociation;
        this.isReadOnly = builder.isReadOnly;
    }

    /**
     * <p>
     * When this parameter is set to true, Amazon Connect enforces strict validation on the specific values, if the
     * values are predefined in attributes. The contact will store only valid and predefined values for teh predefined
     * attribute key.
     * </p>
     * 
     * @return When this parameter is set to true, Amazon Connect enforces strict validation on the specific values, if
     *         the values are predefined in attributes. The contact will store only valid and predefined values for teh
     *         predefined attribute key.
     */
    public final Boolean enableValueValidationOnAssociation() {
        return enableValueValidationOnAssociation;
    }

    /**
     * <p>
     * A boolean flag used to indicate whether a predefined attribute should be displayed in the Amazon Connect admin
     * website.
     * </p>
     * 
     * @return A boolean flag used to indicate whether a predefined attribute should be displayed in the Amazon Connect
     *         admin website.
     */
    public final Boolean isReadOnly() {
        return isReadOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableValueValidationOnAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(isReadOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedAttributeConfiguration)) {
            return false;
        }
        PredefinedAttributeConfiguration other = (PredefinedAttributeConfiguration) obj;
        return Objects.equals(enableValueValidationOnAssociation(), other.enableValueValidationOnAssociation())
                && Objects.equals(isReadOnly(), other.isReadOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredefinedAttributeConfiguration")
                .add("EnableValueValidationOnAssociation", enableValueValidationOnAssociation()).add("IsReadOnly", isReadOnly())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableValueValidationOnAssociation":
            return Optional.ofNullable(clazz.cast(enableValueValidationOnAssociation()));
        case "IsReadOnly":
            return Optional.ofNullable(clazz.cast(isReadOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableValueValidationOnAssociation", ENABLE_VALUE_VALIDATION_ON_ASSOCIATION_FIELD);
        map.put("IsReadOnly", IS_READ_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredefinedAttributeConfiguration, T> g) {
        return obj -> g.apply((PredefinedAttributeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredefinedAttributeConfiguration> {
        /**
         * <p>
         * When this parameter is set to true, Amazon Connect enforces strict validation on the specific values, if the
         * values are predefined in attributes. The contact will store only valid and predefined values for teh
         * predefined attribute key.
         * </p>
         * 
         * @param enableValueValidationOnAssociation
         *        When this parameter is set to true, Amazon Connect enforces strict validation on the specific values,
         *        if the values are predefined in attributes. The contact will store only valid and predefined values
         *        for teh predefined attribute key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableValueValidationOnAssociation(Boolean enableValueValidationOnAssociation);

        /**
         * <p>
         * A boolean flag used to indicate whether a predefined attribute should be displayed in the Amazon Connect
         * admin website.
         * </p>
         * 
         * @param isReadOnly
         *        A boolean flag used to indicate whether a predefined attribute should be displayed in the Amazon
         *        Connect admin website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isReadOnly(Boolean isReadOnly);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableValueValidationOnAssociation;

        private Boolean isReadOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedAttributeConfiguration model) {
            enableValueValidationOnAssociation(model.enableValueValidationOnAssociation);
            isReadOnly(model.isReadOnly);
        }

        public final Boolean getEnableValueValidationOnAssociation() {
            return enableValueValidationOnAssociation;
        }

        public final void setEnableValueValidationOnAssociation(Boolean enableValueValidationOnAssociation) {
            this.enableValueValidationOnAssociation = enableValueValidationOnAssociation;
        }

        @Override
        public final Builder enableValueValidationOnAssociation(Boolean enableValueValidationOnAssociation) {
            this.enableValueValidationOnAssociation = enableValueValidationOnAssociation;
            return this;
        }

        public final Boolean getIsReadOnly() {
            return isReadOnly;
        }

        public final void setIsReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        @Override
        public final Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            return this;
        }

        @Override
        public PredefinedAttributeConfiguration build() {
            return new PredefinedAttributeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
