/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a routing profile manual assignment queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingProfileManualAssignmentQueueConfigSummary
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RoutingProfileManualAssignmentQueueConfigSummary.Builder, RoutingProfileManualAssignmentQueueConfigSummary> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueId").getter(getter(RoutingProfileManualAssignmentQueueConfigSummary::queueId))
            .setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()).build();

    private static final SdkField<String> QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueArn").getter(getter(RoutingProfileManualAssignmentQueueConfigSummary::queueArn))
            .setter(setter(Builder::queueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueArn").build()).build();

    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueName").getter(getter(RoutingProfileManualAssignmentQueueConfigSummary::queueName))
            .setter(setter(Builder::queueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueName").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(RoutingProfileManualAssignmentQueueConfigSummary::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD,
            QUEUE_ARN_FIELD, QUEUE_NAME_FIELD, CHANNEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queueId;

    private final String queueArn;

    private final String queueName;

    private final String channel;

    private RoutingProfileManualAssignmentQueueConfigSummary(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.queueArn = builder.queueArn;
        this.queueName = builder.queueName;
        this.channel = builder.channel;
    }

    /**
     * <p>
     * The identifier for the queue.
     * </p>
     * 
     * @return The identifier for the queue.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the queue.
     */
    public final String queueArn() {
        return queueArn;
    }

    /**
     * <p>
     * The name of the queue.
     * </p>
     * 
     * @return The name of the queue.
     */
    public final String queueName() {
        return queueName;
    }

    /**
     * <p>
     * The channels this queue supports. Valid Values: CHAT | TASK | EMAIL
     * </p>
     * <important>
     * <p>
     * VOICE is not supported. The information shown below is incorrect. We're working to correct it.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channels this queue supports. Valid Values: CHAT | TASK | EMAIL </p> <important>
     *         <p>
     *         VOICE is not supported. The information shown below is incorrect. We're working to correct it.
     *         </p>
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * The channels this queue supports. Valid Values: CHAT | TASK | EMAIL
     * </p>
     * <important>
     * <p>
     * VOICE is not supported. The information shown below is incorrect. We're working to correct it.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channels this queue supports. Valid Values: CHAT | TASK | EMAIL </p> <important>
     *         <p>
     *         VOICE is not supported. The information shown below is incorrect. We're working to correct it.
     *         </p>
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(queueArn());
        hashCode = 31 * hashCode + Objects.hashCode(queueName());
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfileManualAssignmentQueueConfigSummary)) {
            return false;
        }
        RoutingProfileManualAssignmentQueueConfigSummary other = (RoutingProfileManualAssignmentQueueConfigSummary) obj;
        return Objects.equals(queueId(), other.queueId()) && Objects.equals(queueArn(), other.queueArn())
                && Objects.equals(queueName(), other.queueName()) && Objects.equals(channelAsString(), other.channelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingProfileManualAssignmentQueueConfigSummary").add("QueueId", queueId())
                .add("QueueArn", queueArn()).add("QueueName", queueName()).add("Channel", channelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "QueueArn":
            return Optional.ofNullable(clazz.cast(queueArn()));
        case "QueueName":
            return Optional.ofNullable(clazz.cast(queueName()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("QueueArn", QUEUE_ARN_FIELD);
        map.put("QueueName", QUEUE_NAME_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfileManualAssignmentQueueConfigSummary, T> g) {
        return obj -> g.apply((RoutingProfileManualAssignmentQueueConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingProfileManualAssignmentQueueConfigSummary> {
        /**
         * <p>
         * The identifier for the queue.
         * </p>
         * 
         * @param queueId
         *        The identifier for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the queue.
         * </p>
         * 
         * @param queueArn
         *        The Amazon Resource Name (ARN) of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueArn(String queueArn);

        /**
         * <p>
         * The name of the queue.
         * </p>
         * 
         * @param queueName
         *        The name of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueName(String queueName);

        /**
         * <p>
         * The channels this queue supports. Valid Values: CHAT | TASK | EMAIL
         * </p>
         * <important>
         * <p>
         * VOICE is not supported. The information shown below is incorrect. We're working to correct it.
         * </p>
         * </important>
         * 
         * @param channel
         *        The channels this queue supports. Valid Values: CHAT | TASK | EMAIL </p> <important>
         *        <p>
         *        VOICE is not supported. The information shown below is incorrect. We're working to correct it.
         *        </p>
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channels this queue supports. Valid Values: CHAT | TASK | EMAIL
         * </p>
         * <important>
         * <p>
         * VOICE is not supported. The information shown below is incorrect. We're working to correct it.
         * </p>
         * </important>
         * 
         * @param channel
         *        The channels this queue supports. Valid Values: CHAT | TASK | EMAIL </p> <important>
         *        <p>
         *        VOICE is not supported. The information shown below is incorrect. We're working to correct it.
         *        </p>
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);
    }

    static final class BuilderImpl implements Builder {
        private String queueId;

        private String queueArn;

        private String queueName;

        private String channel;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfileManualAssignmentQueueConfigSummary model) {
            queueId(model.queueId);
            queueArn(model.queueArn);
            queueName(model.queueName);
            channel(model.channel);
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getQueueArn() {
            return queueArn;
        }

        public final void setQueueArn(String queueArn) {
            this.queueArn = queueArn;
        }

        @Override
        public final Builder queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        public final String getQueueName() {
            return queueName;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        @Override
        public RoutingProfileManualAssignmentQueueConfigSummary build() {
            return new RoutingProfileManualAssignmentQueueConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
