/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a routing profile queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingProfileQueueConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingProfileQueueConfigSummary.Builder, RoutingProfileQueueConfigSummary> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueId").getter(getter(RoutingProfileQueueConfigSummary::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()).build();

    private static final SdkField<String> QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueArn").getter(getter(RoutingProfileQueueConfigSummary::queueArn)).setter(setter(Builder::queueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueArn").build()).build();

    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueName").getter(getter(RoutingProfileQueueConfigSummary::queueName))
            .setter(setter(Builder::queueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueName").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(RoutingProfileQueueConfigSummary::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<Integer> DELAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Delay")
            .getter(getter(RoutingProfileQueueConfigSummary::delay)).setter(setter(Builder::delay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delay").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(RoutingProfileQueueConfigSummary::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD,
            QUEUE_ARN_FIELD, QUEUE_NAME_FIELD, PRIORITY_FIELD, DELAY_FIELD, CHANNEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queueId;

    private final String queueArn;

    private final String queueName;

    private final Integer priority;

    private final Integer delay;

    private final String channel;

    private RoutingProfileQueueConfigSummary(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.queueArn = builder.queueArn;
        this.queueName = builder.queueName;
        this.priority = builder.priority;
        this.delay = builder.delay;
        this.channel = builder.channel;
    }

    /**
     * <p>
     * The identifier for the queue.
     * </p>
     * 
     * @return The identifier for the queue.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the queue.
     */
    public final String queueArn() {
        return queueArn;
    }

    /**
     * <p>
     * The name of the queue.
     * </p>
     * 
     * @return The name of the queue.
     */
    public final String queueName() {
        return queueName;
    }

    /**
     * <p>
     * The order in which contacts are to be handled for the queue. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues:
     * priority and delay</a>.
     * </p>
     * 
     * @return The order in which contacts are to be handled for the queue. For more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html"
     *         >Queues: priority and delay</a>.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The delay, in seconds, that a contact should be in the queue before they are routed to an available agent. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues:
     * priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return The delay, in seconds, that a contact should be in the queue before they are routed to an available
     *         agent. For more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html"
     *         >Queues: priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final Integer delay() {
        return delay;
    }

    /**
     * <p>
     * The channels this queue supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channels this queue supports.
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * The channels this queue supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channels this queue supports.
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(queueArn());
        hashCode = 31 * hashCode + Objects.hashCode(queueName());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(delay());
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfileQueueConfigSummary)) {
            return false;
        }
        RoutingProfileQueueConfigSummary other = (RoutingProfileQueueConfigSummary) obj;
        return Objects.equals(queueId(), other.queueId()) && Objects.equals(queueArn(), other.queueArn())
                && Objects.equals(queueName(), other.queueName()) && Objects.equals(priority(), other.priority())
                && Objects.equals(delay(), other.delay()) && Objects.equals(channelAsString(), other.channelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingProfileQueueConfigSummary").add("QueueId", queueId()).add("QueueArn", queueArn())
                .add("QueueName", queueName()).add("Priority", priority()).add("Delay", delay())
                .add("Channel", channelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "QueueArn":
            return Optional.ofNullable(clazz.cast(queueArn()));
        case "QueueName":
            return Optional.ofNullable(clazz.cast(queueName()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Delay":
            return Optional.ofNullable(clazz.cast(delay()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("QueueArn", QUEUE_ARN_FIELD);
        map.put("QueueName", QUEUE_NAME_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Delay", DELAY_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfileQueueConfigSummary, T> g) {
        return obj -> g.apply((RoutingProfileQueueConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingProfileQueueConfigSummary> {
        /**
         * <p>
         * The identifier for the queue.
         * </p>
         * 
         * @param queueId
         *        The identifier for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the queue.
         * </p>
         * 
         * @param queueArn
         *        The Amazon Resource Name (ARN) of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueArn(String queueArn);

        /**
         * <p>
         * The name of the queue.
         * </p>
         * 
         * @param queueName
         *        The name of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueName(String queueName);

        /**
         * <p>
         * The order in which contacts are to be handled for the queue. For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues:
         * priority and delay</a>.
         * </p>
         * 
         * @param priority
         *        The order in which contacts are to be handled for the queue. For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html"
         *        >Queues: priority and delay</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The delay, in seconds, that a contact should be in the queue before they are routed to an available agent.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues:
         * priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param delay
         *        The delay, in seconds, that a contact should be in the queue before they are routed to an available
         *        agent. For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html"
         *        >Queues: priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delay(Integer delay);

        /**
         * <p>
         * The channels this queue supports.
         * </p>
         * 
         * @param channel
         *        The channels this queue supports.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channels this queue supports.
         * </p>
         * 
         * @param channel
         *        The channels this queue supports.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);
    }

    static final class BuilderImpl implements Builder {
        private String queueId;

        private String queueArn;

        private String queueName;

        private Integer priority;

        private Integer delay;

        private String channel;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfileQueueConfigSummary model) {
            queueId(model.queueId);
            queueArn(model.queueArn);
            queueName(model.queueName);
            priority(model.priority);
            delay(model.delay);
            channel(model.channel);
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getQueueArn() {
            return queueArn;
        }

        public final void setQueueArn(String queueArn) {
            this.queueArn = queueArn;
        }

        @Override
        public final Builder queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        public final String getQueueName() {
            return queueName;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Integer getDelay() {
            return delay;
        }

        public final void setDelay(Integer delay) {
            this.delay = delay;
        }

        @Override
        public final Builder delay(Integer delay) {
            this.delay = delay;
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        @Override
        public RoutingProfileQueueConfigSummary build() {
            return new RoutingProfileQueueConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
