/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchQueuesRequest extends ConnectRequest implements
        ToCopyableBuilder<SearchQueuesRequest.Builder, SearchQueuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SearchQueuesRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchQueuesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchQueuesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<QueueSearchFilter> SEARCH_FILTER_FIELD = SdkField
            .<QueueSearchFilter> builder(MarshallingType.SDK_POJO).memberName("SearchFilter")
            .getter(getter(SearchQueuesRequest::searchFilter)).setter(setter(Builder::searchFilter))
            .constructor(QueueSearchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchFilter").build()).build();

    private static final SdkField<QueueSearchCriteria> SEARCH_CRITERIA_FIELD = SdkField
            .<QueueSearchCriteria> builder(MarshallingType.SDK_POJO).memberName("SearchCriteria")
            .getter(getter(SearchQueuesRequest::searchCriteria)).setter(setter(Builder::searchCriteria))
            .constructor(QueueSearchCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SEARCH_FILTER_FIELD, SEARCH_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String nextToken;

    private final Integer maxResults;

    private final QueueSearchFilter searchFilter;

    private final QueueSearchCriteria searchCriteria;

    private SearchQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.searchFilter = builder.searchFilter;
        this.searchCriteria = builder.searchCriteria;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters to be applied to search results.
     * </p>
     * 
     * @return Filters to be applied to search results.
     */
    public final QueueSearchFilter searchFilter() {
        return searchFilter;
    }

    /**
     * <p>
     * The search criteria to be used to return queues.
     * </p>
     * <note>
     * <p>
     * The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2
     * characters and a maximum of 25 characters. Any queries with character lengths outside of this range will throw
     * invalid results.
     * </p>
     * </note>
     * 
     * @return The search criteria to be used to return queues.</p> <note>
     *         <p>
     *         The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2
     *         characters and a maximum of 25 characters. Any queries with character lengths outside of this range will
     *         throw invalid results.
     *         </p>
     */
    public final QueueSearchCriteria searchCriteria() {
        return searchCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(searchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(searchCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchQueuesRequest)) {
            return false;
        }
        SearchQueuesRequest other = (SearchQueuesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(searchFilter(), other.searchFilter())
                && Objects.equals(searchCriteria(), other.searchCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchQueuesRequest").add("InstanceId", instanceId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SearchFilter", searchFilter()).add("SearchCriteria", searchCriteria())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SearchFilter":
            return Optional.ofNullable(clazz.cast(searchFilter()));
        case "SearchCriteria":
            return Optional.ofNullable(clazz.cast(searchCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("SearchFilter", SEARCH_FILTER_FIELD);
        map.put("SearchCriteria", SEARCH_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchQueuesRequest, T> g) {
        return obj -> g.apply((SearchQueuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchQueuesRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters to be applied to search results.
         * </p>
         * 
         * @param searchFilter
         *        Filters to be applied to search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchFilter(QueueSearchFilter searchFilter);

        /**
         * <p>
         * Filters to be applied to search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueueSearchFilter.Builder} avoiding the
         * need to create one manually via {@link QueueSearchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueueSearchFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #searchFilter(QueueSearchFilter)}.
         * 
         * @param searchFilter
         *        a consumer that will call methods on {@link QueueSearchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchFilter(QueueSearchFilter)
         */
        default Builder searchFilter(Consumer<QueueSearchFilter.Builder> searchFilter) {
            return searchFilter(QueueSearchFilter.builder().applyMutation(searchFilter).build());
        }

        /**
         * <p>
         * The search criteria to be used to return queues.
         * </p>
         * <note>
         * <p>
         * The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2
         * characters and a maximum of 25 characters. Any queries with character lengths outside of this range will
         * throw invalid results.
         * </p>
         * </note>
         * 
         * @param searchCriteria
         *        The search criteria to be used to return queues.</p> <note>
         *        <p>
         *        The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of
         *        2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range
         *        will throw invalid results.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCriteria(QueueSearchCriteria searchCriteria);

        /**
         * <p>
         * The search criteria to be used to return queues.
         * </p>
         * <note>
         * <p>
         * The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2
         * characters and a maximum of 25 characters. Any queries with character lengths outside of this range will
         * throw invalid results.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link QueueSearchCriteria.Builder}
         * avoiding the need to create one manually via {@link QueueSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueueSearchCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #searchCriteria(QueueSearchCriteria)}.
         * 
         * @param searchCriteria
         *        a consumer that will call methods on {@link QueueSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchCriteria(QueueSearchCriteria)
         */
        default Builder searchCriteria(Consumer<QueueSearchCriteria.Builder> searchCriteria) {
            return searchCriteria(QueueSearchCriteria.builder().applyMutation(searchCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String nextToken;

        private Integer maxResults;

        private QueueSearchFilter searchFilter;

        private QueueSearchCriteria searchCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchQueuesRequest model) {
            super(model);
            instanceId(model.instanceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            searchFilter(model.searchFilter);
            searchCriteria(model.searchCriteria);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final QueueSearchFilter.Builder getSearchFilter() {
            return searchFilter != null ? searchFilter.toBuilder() : null;
        }

        public final void setSearchFilter(QueueSearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        @Override
        public final Builder searchFilter(QueueSearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        public final QueueSearchCriteria.Builder getSearchCriteria() {
            return searchCriteria != null ? searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(QueueSearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(QueueSearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchQueuesRequest build() {
            return new SearchQueuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
