/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a security profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityProfile implements SdkPojo, Serializable, ToCopyableBuilder<SecurityProfile.Builder, SecurityProfile> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SecurityProfile::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ORGANIZATION_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationResourceId").getter(getter(SecurityProfile::organizationResourceId))
            .setter(setter(Builder::organizationResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationResourceId").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(SecurityProfile::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityProfileName").getter(getter(SecurityProfile::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SecurityProfile::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(SecurityProfile::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ALLOWED_ACCESS_CONTROL_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AllowedAccessControlTags")
            .getter(getter(SecurityProfile::allowedAccessControlTags))
            .setter(setter(Builder::allowedAccessControlTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAccessControlTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> TAG_RESTRICTED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagRestrictedResources")
            .getter(getter(SecurityProfile::tagRestrictedResources))
            .setter(setter(Builder::tagRestrictedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagRestrictedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(SecurityProfile::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(SecurityProfile::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final SdkField<List<String>> HIERARCHY_RESTRICTED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HierarchyRestrictedResources")
            .getter(getter(SecurityProfile::hierarchyRestrictedResources))
            .setter(setter(Builder::hierarchyRestrictedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyRestrictedResources")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllowedAccessControlHierarchyGroupId")
            .getter(getter(SecurityProfile::allowedAccessControlHierarchyGroupId))
            .setter(setter(Builder::allowedAccessControlHierarchyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AllowedAccessControlHierarchyGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            ORGANIZATION_RESOURCE_ID_FIELD, ARN_FIELD, SECURITY_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD,
            ALLOWED_ACCESS_CONTROL_TAGS_FIELD, TAG_RESTRICTED_RESOURCES_FIELD, LAST_MODIFIED_TIME_FIELD,
            LAST_MODIFIED_REGION_FIELD, HIERARCHY_RESTRICTED_RESOURCES_FIELD, ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String organizationResourceId;

    private final String arn;

    private final String securityProfileName;

    private final String description;

    private final Map<String, String> tags;

    private final Map<String, String> allowedAccessControlTags;

    private final List<String> tagRestrictedResources;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private final List<String> hierarchyRestrictedResources;

    private final String allowedAccessControlHierarchyGroupId;

    private SecurityProfile(BuilderImpl builder) {
        this.id = builder.id;
        this.organizationResourceId = builder.organizationResourceId;
        this.arn = builder.arn;
        this.securityProfileName = builder.securityProfileName;
        this.description = builder.description;
        this.tags = builder.tags;
        this.allowedAccessControlTags = builder.allowedAccessControlTags;
        this.tagRestrictedResources = builder.tagRestrictedResources;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.hierarchyRestrictedResources = builder.hierarchyRestrictedResources;
        this.allowedAccessControlHierarchyGroupId = builder.allowedAccessControlHierarchyGroupId;
    }

    /**
     * <p>
     * The identifier for the security profile.
     * </p>
     * 
     * @return The identifier for the security profile.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The organization resource identifier for the security profile.
     * </p>
     * 
     * @return The organization resource identifier for the security profile.
     */
    public final String organizationResourceId() {
        return organizationResourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the security profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the security profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name for the security profile.
     * </p>
     * 
     * @return The name for the security profile.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The description of the security profile.
     * </p>
     * 
     * @return The description of the security profile.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAccessControlTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedAccessControlTags() {
        return allowedAccessControlTags != null && !(allowedAccessControlTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAccessControlTags} method.
     * </p>
     * 
     * @return The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     */
    public final Map<String, String> allowedAccessControlTags() {
        return allowedAccessControlTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagRestrictedResources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTagRestrictedResources() {
        return tagRestrictedResources != null && !(tagRestrictedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagRestrictedResources} method.
     * </p>
     * 
     * @return The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     */
    public final List<String> tagRestrictedResources() {
        return tagRestrictedResources;
    }

    /**
     * <p>
     * The timestamp when this resource was last modified.
     * </p>
     * 
     * @return The timestamp when this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Web Services Region where this resource was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where this resource was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the HierarchyRestrictedResources property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHierarchyRestrictedResources() {
        return hierarchyRestrictedResources != null && !(hierarchyRestrictedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are
     * acceptable ResourceNames: <code>User</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHierarchyRestrictedResources} method.
     * </p>
     * 
     * @return The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
     *         Following are acceptable ResourceNames: <code>User</code>.
     */
    public final List<String> hierarchyRestrictedResources() {
        return hierarchyRestrictedResources;
    }

    /**
     * <p>
     * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon
     * Connect.
     * </p>
     * 
     * @return The identifier of the hierarchy group that a security profile uses to restrict access to resources in
     *         Amazon Connect.
     */
    public final String allowedAccessControlHierarchyGroupId() {
        return allowedAccessControlHierarchyGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(organizationResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAccessControlTags() ? allowedAccessControlTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagRestrictedResources() ? tagRestrictedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasHierarchyRestrictedResources() ? hierarchyRestrictedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowedAccessControlHierarchyGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfile)) {
            return false;
        }
        SecurityProfile other = (SecurityProfile) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(organizationResourceId(), other.organizationResourceId())
                && Objects.equals(arn(), other.arn()) && Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasAllowedAccessControlTags() == other.hasAllowedAccessControlTags()
                && Objects.equals(allowedAccessControlTags(), other.allowedAccessControlTags())
                && hasTagRestrictedResources() == other.hasTagRestrictedResources()
                && Objects.equals(tagRestrictedResources(), other.tagRestrictedResources())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion())
                && hasHierarchyRestrictedResources() == other.hasHierarchyRestrictedResources()
                && Objects.equals(hierarchyRestrictedResources(), other.hierarchyRestrictedResources())
                && Objects.equals(allowedAccessControlHierarchyGroupId(), other.allowedAccessControlHierarchyGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityProfile").add("Id", id()).add("OrganizationResourceId", organizationResourceId())
                .add("Arn", arn()).add("SecurityProfileName", securityProfileName()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null)
                .add("AllowedAccessControlTags", hasAllowedAccessControlTags() ? allowedAccessControlTags() : null)
                .add("TagRestrictedResources", hasTagRestrictedResources() ? tagRestrictedResources() : null)
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion())
                .add("HierarchyRestrictedResources", hasHierarchyRestrictedResources() ? hierarchyRestrictedResources() : null)
                .add("AllowedAccessControlHierarchyGroupId", allowedAccessControlHierarchyGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OrganizationResourceId":
            return Optional.ofNullable(clazz.cast(organizationResourceId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "SecurityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AllowedAccessControlTags":
            return Optional.ofNullable(clazz.cast(allowedAccessControlTags()));
        case "TagRestrictedResources":
            return Optional.ofNullable(clazz.cast(tagRestrictedResources()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        case "HierarchyRestrictedResources":
            return Optional.ofNullable(clazz.cast(hierarchyRestrictedResources()));
        case "AllowedAccessControlHierarchyGroupId":
            return Optional.ofNullable(clazz.cast(allowedAccessControlHierarchyGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("OrganizationResourceId", ORGANIZATION_RESOURCE_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("SecurityProfileName", SECURITY_PROFILE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AllowedAccessControlTags", ALLOWED_ACCESS_CONTROL_TAGS_FIELD);
        map.put("TagRestrictedResources", TAG_RESTRICTED_RESOURCES_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("HierarchyRestrictedResources", HIERARCHY_RESTRICTED_RESOURCES_FIELD);
        map.put("AllowedAccessControlHierarchyGroupId", ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityProfile, T> g) {
        return obj -> g.apply((SecurityProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityProfile> {
        /**
         * <p>
         * The identifier for the security profile.
         * </p>
         * 
         * @param id
         *        The identifier for the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The organization resource identifier for the security profile.
         * </p>
         * 
         * @param organizationResourceId
         *        The organization resource identifier for the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationResourceId(String organizationResourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the security profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name for the security profile.
         * </p>
         * 
         * @param securityProfileName
         *        The name for the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The description of the security profile.
         * </p>
         * 
         * @param description
         *        The description of the security profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         * </p>
         * 
         * @param allowedAccessControlTags
         *        The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAccessControlTags(Map<String, String> allowedAccessControlTags);

        /**
         * <p>
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * </p>
         * 
         * @param tagRestrictedResources
         *        The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagRestrictedResources(Collection<String> tagRestrictedResources);

        /**
         * <p>
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * </p>
         * 
         * @param tagRestrictedResources
         *        The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagRestrictedResources(String... tagRestrictedResources);

        /**
         * <p>
         * The timestamp when this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Web Services Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The Amazon Web Services Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);

        /**
         * <p>
         * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following
         * are acceptable ResourceNames: <code>User</code>.
         * </p>
         * 
         * @param hierarchyRestrictedResources
         *        The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
         *        Following are acceptable ResourceNames: <code>User</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources);

        /**
         * <p>
         * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following
         * are acceptable ResourceNames: <code>User</code>.
         * </p>
         * 
         * @param hierarchyRestrictedResources
         *        The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
         *        Following are acceptable ResourceNames: <code>User</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyRestrictedResources(String... hierarchyRestrictedResources);

        /**
         * <p>
         * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon
         * Connect.
         * </p>
         * 
         * @param allowedAccessControlHierarchyGroupId
         *        The identifier of the hierarchy group that a security profile uses to restrict access to resources in
         *        Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String organizationResourceId;

        private String arn;

        private String securityProfileName;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> allowedAccessControlTags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> tagRestrictedResources = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private List<String> hierarchyRestrictedResources = DefaultSdkAutoConstructList.getInstance();

        private String allowedAccessControlHierarchyGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityProfile model) {
            id(model.id);
            organizationResourceId(model.organizationResourceId);
            arn(model.arn);
            securityProfileName(model.securityProfileName);
            description(model.description);
            tags(model.tags);
            allowedAccessControlTags(model.allowedAccessControlTags);
            tagRestrictedResources(model.tagRestrictedResources);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
            hierarchyRestrictedResources(model.hierarchyRestrictedResources);
            allowedAccessControlHierarchyGroupId(model.allowedAccessControlHierarchyGroupId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOrganizationResourceId() {
            return organizationResourceId;
        }

        public final void setOrganizationResourceId(String organizationResourceId) {
            this.organizationResourceId = organizationResourceId;
        }

        @Override
        public final Builder organizationResourceId(String organizationResourceId) {
            this.organizationResourceId = organizationResourceId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getAllowedAccessControlTags() {
            if (allowedAccessControlTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return allowedAccessControlTags;
        }

        public final void setAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
        }

        @Override
        public final Builder allowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
            return this;
        }

        public final Collection<String> getTagRestrictedResources() {
            if (tagRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return tagRestrictedResources;
        }

        public final void setTagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
        }

        @Override
        public final Builder tagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRestrictedResources(String... tagRestrictedResources) {
            tagRestrictedResources(Arrays.asList(tagRestrictedResources));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Collection<String> getHierarchyRestrictedResources() {
            if (hierarchyRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return hierarchyRestrictedResources;
        }

        public final void setHierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = HierarchyRestrictedResourceListCopier.copy(hierarchyRestrictedResources);
        }

        @Override
        public final Builder hierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = HierarchyRestrictedResourceListCopier.copy(hierarchyRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchyRestrictedResources(String... hierarchyRestrictedResources) {
            hierarchyRestrictedResources(Arrays.asList(hierarchyRestrictedResources));
            return this;
        }

        public final String getAllowedAccessControlHierarchyGroupId() {
            return allowedAccessControlHierarchyGroupId;
        }

        public final void setAllowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
        }

        @Override
        public final Builder allowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
            return this;
        }

        @Override
        public SecurityProfile build() {
            return new SecurityProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
