/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A value for a segment attribute. This is structured as a map where the key is <code>valueString</code> and the value
 * is a string.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentAttributeValue.Builder, SegmentAttributeValue> {
    private static final SdkField<String> VALUE_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueString").getter(getter(SegmentAttributeValue::valueString)).setter(setter(Builder::valueString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueString").build()).build();

    private static final SdkField<Map<String, SegmentAttributeValue>> VALUE_MAP_FIELD = SdkField
            .<Map<String, SegmentAttributeValue>> builder(MarshallingType.MAP)
            .memberName("ValueMap")
            .getter(getter(SegmentAttributeValue::valueMap))
            .setter(setter(Builder::valueMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SegmentAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> VALUE_INTEGER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValueInteger").getter(getter(SegmentAttributeValue::valueInteger)).setter(setter(Builder::valueInteger))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueInteger").build()).build();

    private static final SdkField<List<SegmentAttributeValue>> VALUE_LIST_FIELD = SdkField
            .<List<SegmentAttributeValue>> builder(MarshallingType.LIST)
            .memberName("ValueList")
            .getter(getter(SegmentAttributeValue::valueList))
            .setter(setter(Builder::valueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VALUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueArn").getter(getter(SegmentAttributeValue::valueArn)).setter(setter(Builder::valueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_STRING_FIELD,
            VALUE_MAP_FIELD, VALUE_INTEGER_FIELD, VALUE_LIST_FIELD, VALUE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String valueString;

    private final Map<String, SegmentAttributeValue> valueMap;

    private final Integer valueInteger;

    private final List<SegmentAttributeValue> valueList;

    private final String valueArn;

    private SegmentAttributeValue(BuilderImpl builder) {
        this.valueString = builder.valueString;
        this.valueMap = builder.valueMap;
        this.valueInteger = builder.valueInteger;
        this.valueList = builder.valueList;
        this.valueArn = builder.valueArn;
    }

    /**
     * <p>
     * The value of a segment attribute.
     * </p>
     * 
     * @return The value of a segment attribute.
     */
    public final String valueString() {
        return valueString;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValueMap() {
        return valueMap != null && !(valueMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The value of a segment attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueMap} method.
     * </p>
     * 
     * @return The value of a segment attribute.
     */
    public final Map<String, SegmentAttributeValue> valueMap() {
        return valueMap;
    }

    /**
     * <p>
     * The value of a segment attribute.
     * </p>
     * 
     * @return The value of a segment attribute.
     */
    public final Integer valueInteger() {
        return valueInteger;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValueList() {
        return valueList != null && !(valueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value of a segment attribute. This is only supported for system-defined attributes, not for user-defined
     * attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueList} method.
     * </p>
     * 
     * @return The value of a segment attribute. This is only supported for system-defined attributes, not for
     *         user-defined attributes.
     */
    public final List<SegmentAttributeValue> valueList() {
        return valueList;
    }

    /**
     * <p>
     * The value of a segment attribute that has to be a valid ARN. This is only supported for system-defined
     * attributes, not for user-defined attributes.
     * </p>
     * 
     * @return The value of a segment attribute that has to be a valid ARN. This is only supported for system-defined
     *         attributes, not for user-defined attributes.
     */
    public final String valueArn() {
        return valueArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValueMap() ? valueMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(valueInteger());
        hashCode = 31 * hashCode + Objects.hashCode(hasValueList() ? valueList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(valueArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentAttributeValue)) {
            return false;
        }
        SegmentAttributeValue other = (SegmentAttributeValue) obj;
        return Objects.equals(valueString(), other.valueString()) && hasValueMap() == other.hasValueMap()
                && Objects.equals(valueMap(), other.valueMap()) && Objects.equals(valueInteger(), other.valueInteger())
                && hasValueList() == other.hasValueList() && Objects.equals(valueList(), other.valueList())
                && Objects.equals(valueArn(), other.valueArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SegmentAttributeValue").add("ValueString", valueString())
                .add("ValueMap", hasValueMap() ? valueMap() : null).add("ValueInteger", valueInteger())
                .add("ValueList", hasValueList() ? valueList() : null).add("ValueArn", valueArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValueString":
            return Optional.ofNullable(clazz.cast(valueString()));
        case "ValueMap":
            return Optional.ofNullable(clazz.cast(valueMap()));
        case "ValueInteger":
            return Optional.ofNullable(clazz.cast(valueInteger()));
        case "ValueList":
            return Optional.ofNullable(clazz.cast(valueList()));
        case "ValueArn":
            return Optional.ofNullable(clazz.cast(valueArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ValueString", VALUE_STRING_FIELD);
        map.put("ValueMap", VALUE_MAP_FIELD);
        map.put("ValueInteger", VALUE_INTEGER_FIELD);
        map.put("ValueList", VALUE_LIST_FIELD);
        map.put("ValueArn", VALUE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SegmentAttributeValue, T> g) {
        return obj -> g.apply((SegmentAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentAttributeValue> {
        /**
         * <p>
         * The value of a segment attribute.
         * </p>
         * 
         * @param valueString
         *        The value of a segment attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueString(String valueString);

        /**
         * <p>
         * The value of a segment attribute.
         * </p>
         * 
         * @param valueMap
         *        The value of a segment attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueMap(Map<String, SegmentAttributeValue> valueMap);

        /**
         * <p>
         * The value of a segment attribute.
         * </p>
         * 
         * @param valueInteger
         *        The value of a segment attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueInteger(Integer valueInteger);

        /**
         * <p>
         * The value of a segment attribute. This is only supported for system-defined attributes, not for user-defined
         * attributes.
         * </p>
         * 
         * @param valueList
         *        The value of a segment attribute. This is only supported for system-defined attributes, not for
         *        user-defined attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueList(Collection<SegmentAttributeValue> valueList);

        /**
         * <p>
         * The value of a segment attribute. This is only supported for system-defined attributes, not for user-defined
         * attributes.
         * </p>
         * 
         * @param valueList
         *        The value of a segment attribute. This is only supported for system-defined attributes, not for
         *        user-defined attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueList(SegmentAttributeValue... valueList);

        /**
         * <p>
         * The value of a segment attribute. This is only supported for system-defined attributes, not for user-defined
         * attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.SegmentAttributeValue.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.SegmentAttributeValue#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.SegmentAttributeValue.Builder#build()} is called
         * immediately and its result is passed to {@link #valueList(List<SegmentAttributeValue>)}.
         * 
         * @param valueList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.SegmentAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueList(java.util.Collection<SegmentAttributeValue>)
         */
        Builder valueList(Consumer<Builder>... valueList);

        /**
         * <p>
         * The value of a segment attribute that has to be a valid ARN. This is only supported for system-defined
         * attributes, not for user-defined attributes.
         * </p>
         * 
         * @param valueArn
         *        The value of a segment attribute that has to be a valid ARN. This is only supported for system-defined
         *        attributes, not for user-defined attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueArn(String valueArn);
    }

    static final class BuilderImpl implements Builder {
        private String valueString;

        private Map<String, SegmentAttributeValue> valueMap = DefaultSdkAutoConstructMap.getInstance();

        private Integer valueInteger;

        private List<SegmentAttributeValue> valueList = DefaultSdkAutoConstructList.getInstance();

        private String valueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentAttributeValue model) {
            valueString(model.valueString);
            valueMap(model.valueMap);
            valueInteger(model.valueInteger);
            valueList(model.valueList);
            valueArn(model.valueArn);
        }

        public final String getValueString() {
            return valueString;
        }

        public final void setValueString(String valueString) {
            this.valueString = valueString;
        }

        @Override
        public final Builder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        public final Map<String, Builder> getValueMap() {
            Map<String, Builder> result = SegmentAttributeValueMapCopier.copyToBuilder(this.valueMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setValueMap(Map<String, BuilderImpl> valueMap) {
            this.valueMap = SegmentAttributeValueMapCopier.copyFromBuilder(valueMap);
        }

        @Override
        public final Builder valueMap(Map<String, SegmentAttributeValue> valueMap) {
            this.valueMap = SegmentAttributeValueMapCopier.copy(valueMap);
            return this;
        }

        public final Integer getValueInteger() {
            return valueInteger;
        }

        public final void setValueInteger(Integer valueInteger) {
            this.valueInteger = valueInteger;
        }

        @Override
        public final Builder valueInteger(Integer valueInteger) {
            this.valueInteger = valueInteger;
            return this;
        }

        public final List<Builder> getValueList() {
            List<Builder> result = SegmentAttributeValueListCopier.copyToBuilder(this.valueList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValueList(Collection<BuilderImpl> valueList) {
            this.valueList = SegmentAttributeValueListCopier.copyFromBuilder(valueList);
        }

        @Override
        public final Builder valueList(Collection<SegmentAttributeValue> valueList) {
            this.valueList = SegmentAttributeValueListCopier.copy(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(SegmentAttributeValue... valueList) {
            valueList(Arrays.asList(valueList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(Consumer<Builder>... valueList) {
            valueList(Stream.of(valueList).map(c -> SegmentAttributeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getValueArn() {
            return valueArn;
        }

        public final void setValueArn(String valueArn) {
            this.valueArn = valueArn;
        }

        @Override
        public final Builder valueArn(String valueArn) {
            this.valueArn = valueArn;
            return this;
        }

        @Override
        public SegmentAttributeValue build() {
            return new SegmentAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
