/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartOutboundVoiceContactRequest extends ConnectRequest implements
        ToCopyableBuilder<StartOutboundVoiceContactRequest.Builder, StartOutboundVoiceContactRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartOutboundVoiceContactRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartOutboundVoiceContactRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField
            .<Map<String, Reference>> builder(MarshallingType.MAP)
            .memberName("References")
            .getter(getter(StartOutboundVoiceContactRequest::references))
            .setter(setter(Builder::references))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Reference> builder(MarshallingType.SDK_POJO)
                                            .constructor(Reference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedContactId").getter(getter(StartOutboundVoiceContactRequest::relatedContactId))
            .setter(setter(Builder::relatedContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()).build();

    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(StartOutboundVoiceContactRequest::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(StartOutboundVoiceContactRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartOutboundVoiceContactRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartOutboundVoiceContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SOURCE_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePhoneNumber").getter(getter(StartOutboundVoiceContactRequest::sourcePhoneNumber))
            .setter(setter(Builder::sourcePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePhoneNumber").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueId").getter(getter(StartOutboundVoiceContactRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(StartOutboundVoiceContactRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AnswerMachineDetectionConfig> ANSWER_MACHINE_DETECTION_CONFIG_FIELD = SdkField
            .<AnswerMachineDetectionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AnswerMachineDetectionConfig")
            .getter(getter(StartOutboundVoiceContactRequest::answerMachineDetectionConfig))
            .setter(setter(Builder::answerMachineDetectionConfig))
            .constructor(AnswerMachineDetectionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerMachineDetectionConfig")
                    .build()).build();

    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CampaignId").getter(getter(StartOutboundVoiceContactRequest::campaignId))
            .setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()).build();

    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficType").getter(getter(StartOutboundVoiceContactRequest::trafficTypeAsString))
            .setter(setter(Builder::trafficType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").build()).build();

    private static final SdkField<OutboundStrategy> OUTBOUND_STRATEGY_FIELD = SdkField
            .<OutboundStrategy> builder(MarshallingType.SDK_POJO).memberName("OutboundStrategy")
            .getter(getter(StartOutboundVoiceContactRequest::outboundStrategy)).setter(setter(Builder::outboundStrategy))
            .constructor(OutboundStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            REFERENCES_FIELD, RELATED_CONTACT_ID_FIELD, DESTINATION_PHONE_NUMBER_FIELD, CONTACT_FLOW_ID_FIELD, INSTANCE_ID_FIELD,
            CLIENT_TOKEN_FIELD, SOURCE_PHONE_NUMBER_FIELD, QUEUE_ID_FIELD, ATTRIBUTES_FIELD,
            ANSWER_MACHINE_DETECTION_CONFIG_FIELD, CAMPAIGN_ID_FIELD, TRAFFIC_TYPE_FIELD, OUTBOUND_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final Map<String, Reference> references;

    private final String relatedContactId;

    private final String destinationPhoneNumber;

    private final String contactFlowId;

    private final String instanceId;

    private final String clientToken;

    private final String sourcePhoneNumber;

    private final String queueId;

    private final Map<String, String> attributes;

    private final AnswerMachineDetectionConfig answerMachineDetectionConfig;

    private final String campaignId;

    private final String trafficType;

    private final OutboundStrategy outboundStrategy;

    private StartOutboundVoiceContactRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.references = builder.references;
        this.relatedContactId = builder.relatedContactId;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.contactFlowId = builder.contactFlowId;
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.sourcePhoneNumber = builder.sourcePhoneNumber;
        this.queueId = builder.queueId;
        this.attributes = builder.attributes;
        this.answerMachineDetectionConfig = builder.answerMachineDetectionConfig;
        this.campaignId = builder.campaignId;
        this.trafficType = builder.trafficType;
        this.outboundStrategy = builder.outboundStrategy;
    }

    /**
     * <p>
     * The name of a voice contact that is shown to an agent in the Contact Control Panel (CCP).
     * </p>
     * 
     * @return The name of a voice contact that is shown to an agent in the Contact Control Panel (CCP).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the voice contact that appears in the agent's snapshot in the CCP logs. For more information
     * about CCP logs, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/download-ccp-logs.html">Download and review CCP
     * logs</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return A description of the voice contact that appears in the agent's snapshot in the CCP logs. For more
     *         information about CCP logs, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/download-ccp-logs.html">Download and review
     *         CCP logs</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the References property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReferences() {
        return references != null && !(references instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Contacts can have the following
     * reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> |
     * <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported reference type during voice
     * contact creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferences} method.
     * </p>
     * 
     * @return A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Contacts can have the
     *         following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> |
     *         <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported
     *         reference type during voice contact creation.
     */
    public final Map<String, Reference> references() {
        return references;
    }

    /**
     * <p>
     * The <code>contactId</code> that is related to this contact. Linking voice, task, or chat by using
     * <code>RelatedContactID</code> copies over contact attributes from the related contact to the new contact. All
     * updates to user-defined attributes in the new contact are limited to the individual contact ID. There are no
     * limits to the number of contacts that can be linked by using <code>RelatedContactId</code>.
     * </p>
     * 
     * @return The <code>contactId</code> that is related to this contact. Linking voice, task, or chat by using
     *         <code>RelatedContactID</code> copies over contact attributes from the related contact to the new contact.
     *         All updates to user-defined attributes in the new contact are limited to the individual contact ID. There
     *         are no limits to the number of contacts that can be linked by using <code>RelatedContactId</code>.
     */
    public final String relatedContactId() {
        return relatedContactId;
    }

    /**
     * <p>
     * The phone number of the customer, in E.164 format.
     * </p>
     * 
     * @return The phone number of the customer, in E.164 format.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * <p>
     * The identifier of the flow for the outbound call. To see the ContactFlowId in the Amazon Connect admin website,
     * on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the flow page, under the
     * name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN,
     * shown here in bold:
     * </p>
     * <p>
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     * </p>
     * 
     * @return The identifier of the flow for the outbound call. To see the ContactFlowId in the Amazon Connect admin
     *         website, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the flow
     *         page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is
     *         the last part of the ARN, shown here in bold: </p>
     *         <p>
     *         arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     *         846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is already started, the contact
     * ID is returned.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is
     *         already started, the contact ID is returned.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source
     * phone number, you must specify a queue.
     * </p>
     * 
     * @return The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a
     *         source phone number, you must specify a queue.
     */
    public final String sourcePhoneNumber() {
        return sourcePhoneNumber;
    }

    /**
     * <p>
     * The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified
     * in the queue. If you do not specify a queue, the queue defined in the flow is used. If you do not specify a
     * queue, you must specify a source phone number.
     * </p>
     * 
     * @return The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number
     *         specified in the queue. If you do not specify a queue, the queue defined in the flow is used. If you do
     *         not specify a queue, you must specify a source phone number.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be
     * accessed in flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
     *         and can be accessed in flows just like any other contact attributes.</p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Configuration of the answering machine detection for this outbound call.
     * </p>
     * 
     * @return Configuration of the answering machine detection for this outbound call.
     */
    public final AnswerMachineDetectionConfig answerMachineDetectionConfig() {
        return answerMachineDetectionConfig;
    }

    /**
     * <p>
     * The campaign identifier of the outbound communication.
     * </p>
     * 
     * @return The campaign identifier of the outbound communication.
     */
    public final String campaignId() {
        return campaignId;
    }

    /**
     * <p>
     * Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The
     * default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is
     * set to <code>true</code>. For all other cases, use <code>GENERAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeAsString}.
     * </p>
     * 
     * @return Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon
     *         Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if
     *         <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use
     *         <code>GENERAL</code>.
     * @see TrafficType
     */
    public final TrafficType trafficType() {
        return TrafficType.fromValue(trafficType);
    }

    /**
     * <p>
     * Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The
     * default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is
     * set to <code>true</code>. For all other cases, use <code>GENERAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeAsString}.
     * </p>
     * 
     * @return Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon
     *         Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if
     *         <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use
     *         <code>GENERAL</code>.
     * @see TrafficType
     */
    public final String trafficTypeAsString() {
        return trafficType;
    }

    /**
     * <p>
     * Information about the outbound strategy.
     * </p>
     * 
     * @return Information about the outbound strategy.
     */
    public final OutboundStrategy outboundStrategy() {
        return outboundStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferences() ? references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(answerMachineDetectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outboundStrategy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOutboundVoiceContactRequest)) {
            return false;
        }
        StartOutboundVoiceContactRequest other = (StartOutboundVoiceContactRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasReferences() == other.hasReferences() && Objects.equals(references(), other.references())
                && Objects.equals(relatedContactId(), other.relatedContactId())
                && Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(contactFlowId(), other.contactFlowId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(sourcePhoneNumber(), other.sourcePhoneNumber()) && Objects.equals(queueId(), other.queueId())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(answerMachineDetectionConfig(), other.answerMachineDetectionConfig())
                && Objects.equals(campaignId(), other.campaignId())
                && Objects.equals(trafficTypeAsString(), other.trafficTypeAsString())
                && Objects.equals(outboundStrategy(), other.outboundStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartOutboundVoiceContactRequest")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("References", hasReferences() ? references() : null).add("RelatedContactId", relatedContactId())
                .add("DestinationPhoneNumber", destinationPhoneNumber()).add("ContactFlowId", contactFlowId())
                .add("InstanceId", instanceId()).add("ClientToken", clientToken()).add("SourcePhoneNumber", sourcePhoneNumber())
                .add("QueueId", queueId()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("AnswerMachineDetectionConfig", answerMachineDetectionConfig()).add("CampaignId", campaignId())
                .add("TrafficType", trafficTypeAsString()).add("OutboundStrategy", outboundStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "References":
            return Optional.ofNullable(clazz.cast(references()));
        case "RelatedContactId":
            return Optional.ofNullable(clazz.cast(relatedContactId()));
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "SourcePhoneNumber":
            return Optional.ofNullable(clazz.cast(sourcePhoneNumber()));
        case "QueueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "AnswerMachineDetectionConfig":
            return Optional.ofNullable(clazz.cast(answerMachineDetectionConfig()));
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        case "TrafficType":
            return Optional.ofNullable(clazz.cast(trafficTypeAsString()));
        case "OutboundStrategy":
            return Optional.ofNullable(clazz.cast(outboundStrategy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("SourcePhoneNumber", SOURCE_PHONE_NUMBER_FIELD);
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("AnswerMachineDetectionConfig", ANSWER_MACHINE_DETECTION_CONFIG_FIELD);
        map.put("CampaignId", CAMPAIGN_ID_FIELD);
        map.put("TrafficType", TRAFFIC_TYPE_FIELD);
        map.put("OutboundStrategy", OUTBOUND_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartOutboundVoiceContactRequest, T> g) {
        return obj -> g.apply((StartOutboundVoiceContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartOutboundVoiceContactRequest> {
        /**
         * <p>
         * The name of a voice contact that is shown to an agent in the Contact Control Panel (CCP).
         * </p>
         * 
         * @param name
         *        The name of a voice contact that is shown to an agent in the Contact Control Panel (CCP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the voice contact that appears in the agent's snapshot in the CCP logs. For more information
         * about CCP logs, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/download-ccp-logs.html">Download and review CCP
         * logs</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param description
         *        A description of the voice contact that appears in the agent's snapshot in the CCP logs. For more
         *        information about CCP logs, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/download-ccp-logs.html">Download and
         *        review CCP logs</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Contacts can have the following
         * reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> |
         * <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported reference type during
         * voice contact creation.
         * </p>
         * 
         * @param references
         *        A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Contacts can have the
         *        following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> |
         *        <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a
         *        supported reference type during voice contact creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(Map<String, Reference> references);

        /**
         * <p>
         * The <code>contactId</code> that is related to this contact. Linking voice, task, or chat by using
         * <code>RelatedContactID</code> copies over contact attributes from the related contact to the new contact. All
         * updates to user-defined attributes in the new contact are limited to the individual contact ID. There are no
         * limits to the number of contacts that can be linked by using <code>RelatedContactId</code>.
         * </p>
         * 
         * @param relatedContactId
         *        The <code>contactId</code> that is related to this contact. Linking voice, task, or chat by using
         *        <code>RelatedContactID</code> copies over contact attributes from the related contact to the new
         *        contact. All updates to user-defined attributes in the new contact are limited to the individual
         *        contact ID. There are no limits to the number of contacts that can be linked by using
         *        <code>RelatedContactId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedContactId(String relatedContactId);

        /**
         * <p>
         * The phone number of the customer, in E.164 format.
         * </p>
         * 
         * @param destinationPhoneNumber
         *        The phone number of the customer, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * <p>
         * The identifier of the flow for the outbound call. To see the ContactFlowId in the Amazon Connect admin
         * website, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the flow
         * page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the
         * last part of the ARN, shown here in bold:
         * </p>
         * <p>
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the flow for the outbound call. To see the ContactFlowId in the Amazon Connect admin
         *        website, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the
         *        flow page, under the name of the flow, choose <b>Show additional flow information</b>. The
         *        ContactFlowId is the last part of the ARN, shown here in bold: </p>
         *        <p>
         *        arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         *        846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is already started, the
         * contact ID is returned.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is
         *        already started, the contact ID is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source
         * phone number, you must specify a queue.
         * </p>
         * 
         * @param sourcePhoneNumber
         *        The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a
         *        source phone number, you must specify a queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePhoneNumber(String sourcePhoneNumber);

        /**
         * <p>
         * The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number
         * specified in the queue. If you do not specify a queue, the queue defined in the flow is used. If you do not
         * specify a queue, you must specify a source phone number.
         * </p>
         * 
         * @param queueId
         *        The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number
         *        specified in the queue. If you do not specify a queue, the queue defined in the flow is used. If you
         *        do not specify a queue, you must specify a source phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and
         * can be accessed in flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
         *        and can be accessed in flows just like any other contact attributes.</p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, dash, and underscore characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Configuration of the answering machine detection for this outbound call.
         * </p>
         * 
         * @param answerMachineDetectionConfig
         *        Configuration of the answering machine detection for this outbound call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig answerMachineDetectionConfig);

        /**
         * <p>
         * Configuration of the answering machine detection for this outbound call.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnswerMachineDetectionConfig.Builder}
         * avoiding the need to create one manually via {@link AnswerMachineDetectionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnswerMachineDetectionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #answerMachineDetectionConfig(AnswerMachineDetectionConfig)}.
         * 
         * @param answerMachineDetectionConfig
         *        a consumer that will call methods on {@link AnswerMachineDetectionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answerMachineDetectionConfig(AnswerMachineDetectionConfig)
         */
        default Builder answerMachineDetectionConfig(Consumer<AnswerMachineDetectionConfig.Builder> answerMachineDetectionConfig) {
            return answerMachineDetectionConfig(AnswerMachineDetectionConfig.builder()
                    .applyMutation(answerMachineDetectionConfig).build());
        }

        /**
         * <p>
         * The campaign identifier of the outbound communication.
         * </p>
         * 
         * @param campaignId
         *        The campaign identifier of the outbound communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        /**
         * <p>
         * Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect.
         * The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if
         * <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use
         * <code>GENERAL</code>.
         * </p>
         * 
         * @param trafficType
         *        Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon
         *        Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if
         *        <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use
         *        <code>GENERAL</code>.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(String trafficType);

        /**
         * <p>
         * Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect.
         * The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if
         * <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use
         * <code>GENERAL</code>.
         * </p>
         * 
         * @param trafficType
         *        Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon
         *        Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if
         *        <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use
         *        <code>GENERAL</code>.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(TrafficType trafficType);

        /**
         * <p>
         * Information about the outbound strategy.
         * </p>
         * 
         * @param outboundStrategy
         *        Information about the outbound strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundStrategy(OutboundStrategy outboundStrategy);

        /**
         * <p>
         * Information about the outbound strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundStrategy.Builder} avoiding the
         * need to create one manually via {@link OutboundStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #outboundStrategy(OutboundStrategy)}.
         * 
         * @param outboundStrategy
         *        a consumer that will call methods on {@link OutboundStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundStrategy(OutboundStrategy)
         */
        default Builder outboundStrategy(Consumer<OutboundStrategy.Builder> outboundStrategy) {
            return outboundStrategy(OutboundStrategy.builder().applyMutation(outboundStrategy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();

        private String relatedContactId;

        private String destinationPhoneNumber;

        private String contactFlowId;

        private String instanceId;

        private String clientToken;

        private String sourcePhoneNumber;

        private String queueId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private AnswerMachineDetectionConfig answerMachineDetectionConfig;

        private String campaignId;

        private String trafficType;

        private OutboundStrategy outboundStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(StartOutboundVoiceContactRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            references(model.references);
            relatedContactId(model.relatedContactId);
            destinationPhoneNumber(model.destinationPhoneNumber);
            contactFlowId(model.contactFlowId);
            instanceId(model.instanceId);
            clientToken(model.clientToken);
            sourcePhoneNumber(model.sourcePhoneNumber);
            queueId(model.queueId);
            attributes(model.attributes);
            answerMachineDetectionConfig(model.answerMachineDetectionConfig);
            campaignId(model.campaignId);
            trafficType(model.trafficType);
            outboundStrategy(model.outboundStrategy);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getRelatedContactId() {
            return relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourcePhoneNumber() {
            return sourcePhoneNumber;
        }

        public final void setSourcePhoneNumber(String sourcePhoneNumber) {
            this.sourcePhoneNumber = sourcePhoneNumber;
        }

        @Override
        public final Builder sourcePhoneNumber(String sourcePhoneNumber) {
            this.sourcePhoneNumber = sourcePhoneNumber;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final AnswerMachineDetectionConfig.Builder getAnswerMachineDetectionConfig() {
            return answerMachineDetectionConfig != null ? answerMachineDetectionConfig.toBuilder() : null;
        }

        public final void setAnswerMachineDetectionConfig(AnswerMachineDetectionConfig.BuilderImpl answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig != null ? answerMachineDetectionConfig.build()
                    : null;
        }

        @Override
        public final Builder answerMachineDetectionConfig(AnswerMachineDetectionConfig answerMachineDetectionConfig) {
            this.answerMachineDetectionConfig = answerMachineDetectionConfig;
            return this;
        }

        public final String getCampaignId() {
            return campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final String getTrafficType() {
            return trafficType;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        public final OutboundStrategy.Builder getOutboundStrategy() {
            return outboundStrategy != null ? outboundStrategy.toBuilder() : null;
        }

        public final void setOutboundStrategy(OutboundStrategy.BuilderImpl outboundStrategy) {
            this.outboundStrategy = outboundStrategy != null ? outboundStrategy.build() : null;
        }

        @Override
        public final Builder outboundStrategy(OutboundStrategy outboundStrategy) {
            this.outboundStrategy = outboundStrategy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOutboundVoiceContactRequest build() {
            return new StartOutboundVoiceContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
