/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes default values for fields on a template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskTemplateDefaults implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskTemplateDefaults.Builder, TaskTemplateDefaults> {
    private static final SdkField<List<TaskTemplateDefaultFieldValue>> DEFAULT_FIELD_VALUES_FIELD = SdkField
            .<List<TaskTemplateDefaultFieldValue>> builder(MarshallingType.LIST)
            .memberName("DefaultFieldValues")
            .getter(getter(TaskTemplateDefaults::defaultFieldValues))
            .setter(setter(Builder::defaultFieldValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFieldValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskTemplateDefaultFieldValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskTemplateDefaultFieldValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_FIELD_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TaskTemplateDefaultFieldValue> defaultFieldValues;

    private TaskTemplateDefaults(BuilderImpl builder) {
        this.defaultFieldValues = builder.defaultFieldValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultFieldValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultFieldValues() {
        return defaultFieldValues != null && !(defaultFieldValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Default value for the field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultFieldValues} method.
     * </p>
     * 
     * @return Default value for the field.
     */
    public final List<TaskTemplateDefaultFieldValue> defaultFieldValues() {
        return defaultFieldValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultFieldValues() ? defaultFieldValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskTemplateDefaults)) {
            return false;
        }
        TaskTemplateDefaults other = (TaskTemplateDefaults) obj;
        return hasDefaultFieldValues() == other.hasDefaultFieldValues()
                && Objects.equals(defaultFieldValues(), other.defaultFieldValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskTemplateDefaults")
                .add("DefaultFieldValues", hasDefaultFieldValues() ? defaultFieldValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultFieldValues":
            return Optional.ofNullable(clazz.cast(defaultFieldValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultFieldValues", DEFAULT_FIELD_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskTemplateDefaults, T> g) {
        return obj -> g.apply((TaskTemplateDefaults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskTemplateDefaults> {
        /**
         * <p>
         * Default value for the field.
         * </p>
         * 
         * @param defaultFieldValues
         *        Default value for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFieldValues(Collection<TaskTemplateDefaultFieldValue> defaultFieldValues);

        /**
         * <p>
         * Default value for the field.
         * </p>
         * 
         * @param defaultFieldValues
         *        Default value for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFieldValues(TaskTemplateDefaultFieldValue... defaultFieldValues);

        /**
         * <p>
         * Default value for the field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultFieldValues(List<TaskTemplateDefaultFieldValue>)}.
         * 
         * @param defaultFieldValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultFieldValues(java.util.Collection<TaskTemplateDefaultFieldValue>)
         */
        Builder defaultFieldValues(Consumer<TaskTemplateDefaultFieldValue.Builder>... defaultFieldValues);
    }

    static final class BuilderImpl implements Builder {
        private List<TaskTemplateDefaultFieldValue> defaultFieldValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskTemplateDefaults model) {
            defaultFieldValues(model.defaultFieldValues);
        }

        public final List<TaskTemplateDefaultFieldValue.Builder> getDefaultFieldValues() {
            List<TaskTemplateDefaultFieldValue.Builder> result = TaskTemplateDefaultFieldValueListCopier
                    .copyToBuilder(this.defaultFieldValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultFieldValues(Collection<TaskTemplateDefaultFieldValue.BuilderImpl> defaultFieldValues) {
            this.defaultFieldValues = TaskTemplateDefaultFieldValueListCopier.copyFromBuilder(defaultFieldValues);
        }

        @Override
        public final Builder defaultFieldValues(Collection<TaskTemplateDefaultFieldValue> defaultFieldValues) {
            this.defaultFieldValues = TaskTemplateDefaultFieldValueListCopier.copy(defaultFieldValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultFieldValues(TaskTemplateDefaultFieldValue... defaultFieldValues) {
            defaultFieldValues(Arrays.asList(defaultFieldValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultFieldValues(Consumer<TaskTemplateDefaultFieldValue.Builder>... defaultFieldValues) {
            defaultFieldValues(Stream.of(defaultFieldValues)
                    .map(c -> TaskTemplateDefaultFieldValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TaskTemplateDefaults build() {
            return new TaskTemplateDefaults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
