/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about template message configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplatedMessageConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplatedMessageConfig.Builder, TemplatedMessageConfig> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KnowledgeBaseId").getter(getter(TemplatedMessageConfig::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnowledgeBaseId").build()).build();

    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageTemplateId").getter(getter(TemplatedMessageConfig::messageTemplateId))
            .setter(setter(Builder::messageTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageTemplateId").build()).build();

    private static final SdkField<TemplateAttributes> TEMPLATE_ATTRIBUTES_FIELD = SdkField
            .<TemplateAttributes> builder(MarshallingType.SDK_POJO).memberName("TemplateAttributes")
            .getter(getter(TemplatedMessageConfig::templateAttributes)).setter(setter(Builder::templateAttributes))
            .constructor(TemplateAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            MESSAGE_TEMPLATE_ID_FIELD, TEMPLATE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String messageTemplateId;

    private final TemplateAttributes templateAttributes;

    private TemplatedMessageConfig(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.messageTemplateId = builder.messageTemplateId;
        this.templateAttributes = builder.templateAttributes;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The identifier of the message template Id.
     * </p>
     * 
     * @return The identifier of the message template Id.
     */
    public final String messageTemplateId() {
        return messageTemplateId;
    }

    /**
     * <p>
     * Information about template attributes, that is, CustomAttributes or CustomerProfileAttributes.
     * </p>
     * 
     * @return Information about template attributes, that is, CustomAttributes or CustomerProfileAttributes.
     */
    public final TemplateAttributes templateAttributes() {
        return templateAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(templateAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplatedMessageConfig)) {
            return false;
        }
        TemplatedMessageConfig other = (TemplatedMessageConfig) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(messageTemplateId(), other.messageTemplateId())
                && Objects.equals(templateAttributes(), other.templateAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplatedMessageConfig").add("KnowledgeBaseId", knowledgeBaseId())
                .add("MessageTemplateId", messageTemplateId()).add("TemplateAttributes", templateAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KnowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "MessageTemplateId":
            return Optional.ofNullable(clazz.cast(messageTemplateId()));
        case "TemplateAttributes":
            return Optional.ofNullable(clazz.cast(templateAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KnowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("MessageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("TemplateAttributes", TEMPLATE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplatedMessageConfig, T> g) {
        return obj -> g.apply((TemplatedMessageConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplatedMessageConfig> {
        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The identifier of the message template Id.
         * </p>
         * 
         * @param messageTemplateId
         *        The identifier of the message template Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateId(String messageTemplateId);

        /**
         * <p>
         * Information about template attributes, that is, CustomAttributes or CustomerProfileAttributes.
         * </p>
         * 
         * @param templateAttributes
         *        Information about template attributes, that is, CustomAttributes or CustomerProfileAttributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateAttributes(TemplateAttributes templateAttributes);

        /**
         * <p>
         * Information about template attributes, that is, CustomAttributes or CustomerProfileAttributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateAttributes.Builder} avoiding the
         * need to create one manually via {@link TemplateAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #templateAttributes(TemplateAttributes)}.
         * 
         * @param templateAttributes
         *        a consumer that will call methods on {@link TemplateAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateAttributes(TemplateAttributes)
         */
        default Builder templateAttributes(Consumer<TemplateAttributes.Builder> templateAttributes) {
            return templateAttributes(TemplateAttributes.builder().applyMutation(templateAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String messageTemplateId;

        private TemplateAttributes templateAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplatedMessageConfig model) {
            knowledgeBaseId(model.knowledgeBaseId);
            messageTemplateId(model.messageTemplateId);
            templateAttributes(model.templateAttributes);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getMessageTemplateId() {
            return messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final TemplateAttributes.Builder getTemplateAttributes() {
            return templateAttributes != null ? templateAttributes.toBuilder() : null;
        }

        public final void setTemplateAttributes(TemplateAttributes.BuilderImpl templateAttributes) {
            this.templateAttributes = templateAttributes != null ? templateAttributes.build() : null;
        }

        @Override
        public final Builder templateAttributes(TemplateAttributes templateAttributes) {
            this.templateAttributes = templateAttributes;
            return this;
        }

        @Override
        public TemplatedMessageConfig build() {
            return new TemplatedMessageConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
