/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ThresholdCollectionsCopier {
    static List<ThresholdV2> copy(Collection<? extends ThresholdV2> thresholdCollectionsParam) {
        List<ThresholdV2> list;
        if (thresholdCollectionsParam == null || thresholdCollectionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThresholdV2> modifiableList = new ArrayList<>(thresholdCollectionsParam.size());
            thresholdCollectionsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ThresholdV2> copyFromBuilder(Collection<? extends ThresholdV2.Builder> thresholdCollectionsParam) {
        List<ThresholdV2> list;
        if (thresholdCollectionsParam == null || thresholdCollectionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThresholdV2> modifiableList = new ArrayList<>(thresholdCollectionsParam.size());
            thresholdCollectionsParam.forEach(entry -> {
                ThresholdV2 member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ThresholdV2.Builder> copyToBuilder(Collection<? extends ThresholdV2> thresholdCollectionsParam) {
        List<ThresholdV2.Builder> list;
        if (thresholdCollectionsParam == null || thresholdCollectionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThresholdV2.Builder> modifiableList = new ArrayList<>(thresholdCollectionsParam.size());
            thresholdCollectionsParam.forEach(entry -> {
                ThresholdV2.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
