/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePromptResponse extends ConnectResponse implements
        ToCopyableBuilder<UpdatePromptResponse.Builder, UpdatePromptResponse> {
    private static final SdkField<String> PROMPT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PromptARN").getter(getter(UpdatePromptResponse::promptARN)).setter(setter(Builder::promptARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptARN").build()).build();

    private static final SdkField<String> PROMPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PromptId").getter(getter(UpdatePromptResponse::promptId)).setter(setter(Builder::promptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_ARN_FIELD,
            PROMPT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String promptARN;

    private final String promptId;

    private UpdatePromptResponse(BuilderImpl builder) {
        super(builder);
        this.promptARN = builder.promptARN;
        this.promptId = builder.promptId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the prompt.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the prompt.
     */
    public final String promptARN() {
        return promptARN;
    }

    /**
     * <p>
     * A unique identifier for the prompt.
     * </p>
     * 
     * @return A unique identifier for the prompt.
     */
    public final String promptId() {
        return promptId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(promptARN());
        hashCode = 31 * hashCode + Objects.hashCode(promptId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePromptResponse)) {
            return false;
        }
        UpdatePromptResponse other = (UpdatePromptResponse) obj;
        return Objects.equals(promptARN(), other.promptARN()) && Objects.equals(promptId(), other.promptId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePromptResponse").add("PromptARN", promptARN()).add("PromptId", promptId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PromptARN":
            return Optional.ofNullable(clazz.cast(promptARN()));
        case "PromptId":
            return Optional.ofNullable(clazz.cast(promptId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PromptARN", PROMPT_ARN_FIELD);
        map.put("PromptId", PROMPT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePromptResponse, T> g) {
        return obj -> g.apply((UpdatePromptResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePromptResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the prompt.
         * </p>
         * 
         * @param promptARN
         *        The Amazon Resource Name (ARN) of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptARN(String promptARN);

        /**
         * <p>
         * A unique identifier for the prompt.
         * </p>
         * 
         * @param promptId
         *        A unique identifier for the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptId(String promptId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String promptARN;

        private String promptId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePromptResponse model) {
            super(model);
            promptARN(model.promptARN);
            promptId(model.promptId);
        }

        public final String getPromptARN() {
            return promptARN;
        }

        public final void setPromptARN(String promptARN) {
            this.promptARN = promptARN;
        }

        @Override
        public final Builder promptARN(String promptARN) {
            this.promptARN = promptARN;
            return this;
        }

        public final String getPromptId() {
            return promptId;
        }

        public final void setPromptId(String promptId) {
            this.promptId = promptId;
        }

        @Override
        public final Builder promptId(String promptId) {
            this.promptId = promptId;
            return this;
        }

        @Override
        public UpdatePromptResponse build() {
            return new UpdatePromptResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
