/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementConditionOperand;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementConditionOperandListCopier;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemEnablementOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormItemEnablementCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormItemEnablementCondition> {
    private static final SdkField<List<EvaluationFormItemEnablementConditionOperand>> OPERANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operands").getter(EvaluationFormItemEnablementCondition.getter(EvaluationFormItemEnablementCondition::operands)).setter(EvaluationFormItemEnablementCondition.setter(Builder::operands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormItemEnablementConditionOperand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(EvaluationFormItemEnablementCondition.getter(EvaluationFormItemEnablementCondition::operatorAsString)).setter(EvaluationFormItemEnablementCondition.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERANDS_FIELD, OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormItemEnablementCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EvaluationFormItemEnablementConditionOperand> operands;
    private final String operator;

    private EvaluationFormItemEnablementCondition(BuilderImpl builder) {
        this.operands = builder.operands;
        this.operator = builder.operator;
    }

    public final boolean hasOperands() {
        return this.operands != null && !(this.operands instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormItemEnablementConditionOperand> operands() {
        return this.operands;
    }

    public final EvaluationFormItemEnablementOperator operator() {
        return EvaluationFormItemEnablementOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperands() ? this.operands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItemEnablementCondition)) {
            return false;
        }
        EvaluationFormItemEnablementCondition other = (EvaluationFormItemEnablementCondition)obj;
        return this.hasOperands() == other.hasOperands() && Objects.equals(this.operands(), other.operands()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormItemEnablementCondition").add("Operands", this.hasOperands() ? this.operands() : null).add("Operator", (Object)this.operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operands": {
                return Optional.ofNullable(clazz.cast(this.operands()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Operands", OPERANDS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItemEnablementCondition, T> g) {
        return obj -> g.apply((EvaluationFormItemEnablementCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EvaluationFormItemEnablementConditionOperand> operands = DefaultSdkAutoConstructList.getInstance();
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItemEnablementCondition model) {
            this.operands(model.operands);
            this.operator(model.operator);
        }

        public final List<EvaluationFormItemEnablementConditionOperand.Builder> getOperands() {
            List<EvaluationFormItemEnablementConditionOperand.Builder> result = EvaluationFormItemEnablementConditionOperandListCopier.copyToBuilder(this.operands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperands(Collection<EvaluationFormItemEnablementConditionOperand.BuilderImpl> operands) {
            this.operands = EvaluationFormItemEnablementConditionOperandListCopier.copyFromBuilder(operands);
        }

        @Override
        public final Builder operands(Collection<EvaluationFormItemEnablementConditionOperand> operands) {
            this.operands = EvaluationFormItemEnablementConditionOperandListCopier.copy(operands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operands(EvaluationFormItemEnablementConditionOperand ... operands) {
            this.operands(Arrays.asList(operands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operands(Consumer<EvaluationFormItemEnablementConditionOperand.Builder> ... operands) {
            this.operands(Stream.of(operands).map(c -> (EvaluationFormItemEnablementConditionOperand)((EvaluationFormItemEnablementConditionOperand.Builder)EvaluationFormItemEnablementConditionOperand.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(EvaluationFormItemEnablementOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public EvaluationFormItemEnablementCondition build() {
            return new EvaluationFormItemEnablementCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormItemEnablementCondition> {
        public Builder operands(Collection<EvaluationFormItemEnablementConditionOperand> var1);

        public Builder operands(EvaluationFormItemEnablementConditionOperand ... var1);

        public Builder operands(Consumer<EvaluationFormItemEnablementConditionOperand.Builder> ... var1);

        public Builder operator(String var1);

        public Builder operator(EvaluationFormItemEnablementOperator var1);
    }
}

