/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EvaluationFormQuestionAutomationAnswerSource;
import software.amazon.awssdk.services.connect.model.NumericQuestionPropertyValueAutomation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormNumericQuestionAutomation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormNumericQuestionAutomation> {
    private static final SdkField<NumericQuestionPropertyValueAutomation> PROPERTY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PropertyValue").getter(EvaluationFormNumericQuestionAutomation.getter(EvaluationFormNumericQuestionAutomation::propertyValue)).setter(EvaluationFormNumericQuestionAutomation.setter(Builder::propertyValue)).constructor(NumericQuestionPropertyValueAutomation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyValue").build()}).build();
    private static final SdkField<EvaluationFormQuestionAutomationAnswerSource> ANSWER_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnswerSource").getter(EvaluationFormNumericQuestionAutomation.getter(EvaluationFormNumericQuestionAutomation::answerSource)).setter(EvaluationFormNumericQuestionAutomation.setter(Builder::answerSource)).constructor(EvaluationFormQuestionAutomationAnswerSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_VALUE_FIELD, ANSWER_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormNumericQuestionAutomation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NumericQuestionPropertyValueAutomation propertyValue;
    private final EvaluationFormQuestionAutomationAnswerSource answerSource;
    private final Type type;

    private EvaluationFormNumericQuestionAutomation(BuilderImpl builder) {
        this.propertyValue = builder.propertyValue;
        this.answerSource = builder.answerSource;
        this.type = builder.type;
    }

    public final NumericQuestionPropertyValueAutomation propertyValue() {
        return this.propertyValue;
    }

    public final EvaluationFormQuestionAutomationAnswerSource answerSource() {
        return this.answerSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormNumericQuestionAutomation)) {
            return false;
        }
        EvaluationFormNumericQuestionAutomation other = (EvaluationFormNumericQuestionAutomation)obj;
        return Objects.equals(this.propertyValue(), other.propertyValue()) && Objects.equals(this.answerSource(), other.answerSource());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormNumericQuestionAutomation").add("PropertyValue", (Object)this.propertyValue()).add("AnswerSource", (Object)this.answerSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyValue": {
                return Optional.ofNullable(clazz.cast(this.propertyValue()));
            }
            case "AnswerSource": {
                return Optional.ofNullable(clazz.cast(this.answerSource()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationFormNumericQuestionAutomation fromPropertyValue(NumericQuestionPropertyValueAutomation propertyValue) {
        return (EvaluationFormNumericQuestionAutomation)EvaluationFormNumericQuestionAutomation.builder().propertyValue(propertyValue).build();
    }

    public static EvaluationFormNumericQuestionAutomation fromPropertyValue(Consumer<NumericQuestionPropertyValueAutomation.Builder> propertyValue) {
        NumericQuestionPropertyValueAutomation.Builder builder = NumericQuestionPropertyValueAutomation.builder();
        propertyValue.accept(builder);
        return EvaluationFormNumericQuestionAutomation.fromPropertyValue((NumericQuestionPropertyValueAutomation)builder.build());
    }

    public static EvaluationFormNumericQuestionAutomation fromAnswerSource(EvaluationFormQuestionAutomationAnswerSource answerSource) {
        return (EvaluationFormNumericQuestionAutomation)EvaluationFormNumericQuestionAutomation.builder().answerSource(answerSource).build();
    }

    public static EvaluationFormNumericQuestionAutomation fromAnswerSource(Consumer<EvaluationFormQuestionAutomationAnswerSource.Builder> answerSource) {
        EvaluationFormQuestionAutomationAnswerSource.Builder builder = EvaluationFormQuestionAutomationAnswerSource.builder();
        answerSource.accept(builder);
        return EvaluationFormNumericQuestionAutomation.fromAnswerSource((EvaluationFormQuestionAutomationAnswerSource)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PropertyValue", PROPERTY_VALUE_FIELD);
        map.put("AnswerSource", ANSWER_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormNumericQuestionAutomation, T> g) {
        return obj -> g.apply((EvaluationFormNumericQuestionAutomation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PROPERTY_VALUE,
        ANSWER_SOURCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private NumericQuestionPropertyValueAutomation propertyValue;
        private EvaluationFormQuestionAutomationAnswerSource answerSource;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormNumericQuestionAutomation model) {
            this.propertyValue(model.propertyValue);
            this.answerSource(model.answerSource);
        }

        public final NumericQuestionPropertyValueAutomation.Builder getPropertyValue() {
            return this.propertyValue != null ? this.propertyValue.toBuilder() : null;
        }

        public final void setPropertyValue(NumericQuestionPropertyValueAutomation.BuilderImpl propertyValue) {
            NumericQuestionPropertyValueAutomation oldValue = this.propertyValue;
            this.propertyValue = propertyValue != null ? propertyValue.build() : null;
            this.handleUnionValueChange(Type.PROPERTY_VALUE, oldValue, this.propertyValue);
        }

        @Override
        public final Builder propertyValue(NumericQuestionPropertyValueAutomation propertyValue) {
            NumericQuestionPropertyValueAutomation oldValue = this.propertyValue;
            this.propertyValue = propertyValue;
            this.handleUnionValueChange(Type.PROPERTY_VALUE, oldValue, this.propertyValue);
            return this;
        }

        public final EvaluationFormQuestionAutomationAnswerSource.Builder getAnswerSource() {
            return this.answerSource != null ? this.answerSource.toBuilder() : null;
        }

        public final void setAnswerSource(EvaluationFormQuestionAutomationAnswerSource.BuilderImpl answerSource) {
            EvaluationFormQuestionAutomationAnswerSource oldValue = this.answerSource;
            this.answerSource = answerSource != null ? answerSource.build() : null;
            this.handleUnionValueChange(Type.ANSWER_SOURCE, oldValue, this.answerSource);
        }

        @Override
        public final Builder answerSource(EvaluationFormQuestionAutomationAnswerSource answerSource) {
            EvaluationFormQuestionAutomationAnswerSource oldValue = this.answerSource;
            this.answerSource = answerSource;
            this.handleUnionValueChange(Type.ANSWER_SOURCE, oldValue, this.answerSource);
            return this;
        }

        public EvaluationFormNumericQuestionAutomation build() {
            return new EvaluationFormNumericQuestionAutomation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormNumericQuestionAutomation> {
        public Builder propertyValue(NumericQuestionPropertyValueAutomation var1);

        default public Builder propertyValue(Consumer<NumericQuestionPropertyValueAutomation.Builder> propertyValue) {
            return this.propertyValue((NumericQuestionPropertyValueAutomation)((NumericQuestionPropertyValueAutomation.Builder)NumericQuestionPropertyValueAutomation.builder().applyMutation(propertyValue)).build());
        }

        public Builder answerSource(EvaluationFormQuestionAutomationAnswerSource var1);

        default public Builder answerSource(Consumer<EvaluationFormQuestionAutomationAnswerSource.Builder> answerSource) {
            return this.answerSource((EvaluationFormQuestionAutomationAnswerSource)((EvaluationFormQuestionAutomationAnswerSource.Builder)EvaluationFormQuestionAutomationAnswerSource.builder().applyMutation(answerSource)).build());
        }
    }
}

