/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.AutoEvaluationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationSearchMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationSearchMetadata> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::contactId)).setter(EvaluationSearchMetadata.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluatorArn").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::evaluatorArn)).setter(EvaluationSearchMetadata.setter(Builder::evaluatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatorArn").build()}).build();
    private static final SdkField<String> CONTACT_AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactAgentId").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::contactAgentId)).setter(EvaluationSearchMetadata.setter(Builder::contactAgentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactAgentId").build()}).build();
    private static final SdkField<String> CALIBRATION_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalibrationSessionId").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::calibrationSessionId)).setter(EvaluationSearchMetadata.setter(Builder::calibrationSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalibrationSessionId").build()}).build();
    private static final SdkField<Double> SCORE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ScorePercentage").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::scorePercentage)).setter(EvaluationSearchMetadata.setter(Builder::scorePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScorePercentage").build()}).build();
    private static final SdkField<Boolean> SCORE_AUTOMATIC_FAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ScoreAutomaticFail").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::scoreAutomaticFail)).setter(EvaluationSearchMetadata.setter(Builder::scoreAutomaticFail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreAutomaticFail").build()}).build();
    private static final SdkField<Boolean> SCORE_NOT_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ScoreNotApplicable").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::scoreNotApplicable)).setter(EvaluationSearchMetadata.setter(Builder::scoreNotApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreNotApplicable").build()}).build();
    private static final SdkField<Boolean> AUTO_EVALUATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEvaluationEnabled").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::autoEvaluationEnabled)).setter(EvaluationSearchMetadata.setter(Builder::autoEvaluationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationEnabled").build()}).build();
    private static final SdkField<String> AUTO_EVALUATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoEvaluationStatus").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::autoEvaluationStatusAsString)).setter(EvaluationSearchMetadata.setter(Builder::autoEvaluationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEvaluationStatus").build()}).build();
    private static final SdkField<Instant> ACKNOWLEDGED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AcknowledgedTime").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::acknowledgedTime)).setter(EvaluationSearchMetadata.setter(Builder::acknowledgedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgedTime").build()}).build();
    private static final SdkField<String> ACKNOWLEDGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcknowledgedBy").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::acknowledgedBy)).setter(EvaluationSearchMetadata.setter(Builder::acknowledgedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgedBy").build()}).build();
    private static final SdkField<String> ACKNOWLEDGER_COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcknowledgerComment").getter(EvaluationSearchMetadata.getter(EvaluationSearchMetadata::acknowledgerComment)).setter(EvaluationSearchMetadata.setter(Builder::acknowledgerComment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcknowledgerComment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, EVALUATOR_ARN_FIELD, CONTACT_AGENT_ID_FIELD, CALIBRATION_SESSION_ID_FIELD, SCORE_PERCENTAGE_FIELD, SCORE_AUTOMATIC_FAIL_FIELD, SCORE_NOT_APPLICABLE_FIELD, AUTO_EVALUATION_ENABLED_FIELD, AUTO_EVALUATION_STATUS_FIELD, ACKNOWLEDGED_TIME_FIELD, ACKNOWLEDGED_BY_FIELD, ACKNOWLEDGER_COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationSearchMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final String evaluatorArn;
    private final String contactAgentId;
    private final String calibrationSessionId;
    private final Double scorePercentage;
    private final Boolean scoreAutomaticFail;
    private final Boolean scoreNotApplicable;
    private final Boolean autoEvaluationEnabled;
    private final String autoEvaluationStatus;
    private final Instant acknowledgedTime;
    private final String acknowledgedBy;
    private final String acknowledgerComment;

    private EvaluationSearchMetadata(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.evaluatorArn = builder.evaluatorArn;
        this.contactAgentId = builder.contactAgentId;
        this.calibrationSessionId = builder.calibrationSessionId;
        this.scorePercentage = builder.scorePercentage;
        this.scoreAutomaticFail = builder.scoreAutomaticFail;
        this.scoreNotApplicable = builder.scoreNotApplicable;
        this.autoEvaluationEnabled = builder.autoEvaluationEnabled;
        this.autoEvaluationStatus = builder.autoEvaluationStatus;
        this.acknowledgedTime = builder.acknowledgedTime;
        this.acknowledgedBy = builder.acknowledgedBy;
        this.acknowledgerComment = builder.acknowledgerComment;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String evaluatorArn() {
        return this.evaluatorArn;
    }

    public final String contactAgentId() {
        return this.contactAgentId;
    }

    public final String calibrationSessionId() {
        return this.calibrationSessionId;
    }

    public final Double scorePercentage() {
        return this.scorePercentage;
    }

    public final Boolean scoreAutomaticFail() {
        return this.scoreAutomaticFail;
    }

    public final Boolean scoreNotApplicable() {
        return this.scoreNotApplicable;
    }

    public final Boolean autoEvaluationEnabled() {
        return this.autoEvaluationEnabled;
    }

    public final AutoEvaluationStatus autoEvaluationStatus() {
        return AutoEvaluationStatus.fromValue(this.autoEvaluationStatus);
    }

    public final String autoEvaluationStatusAsString() {
        return this.autoEvaluationStatus;
    }

    public final Instant acknowledgedTime() {
        return this.acknowledgedTime;
    }

    public final String acknowledgedBy() {
        return this.acknowledgedBy;
    }

    public final String acknowledgerComment() {
        return this.acknowledgerComment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.calibrationSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scorePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreAutomaticFail());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreNotApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEvaluationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEvaluationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgerComment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSearchMetadata)) {
            return false;
        }
        EvaluationSearchMetadata other = (EvaluationSearchMetadata)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.evaluatorArn(), other.evaluatorArn()) && Objects.equals(this.contactAgentId(), other.contactAgentId()) && Objects.equals(this.calibrationSessionId(), other.calibrationSessionId()) && Objects.equals(this.scorePercentage(), other.scorePercentage()) && Objects.equals(this.scoreAutomaticFail(), other.scoreAutomaticFail()) && Objects.equals(this.scoreNotApplicable(), other.scoreNotApplicable()) && Objects.equals(this.autoEvaluationEnabled(), other.autoEvaluationEnabled()) && Objects.equals(this.autoEvaluationStatusAsString(), other.autoEvaluationStatusAsString()) && Objects.equals(this.acknowledgedTime(), other.acknowledgedTime()) && Objects.equals(this.acknowledgedBy(), other.acknowledgedBy()) && Objects.equals(this.acknowledgerComment(), other.acknowledgerComment());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationSearchMetadata").add("ContactId", (Object)this.contactId()).add("EvaluatorArn", (Object)this.evaluatorArn()).add("ContactAgentId", (Object)this.contactAgentId()).add("CalibrationSessionId", (Object)this.calibrationSessionId()).add("ScorePercentage", (Object)this.scorePercentage()).add("ScoreAutomaticFail", (Object)this.scoreAutomaticFail()).add("ScoreNotApplicable", (Object)this.scoreNotApplicable()).add("AutoEvaluationEnabled", (Object)this.autoEvaluationEnabled()).add("AutoEvaluationStatus", (Object)this.autoEvaluationStatusAsString()).add("AcknowledgedTime", (Object)this.acknowledgedTime()).add("AcknowledgedBy", (Object)this.acknowledgedBy()).add("AcknowledgerComment", (Object)this.acknowledgerComment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "EvaluatorArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatorArn()));
            }
            case "ContactAgentId": {
                return Optional.ofNullable(clazz.cast(this.contactAgentId()));
            }
            case "CalibrationSessionId": {
                return Optional.ofNullable(clazz.cast(this.calibrationSessionId()));
            }
            case "ScorePercentage": {
                return Optional.ofNullable(clazz.cast(this.scorePercentage()));
            }
            case "ScoreAutomaticFail": {
                return Optional.ofNullable(clazz.cast(this.scoreAutomaticFail()));
            }
            case "ScoreNotApplicable": {
                return Optional.ofNullable(clazz.cast(this.scoreNotApplicable()));
            }
            case "AutoEvaluationEnabled": {
                return Optional.ofNullable(clazz.cast(this.autoEvaluationEnabled()));
            }
            case "AutoEvaluationStatus": {
                return Optional.ofNullable(clazz.cast(this.autoEvaluationStatusAsString()));
            }
            case "AcknowledgedTime": {
                return Optional.ofNullable(clazz.cast(this.acknowledgedTime()));
            }
            case "AcknowledgedBy": {
                return Optional.ofNullable(clazz.cast(this.acknowledgedBy()));
            }
            case "AcknowledgerComment": {
                return Optional.ofNullable(clazz.cast(this.acknowledgerComment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("EvaluatorArn", EVALUATOR_ARN_FIELD);
        map.put("ContactAgentId", CONTACT_AGENT_ID_FIELD);
        map.put("CalibrationSessionId", CALIBRATION_SESSION_ID_FIELD);
        map.put("ScorePercentage", SCORE_PERCENTAGE_FIELD);
        map.put("ScoreAutomaticFail", SCORE_AUTOMATIC_FAIL_FIELD);
        map.put("ScoreNotApplicable", SCORE_NOT_APPLICABLE_FIELD);
        map.put("AutoEvaluationEnabled", AUTO_EVALUATION_ENABLED_FIELD);
        map.put("AutoEvaluationStatus", AUTO_EVALUATION_STATUS_FIELD);
        map.put("AcknowledgedTime", ACKNOWLEDGED_TIME_FIELD);
        map.put("AcknowledgedBy", ACKNOWLEDGED_BY_FIELD);
        map.put("AcknowledgerComment", ACKNOWLEDGER_COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSearchMetadata, T> g) {
        return obj -> g.apply((EvaluationSearchMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private String evaluatorArn;
        private String contactAgentId;
        private String calibrationSessionId;
        private Double scorePercentage;
        private Boolean scoreAutomaticFail;
        private Boolean scoreNotApplicable;
        private Boolean autoEvaluationEnabled;
        private String autoEvaluationStatus;
        private Instant acknowledgedTime;
        private String acknowledgedBy;
        private String acknowledgerComment;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSearchMetadata model) {
            this.contactId(model.contactId);
            this.evaluatorArn(model.evaluatorArn);
            this.contactAgentId(model.contactAgentId);
            this.calibrationSessionId(model.calibrationSessionId);
            this.scorePercentage(model.scorePercentage);
            this.scoreAutomaticFail(model.scoreAutomaticFail);
            this.scoreNotApplicable(model.scoreNotApplicable);
            this.autoEvaluationEnabled(model.autoEvaluationEnabled);
            this.autoEvaluationStatus(model.autoEvaluationStatus);
            this.acknowledgedTime(model.acknowledgedTime);
            this.acknowledgedBy(model.acknowledgedBy);
            this.acknowledgerComment(model.acknowledgerComment);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getEvaluatorArn() {
            return this.evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final String getContactAgentId() {
            return this.contactAgentId;
        }

        public final void setContactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
        }

        @Override
        public final Builder contactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
            return this;
        }

        public final String getCalibrationSessionId() {
            return this.calibrationSessionId;
        }

        public final void setCalibrationSessionId(String calibrationSessionId) {
            this.calibrationSessionId = calibrationSessionId;
        }

        @Override
        public final Builder calibrationSessionId(String calibrationSessionId) {
            this.calibrationSessionId = calibrationSessionId;
            return this;
        }

        public final Double getScorePercentage() {
            return this.scorePercentage;
        }

        public final void setScorePercentage(Double scorePercentage) {
            this.scorePercentage = scorePercentage;
        }

        @Override
        public final Builder scorePercentage(Double scorePercentage) {
            this.scorePercentage = scorePercentage;
            return this;
        }

        public final Boolean getScoreAutomaticFail() {
            return this.scoreAutomaticFail;
        }

        public final void setScoreAutomaticFail(Boolean scoreAutomaticFail) {
            this.scoreAutomaticFail = scoreAutomaticFail;
        }

        @Override
        public final Builder scoreAutomaticFail(Boolean scoreAutomaticFail) {
            this.scoreAutomaticFail = scoreAutomaticFail;
            return this;
        }

        public final Boolean getScoreNotApplicable() {
            return this.scoreNotApplicable;
        }

        public final void setScoreNotApplicable(Boolean scoreNotApplicable) {
            this.scoreNotApplicable = scoreNotApplicable;
        }

        @Override
        public final Builder scoreNotApplicable(Boolean scoreNotApplicable) {
            this.scoreNotApplicable = scoreNotApplicable;
            return this;
        }

        public final Boolean getAutoEvaluationEnabled() {
            return this.autoEvaluationEnabled;
        }

        public final void setAutoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
        }

        @Override
        public final Builder autoEvaluationEnabled(Boolean autoEvaluationEnabled) {
            this.autoEvaluationEnabled = autoEvaluationEnabled;
            return this;
        }

        public final String getAutoEvaluationStatus() {
            return this.autoEvaluationStatus;
        }

        public final void setAutoEvaluationStatus(String autoEvaluationStatus) {
            this.autoEvaluationStatus = autoEvaluationStatus;
        }

        @Override
        public final Builder autoEvaluationStatus(String autoEvaluationStatus) {
            this.autoEvaluationStatus = autoEvaluationStatus;
            return this;
        }

        @Override
        public final Builder autoEvaluationStatus(AutoEvaluationStatus autoEvaluationStatus) {
            this.autoEvaluationStatus(autoEvaluationStatus == null ? null : autoEvaluationStatus.toString());
            return this;
        }

        public final Instant getAcknowledgedTime() {
            return this.acknowledgedTime;
        }

        public final void setAcknowledgedTime(Instant acknowledgedTime) {
            this.acknowledgedTime = acknowledgedTime;
        }

        @Override
        public final Builder acknowledgedTime(Instant acknowledgedTime) {
            this.acknowledgedTime = acknowledgedTime;
            return this;
        }

        public final String getAcknowledgedBy() {
            return this.acknowledgedBy;
        }

        public final void setAcknowledgedBy(String acknowledgedBy) {
            this.acknowledgedBy = acknowledgedBy;
        }

        @Override
        public final Builder acknowledgedBy(String acknowledgedBy) {
            this.acknowledgedBy = acknowledgedBy;
            return this;
        }

        public final String getAcknowledgerComment() {
            return this.acknowledgerComment;
        }

        public final void setAcknowledgerComment(String acknowledgerComment) {
            this.acknowledgerComment = acknowledgerComment;
        }

        @Override
        public final Builder acknowledgerComment(String acknowledgerComment) {
            this.acknowledgerComment = acknowledgerComment;
            return this;
        }

        public EvaluationSearchMetadata build() {
            return new EvaluationSearchMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationSearchMetadata> {
        public Builder contactId(String var1);

        public Builder evaluatorArn(String var1);

        public Builder contactAgentId(String var1);

        public Builder calibrationSessionId(String var1);

        public Builder scorePercentage(Double var1);

        public Builder scoreAutomaticFail(Boolean var1);

        public Builder scoreNotApplicable(Boolean var1);

        public Builder autoEvaluationEnabled(Boolean var1);

        public Builder autoEvaluationStatus(String var1);

        public Builder autoEvaluationStatus(AutoEvaluationStatus var1);

        public Builder acknowledgedTime(Instant var1);

        public Builder acknowledgedBy(String var1);

        public Builder acknowledgerComment(String var1);
    }
}

